/*     */ package org.jboss.ws.core.jaxws;
/*     */ 
/*     */ import com.sun.xml.bind.api.JAXBRIContext;
/*     */ import com.sun.xml.bind.api.TypeReference;
/*     */ import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
/*     */ import java.util.Collection;
/*     */ import javax.xml.bind.JAXBContext;
/*     */ import javax.xml.bind.JAXBException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.wsf.spi.binding.BindingCustomization;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.invocation.EndpointAssociation;
/*     */ 
/*     */ public class CustomizableJAXBContextFactory extends JAXBContextFactory
/*     */ {
/*  56 */   protected Logger log = Logger.getLogger(CustomizableJAXBContextFactory.class);
/*     */ 
/*     */   public JAXBContext createContext(Class clazz) throws WSException
/*     */   {
/*  60 */     return createContext(new Class[] { clazz });
/*     */   }
/*     */ 
/*     */   public JAXBContext createContext(Class[] clazzes) throws WSException
/*     */   {
/*     */     try
/*     */     {
/*  67 */       BindingCustomization customization = getCustomization();
/*     */       JAXBContext jaxbCtx;
/*     */       JAXBContext jaxbCtx;
/*  70 */       if (null == customization)
/*  71 */         jaxbCtx = JAXBContext.newInstance(clazzes);
/*     */       else {
/*  73 */         jaxbCtx = createContext(clazzes, customization);
/*     */       }
/*  75 */       return jaxbCtx;
/*     */     } catch (JAXBException e) {
/*     */     }
/*  78 */     throw new WSException("Failed to create JAXBContext", e);
/*     */   }
/*     */ 
/*     */   public JAXBContext createContext(Class[] clazzes, BindingCustomization bindingCustomization)
/*     */     throws WSException
/*     */   {
/*     */     try
/*     */     {
/*  86 */       return JAXBContext.newInstance(clazzes, bindingCustomization);
/*     */     } catch (JAXBException e) {
/*     */     }
/*  89 */     throw new WSException("Failed to create JAXBContext", e);
/*     */   }
/*     */ 
/*     */   public JAXBRIContext createContext(Class[] classes, Collection<TypeReference> typeReferences, String defaultNamespaceRemap, boolean c14nSupport, BindingCustomization bindingCustomization)
/*     */   {
/*     */     try
/*     */     {
/*  99 */       RuntimeAnnotationReader runtimeAnnotations = bindingCustomization != null ? (RuntimeAnnotationReader)bindingCustomization.get(JAXBRIContext.ANNOTATION_READER) : null;
/*     */ 
/* 102 */       return JAXBRIContext.newInstance(classes, typeReferences, null, defaultNamespaceRemap, c14nSupport, runtimeAnnotations);
/*     */     }
/*     */     catch (JAXBException e)
/*     */     {
/*     */     }
/*     */ 
/* 111 */     throw new WSException("Failed to create JAXBContext", e);
/*     */   }
/*     */ 
/*     */   private BindingCustomization getCustomization()
/*     */   {
/* 117 */     Endpoint threadLocal = EndpointAssociation.getEndpoint();
/* 118 */     return threadLocal != null ? (BindingCustomization)threadLocal.getAttachment(BindingCustomization.class) : null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxws.CustomizableJAXBContextFactory
 * JD-Core Version:    0.6.0
 */