/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.io.BufferedReader;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.net.URL;
/*     */ import java.net.URLEncoder;
/*     */ import java.rmi.Remote;
/*     */ import java.util.Hashtable;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.Service;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.client.ServiceObjectFactory;
/*     */ import org.jboss.ws.core.server.PortComponentResolver;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMappingFactory;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.management.EndpointRegistry;
/*     */ import org.jboss.wsf.spi.management.EndpointRegistryFactory;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ 
/*     */ public class ServiceObjectFactoryJAXRPC extends ServiceObjectFactory
/*     */ {
/*  83 */   private static final Logger log = Logger.getLogger(ServiceObjectFactoryJAXRPC.class);
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 109 */       Reference ref = (Reference)obj;
/*     */ 
/* 112 */       UnifiedServiceRefMetaData serviceRef = null;
/* 113 */       RefAddr metaRefAddr = ref.get("SERVICE_REF_META_DATA");
/* 114 */       ByteArrayInputStream bais = new ByteArrayInputStream((byte[])(byte[])metaRefAddr.getContent());
/*     */       try
/*     */       {
/* 117 */         ObjectInputStream ois = new ObjectInputStream(bais);
/* 118 */         serviceRef = (UnifiedServiceRefMetaData)ois.readObject();
/* 119 */         ois.close();
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 123 */         NamingException ne = new NamingException("Cannot unmarshall service ref meta data");
/* 124 */         ne.setRootCause(ex);
/* 125 */         throw ne;
/*     */       }
/*     */ 
/* 129 */       WSSecurityConfiguration securityConfig = null;
/* 130 */       RefAddr wsseRefAddr = ref.get("SECURITY_CONFIG");
/* 131 */       if (wsseRefAddr != null)
/*     */       {
/* 133 */         bais = new ByteArrayInputStream((byte[])(byte[])wsseRefAddr.getContent());
/*     */         try
/*     */         {
/* 136 */           ObjectInputStream ois = new ObjectInputStream(bais);
/* 137 */           securityConfig = (WSSecurityConfiguration)ois.readObject();
/* 138 */           ois.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 142 */           throw new NamingException("Cannot unmarshall security config, cause: " + e.toString());
/*     */         }
/*     */       }
/*     */ 
/* 146 */       ServiceImpl jaxrpcService = null;
/* 147 */       URL wsdlLocation = serviceRef.getWsdlLocation();
/* 148 */       if (wsdlLocation != null)
/*     */       {
/* 150 */         if (log.isDebugEnabled()) {
/* 151 */           log.debug("Create jaxrpc service from wsdl");
/*     */         }
/*     */ 
/* 154 */         QName serviceName = serviceRef.getServiceQName();
/* 155 */         JavaWsdlMapping javaWsdlMapping = getJavaWsdlMapping(serviceRef);
/* 156 */         jaxrpcService = new ServiceImpl(serviceName, wsdlLocation, javaWsdlMapping, securityConfig, serviceRef);
/*     */       }
/*     */       else
/*     */       {
/* 160 */         if (log.isDebugEnabled())
/* 161 */           log.debug("Create jaxrpc service with no wsdl");
/* 162 */         jaxrpcService = new ServiceImpl(new QName("http://www.jboss.org/jbossws", "AnonymousService"));
/*     */       }
/*     */ 
/* 165 */       ServiceMetaData serviceMetaData = jaxrpcService.getServiceMetaData();
/*     */       Properties callProps;
/* 168 */       if (serviceRef.getCallProperties().size() > 0)
/*     */       {
/* 170 */         callProps = new Properties();
/* 171 */         serviceMetaData.setProperties(callProps);
/* 172 */         for (UnifiedCallPropertyMetaData prop : serviceRef.getCallProperties()) {
/* 173 */           callProps.setProperty(prop.getPropName(), prop.getPropValue());
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 178 */       RefAddr pcLinkRef = ref.get("PORT_COMPONENT_LINK");
/* 179 */       if (pcLinkRef != null)
/*     */       {
/* 181 */         String pcLink = (String)pcLinkRef.getContent();
/* 182 */         log.debug("Resolving port-component-link: " + pcLink);
/*     */ 
/* 185 */         String endpointAddress = null;
/*     */         try
/*     */         {
/* 188 */           SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/* 189 */           EndpointRegistry epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
/* 190 */           Endpoint endpoint = epRegistry.resolve(new PortComponentResolver(pcLink));
/* 191 */           if (endpoint == null) {
/* 192 */             throw new WSException("Cannot resolve port-component-link: " + pcLink);
/*     */           }
/* 194 */           ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)endpoint.getAttachment(ServerEndpointMetaData.class);
/* 195 */           endpointAddress = sepMetaData.getEndpointAddress();
/*     */         }
/*     */         catch (Throwable ex)
/*     */         {
/*     */         }
/*     */ 
/* 203 */         if (endpointAddress == null)
/*     */         {
/* 205 */           String servletPath = (String)ref.get("PORT_COMPONENT_LINK_SERVLET").getContent();
/* 206 */           servletPath = servletPath + "?pcLink=" + URLEncoder.encode(pcLink, "UTF-8");
/* 207 */           InputStream is = new URL(servletPath).openStream();
/* 208 */           BufferedReader br = new BufferedReader(new InputStreamReader(is));
/* 209 */           endpointAddress = br.readLine();
/* 210 */           is.close();
/*     */         }
/*     */ 
/* 213 */         if (log.isDebugEnabled())
/* 214 */           log.debug("Resolved to: " + endpointAddress);
/* 215 */         if (serviceMetaData.getEndpoints().size() == 1)
/*     */         {
/* 217 */           EndpointMetaData epMetaData = (EndpointMetaData)serviceMetaData.getEndpoints().get(0);
/* 218 */           epMetaData.setEndpointAddress(endpointAddress);
/*     */         }
/*     */         else
/*     */         {
/* 222 */           log.warn("Cannot set endpoint address for port-component-link, unsuported number of endpoints");
/*     */         }
/*     */       }
/*     */ 
/* 226 */       narrowPortSelection(serviceRef, serviceMetaData);
/*     */ 
/* 233 */       ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
/* 234 */       Class siClass = contextCL.loadClass(serviceRef.getServiceInterface());
/* 235 */       if (!Service.class.isAssignableFrom(siClass)) {
/* 236 */         throw new JAXRPCException("The service interface does not implement javax.xml.rpc.Service: " + siClass.getName());
/*     */       }
/*     */ 
/* 239 */       for (UnifiedPortComponentRefMetaData pcr : serviceRef.getPortComponentRefs())
/*     */       {
/* 241 */         String seiName = pcr.getServiceEndpointInterface();
/* 242 */         if (seiName != null)
/*     */         {
/* 244 */           Class seiClass = contextCL.loadClass(seiName);
/* 245 */           if (!Remote.class.isAssignableFrom(seiClass)) {
/* 246 */             throw new IllegalArgumentException("The SEI does not implement java.rmi.Remote: " + seiClass.getName());
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 251 */       setupHandlerChain(jaxrpcService);
/*     */ 
/* 253 */       InvocationHandler handler = new ServiceProxy(jaxrpcService, siClass);
/* 254 */       return Proxy.newProxyInstance(contextCL, new Class[] { siClass, ServiceExt.class }, handler);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 258 */       log.error("Cannot create service", ex);
/* 259 */     }throw ex;
/*     */   }
/*     */ 
/*     */   private void setupHandlerChain(ServiceImpl jaxrpcService)
/*     */     throws Exception
/*     */   {
/* 268 */     List endpoints = jaxrpcService.getServiceMetaData().getEndpoints();
/* 269 */     for (EndpointMetaData epMetaData : endpoints)
/*     */     {
/* 271 */       jaxrpcService.setupHandlerChain(epMetaData);
/*     */     }
/*     */   }
/*     */ 
/*     */   private JavaWsdlMapping getJavaWsdlMapping(UnifiedServiceRefMetaData serviceRef)
/*     */   {
/* 277 */     JavaWsdlMapping javaWsdlMapping = null;
/* 278 */     if (serviceRef.getMappingFile() != null)
/*     */     {
/* 280 */       String mappingFile = serviceRef.getMappingFile();
/*     */       try
/*     */       {
/* 283 */         JavaWsdlMappingFactory mappingFactory = JavaWsdlMappingFactory.newInstance();
/* 284 */         URL mappingURL = serviceRef.getVfsRoot().findChild(mappingFile).toURL();
/* 285 */         javaWsdlMapping = mappingFactory.parse(mappingURL);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 289 */         throw new WSException("Cannot unmarshal jaxrpc-mapping-file: " + mappingFile, e);
/*     */       }
/*     */     }
/* 292 */     return javaWsdlMapping;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.ServiceObjectFactoryJAXRPC
 * JD-Core Version:    0.6.0
 */