/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.lang.reflect.Proxy;
/*     */ import java.net.URL;
/*     */ import java.rmi.Remote;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.Call;
/*     */ import javax.xml.rpc.ServiceException;
/*     */ import javax.xml.rpc.Stub;
/*     */ import javax.xml.rpc.encoding.TypeMappingRegistry;
/*     */ import javax.xml.rpc.handler.HandlerChain;
/*     */ import javax.xml.rpc.handler.HandlerInfo;
/*     */ import javax.xml.rpc.handler.HandlerRegistry;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.StubExt;
/*     */ import org.jboss.ws.metadata.builder.jaxrpc.JAXRPCClientMetaDataBuilder;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaData;
/*     */ import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXRPC;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
/*     */ 
/*     */ public class ServiceImpl
/*     */   implements ServiceExt
/*     */ {
/*  79 */   private static final Logger log = Logger.getLogger(ServiceImpl.class);
/*     */   private ServiceMetaData serviceMetaData;
/*     */   private URL wsdlLocation;
/*     */   private UnifiedServiceRefMetaData usrMetaData;
/*     */   private HandlerRegistryImpl handlerRegistry;
/*     */ 
/*     */   ServiceImpl(QName serviceName)
/*     */   {
/*  96 */     UnifiedMetaData wsMetaData = new UnifiedMetaData(new ResourceLoaderAdapter());
/*  97 */     this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
/*  98 */     this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
/*     */   }
/*     */ 
/*     */   ServiceImpl(QName serviceName, URL wsdlURL, URL mappingURL, URL securityURL)
/*     */   {
/* 106 */     this.wsdlLocation = wsdlURL;
/* 107 */     JAXRPCClientMetaDataBuilder builder = new JAXRPCClientMetaDataBuilder();
/*     */ 
/* 109 */     ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 111 */     this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityURL, null, ctxClassLoader);
/* 112 */     this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
/*     */   }
/*     */ 
/*     */   ServiceImpl(QName serviceName, URL wsdlURL, JavaWsdlMapping mappingURL, WSSecurityConfiguration securityConfig, UnifiedServiceRefMetaData usrMetaData)
/*     */   {
/* 120 */     this.wsdlLocation = wsdlURL;
/* 121 */     this.usrMetaData = usrMetaData;
/*     */ 
/* 123 */     JAXRPCClientMetaDataBuilder builder = new JAXRPCClientMetaDataBuilder();
/* 124 */     ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 126 */     this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, mappingURL, securityConfig, usrMetaData, ctxClassLoader);
/* 127 */     this.handlerRegistry = new HandlerRegistryImpl(this.serviceMetaData);
/*     */   }
/*     */ 
/*     */   public ServiceMetaData getServiceMetaData()
/*     */   {
/* 132 */     return this.serviceMetaData;
/*     */   }
/*     */ 
/*     */   public URL getWSDLDocumentLocation()
/*     */   {
/* 142 */     return this.wsdlLocation;
/*     */   }
/*     */ 
/*     */   public QName getServiceName()
/*     */   {
/* 152 */     return this.serviceMetaData.getServiceName();
/*     */   }
/*     */ 
/*     */   public Call createCall(QName portName)
/*     */     throws ServiceException
/*     */   {
/* 166 */     String nsURI = portName.getNamespaceURI();
/* 167 */     this.serviceMetaData.assertTargetNamespace(nsURI);
/* 168 */     CallImpl call = new CallImpl(this, portName, null);
/* 169 */     initCallProperties(call, null);
/* 170 */     return call;
/*     */   }
/*     */ 
/*     */   public Call createCall(QName portName, String operationName)
/*     */     throws ServiceException
/*     */   {
/* 187 */     String nsURI = portName.getNamespaceURI();
/* 188 */     this.serviceMetaData.assertTargetNamespace(nsURI);
/* 189 */     QName opName = new QName(nsURI, operationName);
/* 190 */     CallImpl call = new CallImpl(this, portName, opName);
/* 191 */     initCallProperties(call, null);
/* 192 */     return call;
/*     */   }
/*     */ 
/*     */   public Call createCall(QName portName, QName opName)
/*     */     throws ServiceException
/*     */   {
/* 209 */     this.serviceMetaData.assertTargetNamespace(portName.getNamespaceURI());
/* 210 */     this.serviceMetaData.assertTargetNamespace(opName.getNamespaceURI());
/* 211 */     CallImpl call = new CallImpl(this, portName, opName);
/* 212 */     initCallProperties(call, null);
/* 213 */     return call;
/*     */   }
/*     */ 
/*     */   public Call createCall()
/*     */     throws ServiceException
/*     */   {
/* 227 */     CallImpl call = new CallImpl(this);
/* 228 */     initCallProperties(call, null);
/* 229 */     return call;
/*     */   }
/*     */ 
/*     */   public Call[] getCalls(QName portName)
/*     */     throws ServiceException
/*     */   {
/* 250 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
/* 251 */     if (epMetaData == null) {
/* 252 */       throw new ServiceException("Cannot find endpoint for name: " + portName);
/*     */     }
/* 254 */     List calls = new ArrayList();
/* 255 */     for (OperationMetaData opMetaData : epMetaData.getOperations())
/*     */     {
/* 257 */       Call call = createCall(portName, opMetaData.getQName());
/* 258 */       calls.add(call);
/*     */     }
/*     */ 
/* 261 */     Call[] callArr = new Call[calls.size()];
/* 262 */     calls.toArray(callArr);
/*     */ 
/* 264 */     return callArr;
/*     */   }
/*     */ 
/*     */   public HandlerRegistry getHandlerRegistry()
/*     */   {
/* 275 */     throw new UnsupportedOperationException("Components should not use the getHandlerRegistry() method.");
/*     */   }
/*     */ 
/*     */   public HandlerRegistry getDynamicHandlerRegistry()
/*     */   {
/* 284 */     return this.handlerRegistry;
/*     */   }
/*     */ 
/*     */   public TypeMappingRegistry getTypeMappingRegistry()
/*     */   {
/* 294 */     throw new UnsupportedOperationException("Components should not use the getTypeMappingRegistry() method.");
/*     */   }
/*     */ 
/*     */   public Iterator getPorts()
/*     */     throws ServiceException
/*     */   {
/* 309 */     ArrayList list = new ArrayList();
/* 310 */     if (this.serviceMetaData != null)
/*     */     {
/* 312 */       for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints())
/*     */       {
/* 314 */         list.add(epMetaData.getPortName());
/*     */       }
/*     */     }
/* 317 */     return list.iterator();
/*     */   }
/*     */ 
/*     */   public Remote getPort(Class seiClass)
/*     */     throws ServiceException
/*     */   {
/* 331 */     if (seiClass == null) {
/* 332 */       throw new IllegalArgumentException("SEI class cannot be null");
/*     */     }
/* 334 */     String seiName = seiClass.getName();
/* 335 */     if (!Remote.class.isAssignableFrom(seiClass)) {
/* 336 */       throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
/*     */     }
/* 338 */     if (this.serviceMetaData == null) {
/* 339 */       throw new ServiceException("Service meta data not available");
/*     */     }
/*     */     try
/*     */     {
/* 343 */       EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiName);
/* 344 */       if ((epMetaData == null) && (this.serviceMetaData.getEndpoints().size() == 1))
/*     */       {
/* 346 */         epMetaData = (EndpointMetaData)this.serviceMetaData.getEndpoints().get(0);
/* 347 */         epMetaData.setServiceEndpointInterfaceName(seiName);
/*     */       }
/*     */ 
/* 350 */       if (epMetaData == null) {
/* 351 */         throw new ServiceException("Cannot find endpoint meta data for: " + seiName);
/*     */       }
/* 353 */       return createProxy(seiClass, epMetaData);
/*     */     }
/*     */     catch (ServiceException ex)
/*     */     {
/* 357 */       throw ex;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 361 */     throw new ServiceException("Cannot create proxy", ex);
/*     */   }
/*     */ 
/*     */   public Remote getPort(QName portName, Class seiClass)
/*     */     throws ServiceException
/*     */   {
/* 374 */     if (seiClass == null) {
/* 375 */       throw new IllegalArgumentException("SEI class cannot be null");
/*     */     }
/* 377 */     if (this.serviceMetaData == null) {
/* 378 */       throw new ServiceException("Service meta data not available");
/*     */     }
/* 380 */     String seiName = seiClass.getName();
/* 381 */     if (!Remote.class.isAssignableFrom(seiClass)) {
/* 382 */       throw new ServiceException("SEI does not implement java.rmi.Remote: " + seiName);
/*     */     }
/* 384 */     EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
/* 385 */     if (epMetaData == null) {
/* 386 */       throw new ServiceException("Cannot obtain endpoint meta data for: " + portName);
/*     */     }
/*     */     try
/*     */     {
/* 390 */       if (epMetaData.getServiceEndpointInterfaceName() == null) {
/* 391 */         epMetaData.setServiceEndpointInterfaceName(seiName);
/*     */       }
/* 393 */       return createProxy(seiClass, epMetaData);
/*     */     }
/*     */     catch (ServiceException ex)
/*     */     {
/* 397 */       throw ex;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 401 */     throw new ServiceException("Cannot create proxy", ex);
/*     */   }
/*     */ 
/*     */   private Remote createProxy(Class seiClass, EndpointMetaData epMetaData)
/*     */     throws Exception
/*     */   {
/* 407 */     CallImpl call = new CallImpl(this, epMetaData);
/* 408 */     initStubProperties(call, seiClass.getName());
/*     */ 
/* 411 */     if (initCallProperties(call, seiClass.getName()) > 0) {
/* 412 */       log.info("Deprecated use of <call-properties> on JAXRPC Stub. Use <stub-properties>");
/*     */     }
/* 414 */     PortProxy handler = new PortProxy(call);
/* 415 */     ClassLoader cl = epMetaData.getClassLoader();
/* 416 */     Remote proxy = (Remote)Proxy.newProxyInstance(cl, new Class[] { seiClass, Stub.class, StubExt.class }, handler);
/*     */ 
/* 419 */     setupHandlerChain(epMetaData);
/*     */ 
/* 421 */     return proxy;
/*     */   }
/*     */ 
/*     */   private int initStubProperties(CallImpl call, String seiName)
/*     */   {
/* 427 */     if (this.usrMetaData == null) {
/* 428 */       return 0;
/*     */     }
/* 430 */     int propCount = 0;
/* 431 */     for (UnifiedPortComponentRefMetaData upcRef : this.usrMetaData.getPortComponentRefs())
/*     */     {
/* 433 */       if (seiName.equals(upcRef.getServiceEndpointInterface()))
/*     */       {
/* 435 */         for (UnifiedStubPropertyMetaData prop : upcRef.getStubProperties())
/*     */         {
/* 437 */           call.setProperty(prop.getPropName(), prop.getPropValue());
/* 438 */           propCount++;
/*     */         }
/*     */       }
/*     */     }
/* 442 */     return propCount;
/*     */   }
/*     */ 
/*     */   private int initCallProperties(CallImpl call, String seiName)
/*     */   {
/* 447 */     setupHandlerChain(call.getEndpointMetaData());
/*     */ 
/* 450 */     if (this.usrMetaData == null) {
/* 451 */       return 0;
/*     */     }
/* 453 */     int propCount = 0;
/*     */ 
/* 456 */     for (UnifiedCallPropertyMetaData prop : this.usrMetaData.getCallProperties())
/*     */     {
/* 458 */       call.setProperty(prop.getPropName(), prop.getPropValue());
/* 459 */       propCount++;
/*     */     }
/*     */ 
/* 462 */     if (seiName != null)
/*     */     {
/* 464 */       for (UnifiedPortComponentRefMetaData upcRef : this.usrMetaData.getPortComponentRefs())
/*     */       {
/* 466 */         if (seiName.equals(upcRef.getServiceEndpointInterface()))
/*     */         {
/* 468 */           for (UnifiedCallPropertyMetaData prop : upcRef.getCallProperties())
/*     */           {
/* 470 */             call.setProperty(prop.getPropName(), prop.getPropValue());
/* 471 */             propCount++;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 477 */     return propCount;
/*     */   }
/*     */ 
/*     */   public HandlerChain getHandlerChain(QName portName)
/*     */   {
/* 485 */     return this.handlerRegistry.getHandlerChainInstance(portName);
/*     */   }
/*     */ 
/*     */   public void registerHandlerChain(QName portName, List infos, Set roles)
/*     */   {
/* 493 */     this.handlerRegistry.registerClientHandlerChain(portName, infos, roles);
/*     */   }
/*     */ 
/*     */   void setupHandlerChain(EndpointMetaData epMetaData)
/*     */   {
/* 498 */     if (!epMetaData.isHandlersInitialized())
/*     */     {
/* 500 */       QName portName = epMetaData.getPortName();
/* 501 */       Set handlerRoles = new HashSet();
/* 502 */       List handlerInfos = new ArrayList();
/* 503 */       for (HandlerMetaData handlerMetaData : epMetaData.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL))
/*     */       {
/* 505 */         HandlerMetaDataJAXRPC jaxrpcMetaData = (HandlerMetaDataJAXRPC)handlerMetaData;
/* 506 */         handlerRoles.addAll(jaxrpcMetaData.getSoapRoles());
/*     */ 
/* 508 */         HashMap hConfig = new HashMap();
/* 509 */         for (UnifiedInitParamMetaData param : jaxrpcMetaData.getInitParams())
/*     */         {
/* 511 */           hConfig.put(param.getParamName(), param.getParamValue());
/*     */         }
/*     */ 
/* 514 */         Set headers = jaxrpcMetaData.getSoapHeaders();
/* 515 */         QName[] headerArr = new QName[headers.size()];
/* 516 */         headers.toArray(headerArr);
/*     */ 
/* 518 */         Class hClass = jaxrpcMetaData.getHandlerClass();
/* 519 */         hConfig.put(UnifiedHandlerMetaData.HandlerType.class.getName(), jaxrpcMetaData.getHandlerType());
/* 520 */         HandlerInfo info = new HandlerInfo(hClass, hConfig, headerArr);
/*     */ 
/* 522 */         log.debug("Adding client side handler to endpoint '" + portName + "': " + info);
/* 523 */         handlerInfos.add(info);
/*     */       }
/*     */ 
/* 527 */       if (handlerInfos.size() > 0) {
/* 528 */         registerHandlerChain(portName, handlerInfos, handlerRoles);
/*     */       }
/* 530 */       epMetaData.setHandlersInitialized(true);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.ServiceImpl
 * JD-Core Version:    0.6.0
 */