/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.lang.reflect.InvocationHandler;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.Stub;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.StubExt;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class PortProxy
/*     */   implements InvocationHandler
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(PortProxy.class);
/*     */   private CallImpl call;
/*     */   private List stubMethods;
/*     */   private List objectMethods;
/*  67 */   private static final Set<String> standardProperties = new HashSet();
/*     */   private static final Map<String, String> legacyPropertyMap;
/*     */ 
/*     */   public PortProxy(CallImpl call)
/*     */   {
/*  91 */     this.call = call;
/*  92 */     this.stubMethods = new ArrayList(Arrays.asList(StubExt.class.getMethods()));
/*  93 */     this.stubMethods.addAll(Arrays.asList(Stub.class.getMethods()));
/*  94 */     this.objectMethods = Arrays.asList(Object.class.getMethods());
/*     */   }
/*     */ 
/*     */   public Object invoke(Object proxy, Method method, Object[] args)
/*     */     throws Throwable
/*     */   {
/* 102 */     String methodName = method.getName();
/* 103 */     if (this.stubMethods.contains(method))
/*     */     {
/* 105 */       if (methodName.equals("_getPropertyNames"))
/*     */       {
/* 107 */         return this.call.getPropertyNames();
/*     */       }
/* 109 */       if (methodName.equals("_getProperty"))
/*     */       {
/* 111 */         return getProperty((String)args[0]);
/*     */       }
/* 113 */       if (methodName.equals("_setProperty"))
/*     */       {
/* 115 */         setProperty((String)args[0], args[1]);
/* 116 */         return null;
/*     */       }
/*     */ 
/* 120 */       Method callMethod = CallImpl.class.getMethod(methodName, method.getParameterTypes());
/* 121 */       return callMethod.invoke(this.call, args);
/*     */     }
/*     */ 
/* 126 */     if (this.objectMethods.contains(method))
/*     */     {
/* 128 */       Method callMethod = CallImpl.class.getMethod(methodName, method.getParameterTypes());
/* 129 */       return callMethod.invoke(this.call, args);
/*     */     }
/*     */ 
/* 135 */     EndpointMetaData epMetaData = this.call.getEndpointMetaData();
/* 136 */     OperationMetaData opMetaData = epMetaData.getOperation(method);
/* 137 */     if (opMetaData == null) {
/* 138 */       throw new WSException("Cannot obtain operation meta data for: " + methodName);
/*     */     }
/* 140 */     this.call.setOperationName(opMetaData.getQName());
/*     */     try
/*     */     {
/* 144 */       if (opMetaData.isOneWay())
/*     */       {
/* 146 */         this.call.invokeOneWay(args);
/* 147 */         return null;
/*     */       }
/*     */ 
/* 151 */       Object retObj = this.call.invoke(args);
/* 152 */       if (retObj != null)
/*     */       {
/* 154 */         Class retType = method.getReturnType();
/* 155 */         if (retType == null) {
/* 156 */           throw new WSException("Return value not supported by: " + opMetaData);
/*     */         }
/* 158 */         if (JavaUtils.isPrimitive(retType))
/* 159 */           retObj = JavaUtils.getPrimitiveValueArray(retObj);
/*     */       }
/* 161 */       return retObj;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 166 */       handleException(ex);
/* 167 */     }return null;
/*     */   }
/*     */ 
/*     */   private Object getProperty(String name)
/*     */   {
/* 174 */     name = assertPropertyName(name);
/* 175 */     return this.call.getProperty(name);
/*     */   }
/*     */ 
/*     */   private void setProperty(String name, Object value)
/*     */   {
/* 180 */     name = assertPropertyName(name);
/* 181 */     this.call.setProperty(name, value);
/*     */   }
/*     */ 
/*     */   private String assertPropertyName(String name)
/*     */   {
/* 186 */     if ((name != null) && (name.startsWith("javax.xml.rpc")) && (!standardProperties.contains(name))) {
/* 187 */       throw new JAXRPCException("Unsupported property: " + name);
/*     */     }
/* 189 */     if (legacyPropertyMap.keySet().contains(name))
/*     */     {
/* 191 */       String jbosswsName = (String)legacyPropertyMap.get(name);
/* 192 */       log.warn("Legacy propery '" + name + "' mapped to '" + jbosswsName + "'");
/* 193 */       name = jbosswsName;
/*     */     }
/*     */ 
/* 196 */     return name;
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex) throws Throwable
/*     */   {
/* 201 */     Throwable th = ex;
/* 202 */     if (((ex instanceof RemoteException)) && ((ex.getCause() instanceof SOAPFaultException)))
/*     */     {
/* 204 */       SOAPFaultException faultEx = (SOAPFaultException)ex.getCause();
/* 205 */       if (faultEx.getCause() != null)
/* 206 */         th = faultEx.getCause();
/*     */     }
/* 208 */     throw th;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  70 */     standardProperties.add("javax.xml.rpc.service.endpoint.address");
/*  71 */     standardProperties.add("javax.xml.rpc.session.maintain");
/*  72 */     standardProperties.add("javax.xml.rpc.security.auth.username");
/*  73 */     standardProperties.add("javax.xml.rpc.security.auth.password");
/*     */ 
/*  77 */     legacyPropertyMap = new HashMap();
/*     */ 
/*  80 */     legacyPropertyMap.put("org.jboss.webservice.client.timeout", "org.jboss.ws.timeout");
/*  81 */     legacyPropertyMap.put("org.jboss.webservice.keyStore", "org.jboss.ws.keyStore");
/*  82 */     legacyPropertyMap.put("org.jboss.webservice.keyStorePassword", "org.jboss.ws.keyStorePassword");
/*  83 */     legacyPropertyMap.put("org.jboss.webservice.keyStoreType", "org.jboss.ws.keyStoreType");
/*  84 */     legacyPropertyMap.put("org.jboss.webservice.trustStore", "org.jboss.ws.trustStore");
/*  85 */     legacyPropertyMap.put("org.jboss.webservice.trustStorePassword", "org.jboss.ws.trustStorePassword");
/*  86 */     legacyPropertyMap.put("org.jboss.webservice.trustStoreType", "org.jboss.ws.trustStoreType");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.PortProxy
 * JD-Core Version:    0.6.0
 */