/*     */ package org.jboss.ws.core.jaxrpc.client;
/*     */ 
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.Call;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.rpc.ServiceException;
/*     */ import javax.xml.rpc.encoding.SerializerFactory;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.CommonBindingProvider;
/*     */ import org.jboss.ws.core.CommonClient;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.EndpointInvocation;
/*     */ import org.jboss.ws.core.RoleSource;
/*     */ import org.jboss.ws.core.WSTimeoutException;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.SchemaGenerator;
/*     */ import org.jboss.ws.core.jaxrpc.UnqualifiedCallParameter;
/*     */ import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.handler.HandlerChainBaseImpl;
/*     */ import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
/*     */ import org.jboss.ws.core.jaxrpc.handler.SOAPMessageContextJAXRPC;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public class CallImpl extends CommonClient
/*     */   implements Call, RoleSource
/*     */ {
/*  85 */   private static Logger log = Logger.getLogger(CallImpl.class);
/*     */   private ServiceImpl jaxrpcService;
/*     */   private QName portType;
/*  92 */   private Map<String, Object> properties = new HashMap();
/*     */ 
/*  95 */   private static final Set<String> standardProperties = new HashSet();
/*     */ 
/*     */   CallImpl(ServiceImpl service)
/*     */   {
/* 116 */     super(service.getServiceMetaData());
/* 117 */     this.jaxrpcService = service;
/*     */ 
/* 119 */     if (this.epMetaData != null)
/* 120 */       setTargetEndpointAddress(this.epMetaData.getEndpointAddress());
/*     */   }
/*     */ 
/*     */   CallImpl(ServiceImpl service, EndpointMetaData epMetaData)
/*     */   {
/* 129 */     super(epMetaData);
/* 130 */     this.jaxrpcService = service;
/*     */ 
/* 132 */     setTargetEndpointAddress(epMetaData.getEndpointAddress());
/*     */   }
/*     */ 
/*     */   CallImpl(ServiceImpl service, QName portName, QName opName)
/*     */     throws ServiceException
/*     */   {
/* 142 */     super(service.getServiceMetaData(), portName, opName);
/* 143 */     this.jaxrpcService = service;
/*     */ 
/* 145 */     if (this.epMetaData != null)
/* 146 */       setTargetEndpointAddress(this.epMetaData.getEndpointAddress());
/*     */   }
/*     */ 
/*     */   public ServiceImpl getServiceImpl()
/*     */   {
/* 151 */     return this.jaxrpcService;
/*     */   }
/*     */ 
/*     */   protected Map<String, Object> getRequestContext()
/*     */   {
/* 157 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public String getTargetEndpointAddress()
/*     */   {
/* 164 */     return (String)this.properties.get("javax.xml.rpc.service.endpoint.address");
/*     */   }
/*     */ 
/*     */   public void setTargetEndpointAddress(String address)
/*     */   {
/* 174 */     this.properties.put("javax.xml.rpc.service.endpoint.address", address);
/*     */   }
/*     */ 
/*     */   public void addParameter(String paramName, QName xmlType, ParameterMode parameterMode)
/*     */   {
/* 181 */     TypeMappingImpl typeMapping = getEndpointMetaData().getServiceMetaData().getTypeMapping();
/* 182 */     Class javaType = typeMapping.getJavaType(xmlType);
/*     */ 
/* 188 */     if (javaType == null)
/*     */     {
/* 190 */       log.warn("Register unqualified call parameter for: " + xmlType);
/* 191 */       javaType = new UnqualifiedCallParameter(xmlType).getClass();
/* 192 */       typeMapping.register(javaType, xmlType, null, null);
/*     */     }
/*     */ 
/* 195 */     addParameter(paramName, xmlType, javaType, parameterMode);
/*     */   }
/*     */ 
/*     */   public void addParameter(String paramName, QName xmlType, Class javaType, ParameterMode mode)
/*     */   {
/* 202 */     QName xmlName = new QName(paramName);
/* 203 */     addParameter(xmlName, xmlType, javaType, mode, false);
/*     */   }
/*     */ 
/*     */   public void addParameter(QName xmlName, QName xmlType, Class javaType, ParameterMode mode, boolean inHeader)
/*     */   {
/* 211 */     if ((xmlType == null) || (javaType == null)) {
/* 212 */       throw new IllegalArgumentException("Invalid null parameter");
/*     */     }
/* 214 */     OperationMetaData opMetaData = getOperationMetaData();
/* 215 */     ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaType.getName());
/* 216 */     paramMetaData.setMode(mode);
/* 217 */     paramMetaData.setInHeader(inHeader);
/* 218 */     paramMetaData.setIndex(opMetaData.getParameters().size());
/* 219 */     opMetaData.addParameter(paramMetaData);
/*     */ 
/* 221 */     registerParameterType(xmlType, javaType);
/*     */   }
/*     */ 
/*     */   public void removeAllParameters()
/*     */   {
/* 231 */     OperationMetaData opMetaData = getOperationMetaData();
/* 232 */     opMetaData.removeAllParameters();
/*     */   }
/*     */ 
/*     */   public void setReturnType(QName xmlType)
/*     */   {
/* 239 */     Class javaType = getEndpointMetaData().getServiceMetaData().getTypeMapping().getJavaType(xmlType);
/* 240 */     setReturnType(xmlType, javaType);
/*     */   }
/*     */ 
/*     */   public void setReturnType(QName xmlType, Class javaType)
/*     */   {
/* 247 */     if ((xmlType == null) || (javaType == null)) {
/* 248 */       throw new IllegalArgumentException("Invalid null parameter");
/*     */     }
/* 250 */     OperationMetaData opMetaData = getOperationMetaData();
/* 251 */     QName xmlName = new QName("result");
/* 252 */     String javaTypeName = javaType.getName();
/* 253 */     ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
/* 254 */     opMetaData.setReturnParameter(retMetaData);
/*     */ 
/* 256 */     registerParameterType(xmlType, javaType);
/*     */   }
/*     */ 
/*     */   public void invokeOneWay(Object[] inputParams)
/*     */   {
/*     */     try
/*     */     {
/* 265 */       invokeInternal(this.operationName, inputParams, true);
/*     */     }
/*     */     catch (RemoteException ex)
/*     */     {
/* 269 */       throw new JAXRPCException(ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object invoke(Object[] inputParams)
/*     */     throws RemoteException
/*     */   {
/* 277 */     return invokeInternal(this.operationName, inputParams, false);
/*     */   }
/*     */ 
/*     */   public Object invoke(QName operationName, Object[] inputParams)
/*     */     throws RemoteException
/*     */   {
/* 284 */     return invokeInternal(operationName, inputParams, false);
/*     */   }
/*     */ 
/*     */   protected CommonMessageContext processPivot(CommonMessageContext requestContext)
/*     */   {
/* 289 */     return MessageContextJAXRPC.processPivot(requestContext);
/*     */   }
/*     */ 
/*     */   public List getOutputValues()
/*     */   {
/* 299 */     if (this.epInv == null) {
/* 300 */       throw new JAXRPCException("Output params not available");
/*     */     }
/*     */     try
/*     */     {
/* 304 */       OperationMetaData opMetaData = getOperationMetaData();
/*     */ 
/* 306 */       List objPayload = new ArrayList();
/* 307 */       for (QName xmlName : this.epInv.getResponseParamNames())
/*     */       {
/* 309 */         Object paramValue = this.epInv.getResponseParamValue(xmlName);
/* 310 */         if (opMetaData.isDocumentWrapped())
/*     */         {
/* 312 */           objPayload = Arrays.asList((Object[])(Object[])paramValue);
/* 313 */           break;
/*     */         }
/*     */ 
/* 317 */         objPayload.add(paramValue);
/*     */       }
/*     */ 
/* 320 */       return objPayload;
/*     */     }
/*     */     catch (SOAPException ex) {
/*     */     }
/* 324 */     throw new JAXRPCException("Cannot obtain response payload", ex);
/*     */   }
/*     */ 
/*     */   public Map getOutputParams()
/*     */   {
/* 336 */     if (this.epInv == null) {
/* 337 */       throw new JAXRPCException("Output params not available");
/*     */     }
/*     */     try
/*     */     {
/* 341 */       Map outMap = new LinkedHashMap();
/* 342 */       for (QName xmlName : this.epInv.getResponseParamNames())
/*     */       {
/* 344 */         Object value = this.epInv.getResponseParamValue(xmlName);
/* 345 */         outMap.put(xmlName.getLocalPart(), value);
/*     */       }
/* 347 */       return outMap;
/*     */     }
/*     */     catch (SOAPException ex) {
/*     */     }
/* 351 */     throw new JAXRPCException("Cannot obtain response payload", ex);
/*     */   }
/*     */ 
/*     */   public QName getPortTypeName()
/*     */   {
/* 362 */     if (this.portType != null)
/*     */     {
/* 364 */       return this.portType;
/*     */     }
/*     */ 
/* 381 */     return new QName("");
/*     */   }
/*     */ 
/*     */   public QName getReturnType()
/*     */   {
/* 391 */     QName retType = null;
/* 392 */     if (this.operationName != null)
/*     */     {
/* 394 */       OperationMetaData opDesc = getOperationMetaData();
/* 395 */       ParameterMetaData retMetaData = opDesc.getReturnParameter();
/* 396 */       if (retMetaData != null)
/* 397 */         retType = retMetaData.getXmlType();
/*     */     }
/* 399 */     return retType;
/*     */   }
/*     */ 
/*     */   public void setPortTypeName(QName portType)
/*     */   {
/* 409 */     this.portType = portType;
/*     */   }
/*     */ 
/*     */   public boolean isParameterAndReturnSpecRequired(QName opName)
/*     */   {
/* 422 */     setOperationName(opName);
/* 423 */     OperationMetaData opMetaData = getOperationMetaData();
/* 424 */     return (opMetaData.getParameters().size() == 0) && (opMetaData.getReturnParameter() == null);
/*     */   }
/*     */ 
/*     */   public Iterator getPropertyNames()
/*     */   {
/* 432 */     return standardProperties.iterator();
/*     */   }
/*     */ 
/*     */   public Object getProperty(String name)
/*     */   {
/* 439 */     if (null == name) {
/* 440 */       throw new JAXRPCException("Unsupported property: " + name);
/*     */     }
/* 442 */     if ((name.startsWith("javax.xml.rpc")) && (!standardProperties.contains(name))) {
/* 443 */       throw new JAXRPCException("Unsupported property: " + name);
/*     */     }
/* 445 */     return this.properties.get(name);
/*     */   }
/*     */ 
/*     */   public void setProperty(String name, Object value)
/*     */   {
/* 452 */     if (null == name) {
/* 453 */       throw new JAXRPCException("Unsupported property: " + name);
/*     */     }
/*     */ 
/* 456 */     if ((name.startsWith("javax.xml.rpc")) && (!standardProperties.contains(name))) {
/* 457 */       throw new JAXRPCException("Unsupported property: " + name);
/*     */     }
/* 459 */     if (log.isDebugEnabled())
/* 460 */       log.debug("setProperty: [name=" + name + ",value=" + value + "]");
/* 461 */     this.properties.put(name, value);
/*     */   }
/*     */ 
/*     */   public void removeProperty(String name)
/*     */   {
/* 468 */     this.properties.remove(name);
/*     */   }
/*     */ 
/*     */   public QName getParameterTypeByName(String paramName)
/*     */   {
/* 475 */     OperationMetaData opMetaData = getOperationMetaData();
/* 476 */     ParameterMetaData paramMetaData = opMetaData.getParameter(new QName(paramName));
/* 477 */     if (paramMetaData != null)
/* 478 */       return paramMetaData.getXmlType();
/* 479 */     return null;
/*     */   }
/*     */ 
/*     */   protected CommonBindingProvider getCommonBindingProvider()
/*     */   {
/* 484 */     if (this.bindingProvider == null)
/*     */     {
/* 486 */       this.bindingProvider = new CommonBindingProvider(getEndpointMetaData());
/*     */     }
/* 488 */     return this.bindingProvider;
/*     */   }
/*     */ 
/*     */   protected void setInboundContextProperties()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected void setOutboundContextProperties()
/*     */   {
/*     */   }
/*     */ 
/*     */   private Object invokeInternal(QName opName, Object[] inputParams, boolean forceOneway)
/*     */     throws RemoteException
/*     */   {
/* 503 */     if (!opName.equals(this.operationName)) {
/* 504 */       setOperationName(opName);
/*     */     }
/* 506 */     OperationMetaData opMetaData = getOperationMetaData();
/*     */ 
/* 509 */     generateOrUpdateSchemas(opMetaData);
/*     */ 
/* 512 */     SOAPMessageContextJAXRPC msgContext = new SOAPMessageContextJAXRPC();
/* 513 */     MessageContextAssociation.pushMessageContext(msgContext);
/* 514 */     Object retObj = null;
/*     */     try
/*     */     {
/* 517 */       retObj = super.invoke(opName, inputParams, forceOneway);
/* 518 */       Object localObject1 = retObj;
/*     */       return localObject1;
/*     */     }
/*     */     catch (SOAPFaultException ex)
/*     */     {
/* 522 */       log.error("Call invocation failed", ex);
/* 523 */       String faultCode = ex.getFaultCode().getLocalPart();
/* 524 */       throw new RemoteException("Call invocation failed with code [" + faultCode + "] because of: " + ex.getFaultString(), ex);
/*     */     }
/*     */     catch (RemoteException rex)
/*     */     {
/* 528 */       throw rex;
/*     */     }
/*     */     catch (WSTimeoutException toex)
/*     */     {
/* 532 */       throw toex;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 536 */       throw new RemoteException("Call invocation failed", ex);
/*     */     }
/*     */     finally
/*     */     {
/* 541 */       MessageContextAssociation.popMessageContext(); } throw localObject2;
/*     */   }
/*     */ 
/*     */   protected boolean callRequestHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 548 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/* 549 */     HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(portName);
/* 550 */     boolean status = handlerChain != null ? handlerChain.handleRequest(msgContext, type) : true;
/*     */ 
/* 552 */     if (type == UnifiedHandlerMetaData.HandlerType.ENDPOINT) {
/* 553 */       XOPContext.visitAndRestoreXOPData();
/*     */     }
/* 555 */     return status;
/*     */   }
/*     */ 
/*     */   protected boolean callResponseHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/* 561 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/* 562 */     HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(portName);
/*     */ 
/* 564 */     boolean status = true;
/* 565 */     if (handlerChain != null)
/*     */     {
/* 567 */       status = handlerChain.handleResponse(msgContext, type);
/*     */     }
/* 569 */     return status;
/*     */   }
/*     */ 
/*     */   protected boolean callFaultHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type, Exception ex)
/*     */   {
/* 575 */     SOAPMessageContextJAXRPC msgContext = (SOAPMessageContextJAXRPC)MessageContextAssociation.peekMessageContext();
/* 576 */     HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(portName);
/*     */ 
/* 578 */     boolean status = true;
/* 579 */     if (handlerChain != null)
/*     */     {
/* 581 */       status = handlerChain.handleFault(msgContext, type);
/*     */     }
/* 583 */     return status;
/*     */   }
/*     */ 
/*     */   protected void closeHandlerChain(QName portName, UnifiedHandlerMetaData.HandlerType type)
/*     */   {
/*     */   }
/*     */ 
/*     */   private void generateOrUpdateSchemas(OperationMetaData opMetaData)
/*     */   {
/* 597 */     ServiceMetaData serviceMetaData = opMetaData.getEndpointMetaData().getServiceMetaData();
/* 598 */     if (serviceMetaData.getWsdlLocation() == null)
/*     */     {
/* 600 */       TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
/* 601 */       for (ParameterMetaData paramMetaData : opMetaData.getParameters())
/*     */       {
/* 603 */         generateOrUpdateParameterSchema(typesMetaData, paramMetaData);
/*     */       }
/*     */ 
/* 606 */       ParameterMetaData retMetaData = opMetaData.getReturnParameter();
/* 607 */       if (retMetaData != null)
/*     */       {
/* 609 */         generateOrUpdateParameterSchema(typesMetaData, retMetaData);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void generateOrUpdateParameterSchema(TypesMetaData typesMetaData, ParameterMetaData paramMetaData)
/*     */   {
/* 619 */     if (!paramMetaData.isSwA())
/*     */     {
/* 621 */       QName xmlType = paramMetaData.getXmlType();
/* 622 */       Class javaType = paramMetaData.getJavaType();
/*     */ 
/* 624 */       ServiceMetaData serviceMetaData = getEndpointMetaData().getServiceMetaData();
/* 625 */       TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
/* 626 */       SerializerFactory serFactory = typeMapping.getSerializer(javaType, xmlType);
/* 627 */       if ((serFactory instanceof JBossXBSerializerFactory))
/*     */       {
/* 629 */         SchemaGenerator xsdGenerator = new SchemaGenerator();
/* 630 */         JBossXSModel model = xsdGenerator.generateXSDSchema(xmlType, javaType);
/* 631 */         typesMetaData.addSchemaModel(model);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void registerParameterType(QName xmlType, Class javaType)
/*     */   {
/* 638 */     ServiceMetaData serviceMetaData = getEndpointMetaData().getServiceMetaData();
/*     */ 
/* 640 */     String nsURI = xmlType.getNamespaceURI();
/* 641 */     if (!"http://www.jboss.org/jbossws/attachment/mimetype".equals(nsURI))
/*     */     {
/* 643 */       TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
/* 644 */       Class regJavaType = typeMapping.getJavaType(xmlType);
/* 645 */       if (regJavaType == null)
/*     */       {
/* 647 */         typeMapping.register(javaType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
/*     */       }
/* 649 */       else if ((regJavaType != null) && (!JavaUtils.isAssignableFrom(regJavaType, javaType)))
/*     */       {
/* 651 */         throw new IllegalArgumentException("Different java type already registered: " + regJavaType.getName());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName, String configFile)
/*     */   {
/* 659 */     EndpointMetaData epMetaData = getEndpointMetaData();
/* 660 */     epMetaData.setConfigName(configName, configFile);
/*     */ 
/* 663 */     this.jaxrpcService.setupHandlerChain(epMetaData);
/*     */   }
/*     */ 
/*     */   public Set<QName> getHeaders()
/*     */   {
/* 668 */     HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(this.epMetaData.getPortName());
/*     */ 
/* 670 */     return handlerChain != null ? handlerChain.getHeaders() : new HashSet();
/*     */   }
/*     */ 
/*     */   public Set<String> getRoles()
/*     */   {
/* 675 */     HandlerChainBaseImpl handlerChain = (HandlerChainBaseImpl)this.jaxrpcService.getHandlerChain(this.epMetaData.getPortName());
/*     */ 
/* 677 */     Set set = new HashSet();
/* 678 */     String[] roles = handlerChain.getRoles();
/* 679 */     if (roles != null) {
/* 680 */       Collections.addAll(set, roles);
/*     */     }
/* 682 */     return set;
/*     */   }
/*     */ 
/*     */   protected boolean shouldMaintainSession()
/*     */   {
/* 688 */     Object bool = getRequestContext().get("javax.xml.rpc.session.maintain");
/* 689 */     return Boolean.TRUE.equals(bool);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  98 */     standardProperties.add("javax.xml.rpc.encodingstyle.namespace.uri");
/*  99 */     standardProperties.add("javax.xml.rpc.soap.operation.style");
/* 100 */     standardProperties.add("javax.xml.rpc.session.maintain");
/* 101 */     standardProperties.add("javax.xml.rpc.soap.http.soapaction.uri");
/* 102 */     standardProperties.add("javax.xml.rpc.soap.http.soapaction.use");
/* 103 */     standardProperties.add("javax.xml.rpc.security.auth.username");
/* 104 */     standardProperties.add("javax.xml.rpc.security.auth.password");
/*     */ 
/* 106 */     standardProperties.add("javax.xml.rpc.service.endpoint.address");
/* 107 */     standardProperties.add("javax.xml.rpc.session.maintain");
/* 108 */     standardProperties.add("javax.xml.rpc.security.auth.username");
/* 109 */     standardProperties.add("javax.xml.rpc.security.auth.password");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.client.CallImpl
 * JD-Core Version:    0.6.0
 */