/*     */ package org.jboss.ws.core.jaxrpc.binding.jbossxb;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFactory;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.xml.JBossEntityResolver;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.utils.JBossWSEntityResolver;
/*     */ import org.jboss.ws.extensions.xop.jaxrpc.JBossXBContentAdapter;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
/*     */ import org.jboss.xb.binding.metadata.ClassMetaData;
/*     */ import org.jboss.xb.binding.metadata.PackageMetaData;
/*     */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SimpleTypeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtElementHandler;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Text;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class SchemaBindingBuilder
/*     */ {
/*  81 */   private static final Logger log = Logger.getLogger(SchemaBindingBuilder.class);
/*     */ 
/*     */   public SchemaBinding buildSchemaBinding(XSModel model, JavaWsdlMapping wsdlMapping)
/*     */   {
/*  88 */     JBossEntityResolver resolver = new JBossWSEntityResolver();
/*  89 */     SchemaBinding schemaBinding = XsdBinder.bind(model, new DefaultSchemaResolver(resolver));
/*     */ 
/*  91 */     schemaBinding.setIgnoreLowLine(false);
/*  92 */     schemaBinding.setIgnoreUnresolvedFieldOrClass(false);
/*  93 */     schemaBinding.setUnmarshalListsToArrays(true);
/*  94 */     schemaBinding.setSimpleContentProperty("_value");
/*  95 */     schemaBinding.setUseNoArgCtorIfFound(true);
/*  96 */     schemaBinding.setReplacePropertyRefs(false);
/*  97 */     if (wsdlMapping != null)
/*     */     {
/*  99 */       bindSchemaToJava(schemaBinding, wsdlMapping);
/*     */     }
/*     */ 
/* 103 */     JBossXBContentAdapter.register(schemaBinding);
/*     */ 
/* 105 */     return schemaBinding;
/*     */   }
/*     */ 
/*     */   private void bindSchemaToJava(SchemaBinding schemaBinding, JavaWsdlMapping wsdlMapping)
/*     */   {
/* 112 */     if (log.isTraceEnabled()) {
/* 113 */       log.trace("bindSchemaToJava: " + schemaBinding);
/*     */     }
/* 115 */     for (PackageMapping packageMapping : wsdlMapping.getPackageMappings())
/*     */     {
/* 117 */       processPackageMapping(schemaBinding, packageMapping);
/*     */     }
/*     */ 
/* 120 */     for (ExceptionMapping exceptionMapping : wsdlMapping.getExceptionMappings())
/*     */     {
/* 122 */       processExceptionMapping(schemaBinding, exceptionMapping);
/*     */     }
/*     */ 
/* 125 */     for (JavaXmlTypeMapping typeMapping : wsdlMapping.getJavaXmlTypeMappings())
/*     */     {
/* 127 */       processJavaXmlTypeMapping(schemaBinding, typeMapping);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processPackageMapping(SchemaBinding schemaBinding, PackageMapping packageMapping)
/*     */   {
/* 133 */     PackageMetaData packageMetaData = schemaBinding.getPackageMetaData();
/* 134 */     if (packageMetaData == null)
/*     */     {
/* 136 */       packageMetaData = new PackageMetaData();
/* 137 */       schemaBinding.setPackageMetaData(packageMetaData);
/*     */     }
/*     */ 
/* 140 */     if (log.isTraceEnabled()) {
/* 141 */       log.trace("Bound namespace " + packageMapping.getNamespaceURI() + " to package " + packageMapping.getPackageType());
/*     */     }
/* 143 */     packageMetaData.setName(packageMapping.getPackageType());
/*     */   }
/*     */ 
/*     */   private void processJavaXmlTypeMapping(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping)
/*     */   {
/* 148 */     String javaType = typeMapping.getJavaType();
/* 149 */     if (javaType.endsWith("[]"))
/*     */     {
/* 151 */       processArrayType(schemaBinding, typeMapping);
/*     */     }
/*     */     else
/*     */     {
/* 155 */       processNonArrayType(schemaBinding, typeMapping);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processExceptionMapping(SchemaBinding schemaBinding, ExceptionMapping exceptionMapping)
/*     */   {
/* 161 */     QName xmlType = exceptionMapping.getWsdlMessage();
/* 162 */     String javaType = exceptionMapping.getExceptionType();
/* 163 */     log.trace("processExceptionMapping: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
/*     */ 
/* 165 */     if (schemaBinding.getType(xmlType) == null)
/*     */     {
/* 167 */       TypeBinding typeBinding = new TypeBinding(xmlType);
/* 168 */       ClassMetaData cmd = new ClassMetaData();
/* 169 */       cmd.setUseNoArgCtor(Boolean.FALSE);
/* 170 */       cmd.setImpl(javaType);
/* 171 */       typeBinding.setClassMetaData(cmd);
/* 172 */       typeBinding.setSimple(false);
/* 173 */       schemaBinding.addType(typeBinding);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processArrayType(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping)
/*     */   {
/* 179 */     QName xmlType = getXmlType(typeMapping);
/* 180 */     log.trace("Ignore array type: " + xmlType);
/*     */   }
/*     */ 
/*     */   private void processNonArrayType(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping)
/*     */   {
/* 185 */     QName xmlType = getXmlType(typeMapping);
/* 186 */     String javaType = typeMapping.getJavaType();
/* 187 */     log.trace("processNonArrayType: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
/*     */ 
/* 189 */     TypeBinding typeBinding = getTypeBinding(schemaBinding, typeMapping);
/* 190 */     if (typeBinding != null)
/*     */     {
/* 193 */       boolean isSimpleTypeBinding = typeBinding instanceof SimpleTypeBinding;
/* 194 */       if (!isSimpleTypeBinding)
/*     */       {
/* 196 */         ClassMetaData classMetaData = typeBinding.getClassMetaData();
/* 197 */         if (classMetaData == null)
/*     */         {
/* 199 */           classMetaData = new ClassMetaData();
/* 200 */           typeBinding.setClassMetaData(classMetaData);
/*     */         }
/* 202 */         classMetaData.setImpl(javaType);
/*     */ 
/* 205 */         JavaWsdlMapping wsdlMapping = typeMapping.getJavaWsdlMapping();
/* 206 */         for (ExceptionMapping aux : wsdlMapping.getExceptionMappings())
/*     */         {
/* 208 */           if (!javaType.equals(aux.getExceptionType()))
/*     */             continue;
/* 210 */           classMetaData.setUseNoArgCtor(Boolean.valueOf(false));
/* 211 */           break;
/*     */         }
/*     */ 
/* 215 */         if (log.isTraceEnabled())
/*     */         {
/* 217 */           QName typeQName = typeBinding.getQName();
/* 218 */           log.trace("Bound: [xmlType=" + typeQName + ",javaType=" + javaType + "]");
/*     */         }
/*     */       }
/*     */ 
/* 222 */       VariableMapping[] variableMappings = typeMapping.getVariableMappings();
/* 223 */       for (VariableMapping varMapping : variableMappings)
/*     */       {
/* 225 */         if (varMapping.getXmlElementName() != null)
/*     */         {
/* 227 */           processXmlElementName(typeBinding, varMapping);
/*     */         }
/* 229 */         else if (varMapping.getXmlAttributeName() != null)
/*     */         {
/* 231 */           processXmlAttributeName(typeBinding, varMapping);
/*     */         } else {
/* 233 */           if (!varMapping.getXmlWildcard())
/*     */             continue;
/* 235 */           processWildcard(typeBinding, varMapping);
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 241 */       log.warn("Cannot obtain type binding for: " + xmlType);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processXmlAttributeName(TypeBinding typeBinding, VariableMapping varMapping)
/*     */   {
/* 247 */     String xmlAttrName = varMapping.getXmlAttributeName();
/* 248 */     log.trace("processXmlAttributeName: " + xmlAttrName);
/*     */ 
/* 250 */     QName xmlName = new QName(xmlAttrName);
/* 251 */     AttributeBinding attrBinding = typeBinding.getAttribute(xmlName);
/* 252 */     if (attrBinding == null)
/*     */     {
/* 254 */       Iterator i = typeBinding.getAttributes().iterator();
/* 255 */       while (i.hasNext())
/*     */       {
/* 257 */         AttributeBinding auxBinding = (AttributeBinding)i.next();
/* 258 */         if (auxBinding.getQName().getLocalPart().equals(xmlAttrName))
/*     */         {
/* 260 */           if (attrBinding != null) {
/* 261 */             log.warn("Ambiguous binding for attribute: " + xmlAttrName);
/*     */           }
/* 263 */           attrBinding = auxBinding;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 268 */     if (attrBinding == null)
/*     */     {
/* 271 */       String nsURI = typeBinding.getQName().getNamespaceURI();
/* 272 */       if (("mustUnderstand".equals(xmlAttrName)) || ("actor".equals(xmlAttrName)) || ("role".equals(xmlAttrName)))
/*     */       {
/* 275 */         nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
/*     */       }
/* 277 */       QName auxName = new QName(nsURI, xmlAttrName);
/* 278 */       attrBinding = typeBinding.getAttribute(auxName);
/*     */     }
/*     */ 
/* 281 */     if (attrBinding == null)
/*     */     {
/* 283 */       QName typeQName = typeBinding.getQName();
/* 284 */       throw new WSException("Attribute " + xmlName + " found in jaxrpc-mapping but not in the schema: " + typeQName);
/*     */     }
/*     */ 
/* 287 */     String javaVariableName = varMapping.getJavaVariableName();
/* 288 */     PropertyMetaData prop = new PropertyMetaData();
/* 289 */     prop.setName(javaVariableName);
/* 290 */     attrBinding.setPropertyMetaData(prop);
/*     */ 
/* 292 */     if (log.isTraceEnabled())
/* 293 */       log.trace("Bound attribute " + xmlName + " to property " + prop.getName());
/*     */   }
/*     */ 
/*     */   private void processXmlElementName(TypeBinding typeBinding, VariableMapping varMapping)
/*     */   {
/* 298 */     QName xmlName = new QName(varMapping.getXmlElementName());
/* 299 */     log.trace("processXmlElementName: " + xmlName);
/*     */ 
/* 301 */     ElementBinding element = typeBinding.getElement(xmlName);
/* 302 */     QName typeQName = typeBinding.getQName();
/* 303 */     if ((element == null) && (typeQName != null))
/*     */     {
/* 306 */       String nsURI = typeQName.getNamespaceURI();
/* 307 */       QName auxName = new QName(nsURI, varMapping.getXmlElementName());
/* 308 */       element = typeBinding.getElement(auxName);
/*     */     }
/*     */ 
/* 311 */     if (element == null)
/*     */     {
/* 314 */       ParticleBinding particle = typeBinding.getParticle();
/* 315 */       if (particle != null)
/*     */       {
/* 317 */         TermBinding term = particle.getTerm();
/* 318 */         if ((term instanceof ModelGroupBinding))
/*     */         {
/* 320 */           Iterator iterator = ((ModelGroupBinding)term).getParticles().iterator();
/* 321 */           element = findLocalPathElement(iterator, new String[] { varMapping.getXmlElementName() }, 0);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 326 */     if (element == null) {
/* 327 */       throw new WSException("Element " + xmlName + " found in jaxrpc-mapping but not in the schema: " + typeQName);
/*     */     }
/* 329 */     String javaVariableName = varMapping.getJavaVariableName();
/* 330 */     if (javaVariableName != null)
/*     */     {
/* 332 */       PropertyMetaData prop = new PropertyMetaData();
/* 333 */       prop.setName(javaVariableName);
/* 334 */       element.setPropertyMetaData(prop);
/*     */ 
/* 336 */       if (log.isTraceEnabled())
/* 337 */         log.trace("Bound element " + xmlName + " to property " + prop.getName());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processWildcard(TypeBinding typeBinding, VariableMapping varMapping)
/*     */   {
/* 343 */     log.trace("processWildcard: " + typeBinding.getQName());
/*     */ 
/* 345 */     PropertyMetaData prop = null;
/* 346 */     String javaVariableName = varMapping.getJavaVariableName();
/* 347 */     if (javaVariableName != null)
/*     */     {
/* 349 */       prop = new PropertyMetaData();
/* 350 */       prop.setName(javaVariableName);
/*     */     }
/*     */ 
/* 353 */     if (prop == null)
/*     */     {
/* 355 */       prop = new PropertyMetaData();
/* 356 */       prop.setName("_any");
/*     */     }
/*     */ 
/* 359 */     WildcardBinding wildcard = typeBinding.getWildcard();
/* 360 */     wildcard.setUnresolvedElementHandler(new SoapElementHandler());
/* 361 */     wildcard.setUnresolvedCharactersHandler(new SoapCharactersHandler());
/* 362 */     wildcard.setPropertyMetaData(prop);
/*     */ 
/* 364 */     if (log.isTraceEnabled())
/* 365 */       log.trace("Bound wildcard of " + typeBinding.getQName() + " to property " + prop.getName());
/*     */   }
/*     */ 
/*     */   private TypeBinding getTypeBinding(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping)
/*     */   {
/* 370 */     String qnameScope = typeMapping.getQnameScope();
/* 371 */     QName anonymousTypeQName = typeMapping.getAnonymousTypeQName();
/* 372 */     if (anonymousTypeQName != null)
/*     */     {
/* 374 */       return getAnonymousTypeBinding(schemaBinding, anonymousTypeQName);
/*     */     }
/*     */ 
/* 377 */     QName xmlType = typeMapping.getRootTypeQName();
/*     */ 
/* 379 */     TypeBinding typeBinding = null;
/* 380 */     if (("complexType".equals(qnameScope)) || ("simpleType".equals(qnameScope)))
/*     */     {
/* 382 */       typeBinding = schemaBinding.getType(xmlType);
/* 383 */       if (typeBinding == null)
/*     */       {
/* 385 */         log.warn("Type definition not found in schema: " + xmlType);
/*     */       }
/*     */     }
/* 388 */     else if ("element".equals(qnameScope))
/*     */     {
/* 390 */       ElementBinding element = schemaBinding.getElement(xmlType);
/* 391 */       if (element != null)
/*     */       {
/* 393 */         typeBinding = element.getType();
/*     */       }
/*     */       else
/*     */       {
/* 397 */         log.warn("Global element not found in schema: " + xmlType);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 402 */       throw new WSException("Unexpected qname-scope for " + typeMapping.getJavaType() + ": " + qnameScope);
/*     */     }
/* 404 */     return typeBinding;
/*     */   }
/*     */ 
/*     */   public TypeBinding getAnonymousTypeBinding(SchemaBinding schemaBinding, QName typeQName)
/*     */   {
/* 409 */     String expression = typeQName.getLocalPart();
/* 410 */     if (log.isTraceEnabled()) {
/* 411 */       log.trace("Searching for anonymous expression: " + expression);
/*     */     }
/* 413 */     ArrayList list = new ArrayList(10);
/*     */ 
/* 415 */     int i = 0; for (int begin = -1; i < expression.length(); i++)
/*     */     {
/* 417 */       if (expression.charAt(i) == '>')
/*     */       {
/* 419 */         if (begin == -1)
/*     */           continue;
/* 421 */         list.add(expression.substring(begin, i));
/* 422 */         begin = -1;
/*     */       }
/* 427 */       else if (begin == -1) {
/* 428 */         begin = i;
/* 429 */       } else if (i == expression.length() - 1) {
/* 430 */         list.add(expression.substring(begin));
/*     */       }
/*     */     }
/*     */ 
/* 434 */     ElementBinding element = findLocalPathElement(schemaBinding.getElements(), (String[])(String[])list.toArray(new String[0]));
/* 435 */     if (element == null) {
/* 436 */       element = findLocalPathElementInTypes(schemaBinding.getTypes(), (String[])(String[])list.toArray(new String[0]));
/*     */     }
/* 438 */     if (element == null) {
/* 439 */       return null;
/*     */     }
/* 441 */     return element.getType();
/*     */   }
/*     */ 
/*     */   public void bindParameterToElement(SchemaBinding schemaBinding, QName xmlName, QName xmlType)
/*     */   {
/* 447 */     boolean isAnonymousType = xmlType.getLocalPart().startsWith(">");
/*     */     TypeBinding typeBinding;
/*     */     TypeBinding typeBinding;
/* 448 */     if (isAnonymousType)
/*     */     {
/* 450 */       typeBinding = getAnonymousTypeBinding(schemaBinding, xmlType);
/*     */     }
/*     */     else
/*     */     {
/* 454 */       typeBinding = schemaBinding.getType(xmlType);
/*     */     }
/*     */ 
/* 457 */     if (typeBinding != null)
/*     */     {
/* 459 */       if (!isAnonymousType)
/* 460 */         schemaBinding.addElement(xmlName, typeBinding);
/*     */     }
/* 462 */     else if (!xmlType.equals(Constants.TYPE_LITERAL_ANYTYPE))
/*     */     {
/* 464 */       throw new WSException("Root type " + xmlType + " not found in the schema.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private ElementBinding findLocalPathElement(Iterator elements, String[] path)
/*     */   {
/* 470 */     while (elements.hasNext())
/*     */     {
/* 472 */       ElementBinding element = (ElementBinding)elements.next();
/* 473 */       element = findLocalPathElement(element, path, 0);
/* 474 */       if (element != null) {
/* 475 */         return element;
/*     */       }
/*     */     }
/* 478 */     return null;
/*     */   }
/*     */ 
/*     */   private ElementBinding findLocalPathElementInTypes(Iterator types, String[] path)
/*     */   {
/* 483 */     while (types.hasNext())
/*     */     {
/* 485 */       TypeBinding type = (TypeBinding)types.next();
/* 486 */       if (type.getQName().getLocalPart().equals(path[0]))
/*     */       {
/* 488 */         ParticleBinding particle = type.getParticle();
/* 489 */         if (particle == null) {
/*     */           continue;
/*     */         }
/* 492 */         TermBinding term = particle.getTerm();
/* 493 */         if (term.isModelGroup())
/*     */         {
/* 496 */           return findLocalPathElement(((ModelGroupBinding)term).getParticles().iterator(), path, 1);
/*     */         }
/*     */       }
/*     */     }
/* 500 */     return null;
/*     */   }
/*     */ 
/*     */   private ElementBinding findLocalPathElement(ElementBinding element, String[] path, int pos)
/*     */   {
/* 505 */     String name = path[pos];
/* 506 */     if (!name.equals(element.getQName().getLocalPart())) {
/* 507 */       return null;
/*     */     }
/*     */ 
/* 510 */     if (path.length - 1 == pos) {
/* 511 */       return element;
/*     */     }
/* 513 */     ParticleBinding particle = element.getType().getParticle();
/* 514 */     if (particle == null) {
/* 515 */       return null;
/*     */     }
/* 517 */     TermBinding term = particle.getTerm();
/* 518 */     if (!term.isModelGroup()) {
/* 519 */       return null;
/*     */     }
/* 521 */     ModelGroupBinding group = (ModelGroupBinding)term;
/* 522 */     Iterator i = group.getParticles().iterator();
/*     */ 
/* 525 */     return findLocalPathElement(i, path, pos + 1);
/*     */   }
/*     */ 
/*     */   private ElementBinding findLocalPathElement(Iterator particles, String[] path, int pos)
/*     */   {
/* 530 */     while (particles.hasNext())
/*     */     {
/* 532 */       TermBinding term = ((ParticleBinding)particles.next()).getTerm();
/* 533 */       if ((term instanceof ElementBinding))
/*     */       {
/* 535 */         ElementBinding element = (ElementBinding)term;
/* 536 */         element = findLocalPathElement(element, path, pos);
/* 537 */         if (element != null) {
/* 538 */           return element;
/*     */         }
/*     */       }
/* 541 */       else if ((term instanceof ModelGroupBinding))
/*     */       {
/* 543 */         Iterator i = ((ModelGroupBinding)term).getParticles().iterator();
/* 544 */         ElementBinding element = findLocalPathElement(i, path, pos);
/* 545 */         if (element != null) {
/* 546 */           return element;
/*     */         }
/*     */       }
/*     */     }
/* 550 */     return null;
/*     */   }
/*     */ 
/*     */   private QName getXmlType(JavaXmlTypeMapping typeMapping)
/*     */   {
/* 557 */     QName xmlType = typeMapping.getRootTypeQName();
/* 558 */     if ((xmlType == null) && (typeMapping.getAnonymousTypeQName() != null)) {
/* 559 */       xmlType = typeMapping.getAnonymousTypeQName();
/*     */     }
/* 561 */     return xmlType;
/*     */   }
/*     */ 
/*     */   public static class SoapElementHandler extends RtElementHandler
/*     */     implements ParticleHandler
/*     */   {
/*     */     private SOAPFactory factory;
/*     */ 
/*     */     public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */     {
/* 592 */       SOAPFactory factory = getFactory();
/* 593 */       SOAPElement element = null;
/*     */       try
/*     */       {
/* 596 */         String prefix = elementName.getPrefix();
/* 597 */         String ns = elementName.getNamespaceURI();
/* 598 */         if ((ns != null) && (ns.length() > 0))
/*     */         {
/* 600 */           prefix = nsCtx.getPrefix(ns);
/*     */         }
/*     */ 
/* 603 */         element = factory.createElement(elementName.getLocalPart(), prefix, ns);
/*     */       }
/*     */       catch (SOAPException e)
/*     */       {
/* 607 */         throw new IllegalStateException("Failed to create SOAPElement", e);
/*     */       }
/*     */ 
/* 610 */       if (attrs != null)
/*     */       {
/* 612 */         for (int i = 0; i < attrs.getLength(); i++)
/*     */         {
/* 614 */           element.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
/*     */         }
/*     */       }
/*     */ 
/* 618 */       return element;
/*     */     }
/*     */ 
/*     */     public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*     */     {
/* 623 */       return o;
/*     */     }
/*     */ 
/*     */     public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */     {
/* 628 */       if ((parent instanceof SOAPElement))
/*     */       {
/* 630 */         ((SOAPElement)parent).appendChild((Element)o);
/*     */       }
/*     */       else
/*     */       {
/* 634 */         super.setParent(parent, o, elementName, particle, parentParticle);
/*     */       }
/*     */     }
/*     */ 
/*     */     private SOAPFactory getFactory()
/*     */     {
/* 640 */       if (this.factory == null)
/*     */       {
/*     */         try
/*     */         {
/* 644 */           this.factory = SOAPFactory.newInstance();
/*     */         }
/*     */         catch (SOAPException e)
/*     */         {
/* 648 */           throw new IllegalStateException("Failed to create soap element factory", e);
/*     */         }
/*     */       }
/* 651 */       return this.factory;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class SoapCharactersHandler extends CharactersHandler
/*     */   {
/*     */     public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData)
/*     */     {
/* 570 */       return "";
/*     */     }
/*     */ 
/*     */     public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*     */     {
/* 575 */       return value;
/*     */     }
/*     */ 
/*     */     public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*     */     {
/* 580 */       SOAPElement e = (SOAPElement)owner;
/* 581 */       Text textNode = e.getOwnerDocument().createTextNode((String)value);
/* 582 */       e.appendChild(textNode);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.jbossxb.SchemaBindingBuilder
 * JD-Core Version:    0.6.0
 */