/*     */ package org.jboss.ws.core.jaxrpc.binding.jbossxb;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
/*     */ 
/*     */ public class JBossXBUnmarshallerImpl
/*     */   implements JBossXBUnmarshaller
/*     */ {
/*  45 */   private HashMap<String, Object> properties = new HashMap();
/*     */ 
/*     */   public Object unmarshal(InputStream is)
/*     */     throws UnmarshalException
/*     */   {
/*  52 */     assertRequiredProperties();
/*     */ 
/*  54 */     Unmarshaller unm = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  55 */     SchemaBinding schemaBinding = JBossXBSupport.getOrCreateSchemaBinding(this.properties);
/*  56 */     XOPUnmarshallerImpl xopUnmarshaller = new XOPUnmarshallerImpl();
/*  57 */     schemaBinding.setXopUnmarshaller(xopUnmarshaller);
/*     */     try
/*     */     {
/*  61 */       return unm.unmarshal(is, schemaBinding);
/*     */     }
/*     */     catch (JBossXBException e) {
/*     */     }
/*  65 */     throw new UnmarshalException(e.getMessage(), e);
/*     */   }
/*     */ 
/*     */   public Object getProperty(String name)
/*     */   {
/*  74 */     if (name == null) {
/*  75 */       throw new IllegalArgumentException("name parameter is null");
/*     */     }
/*  77 */     return this.properties.get(name);
/*     */   }
/*     */ 
/*     */   public void setProperty(String name, Object value)
/*     */   {
/*  85 */     if (name == null) {
/*  86 */       throw new IllegalArgumentException("name parameter is null");
/*     */     }
/*  88 */     this.properties.put(name, value);
/*     */   }
/*     */ 
/*     */   private void assertRequiredProperties()
/*     */   {
/*  96 */     if (getProperty("org.jboss.xb.xsd.xsmodel") == null)
/*     */     {
/*  98 */       throw new WSException("Cannot find required property: org.jboss.xb.xsd.xsmodel");
/*     */     }
/*     */ 
/* 101 */     if (getProperty("org.jboss.xb.java.mapping") == null)
/*     */     {
/* 103 */       throw new WSException("Cannot find required property: org.jboss.xb.java.mapping");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshallerImpl
 * JD-Core Version:    0.6.0
 */