/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.soap.SOAPElement;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.wsf.common.DOMWriter;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class SOAPElementSerializer extends SerializerSupport
/*    */ {
/* 47 */   private static final Logger log = Logger.getLogger(SOAPElementSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes)
/*    */     throws BindingException
/*    */   {
/* 57 */     log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/* 58 */     if (value == null)
/* 59 */       throw new IllegalArgumentException("SOAPElement value cannot be null");
/* 60 */     if (!(value instanceof SOAPElement)) {
/* 61 */       throw new IllegalArgumentException("Value is not a SOAPElement: " + value.getClass().getName());
/*    */     }
/* 63 */     String xmlFragment = DOMWriter.printNode((SOAPElement)value, false);
/* 64 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.SOAPElementSerializer
 * JD-Core Version:    0.6.0
 */