/*     */ package org.jboss.ws.core.jaxrpc.binding;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Result;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.AbstractSerializerFactory;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.SerializerSupport;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.soap.NameImpl;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ 
/*     */ public class SOAPArraySerializer extends SerializerSupport
/*     */ {
/*  54 */   private static final Logger log = Logger.getLogger(SOAPArraySerializer.class);
/*     */   private ParameterMetaData paramMetaData;
/*     */   private SerializerSupport compSerializer;
/*     */   private NullValueSerializer nullSerializer;
/*     */   private boolean isArrayComponentType;
/*     */   private StringBuilder buffer;
/*     */ 
/*     */   public SOAPArraySerializer()
/*     */     throws BindingException
/*     */   {
/*  64 */     this.nullSerializer = new NullValueSerializer();
/*     */   }
/*     */ 
/*     */   public Result serialize(SOAPContentElement soapElement, SerializationContext serContext) throws BindingException
/*     */   {
/*  69 */     this.paramMetaData = soapElement.getParamMetaData();
/*  70 */     QName xmlName = soapElement.getElementQName();
/*  71 */     QName xmlType = soapElement.getXmlType();
/*  72 */     Object value = soapElement.getObjectValue();
/*  73 */     NamedNodeMap attributes = soapElement.getAttributes();
/*  74 */     return serialize(xmlName, xmlType, value, serContext, attributes);
/*     */   }
/*     */ 
/*     */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*     */   {
/*  79 */     log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + ",valueType=" + value.getClass().getName() + "]");
/*     */     try
/*     */     {
/*  82 */       if (this.paramMetaData == null) {
/*  83 */         throw new IllegalStateException("Use serialize(SOAPContenentElement, SerializationContext)");
/*     */       }
/*  85 */       QName compXmlName = this.paramMetaData.getXmlName();
/*  86 */       QName compXmlType = this.paramMetaData.getSOAPArrayCompType();
/*  87 */       Class javaType = this.paramMetaData.getJavaType();
/*     */ 
/*  89 */       Class compJavaType = javaType.getComponentType();
/*  90 */       this.isArrayComponentType = ((isArrayJavaType(compJavaType)) && (isArrayXmlType(compXmlType)));
/*  91 */       while ((compJavaType.getComponentType() != null) && (!this.isArrayComponentType))
/*     */       {
/*  93 */         compJavaType = compJavaType.getComponentType();
/*  94 */         this.isArrayComponentType = ((isArrayJavaType(compJavaType)) && (isArrayXmlType(compXmlType)));
/*     */       }
/*     */ 
/*  97 */       TypeMappingImpl typeMapping = serContext.getTypeMapping();
/*  98 */       if (compXmlType == null)
/*     */       {
/* 100 */         compXmlType = typeMapping.getXMLType(compJavaType);
/* 101 */         this.paramMetaData.setSOAPArrayCompType(compXmlType);
/*     */       }
/*     */ 
/* 104 */       if (compXmlType == null) {
/* 105 */         throw new WSException("Cannot obtain component xmlType for: " + compJavaType);
/*     */       }
/*     */ 
/* 108 */       log.debug("Get component serializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]");
/* 109 */       AbstractSerializerFactory compSerializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(compJavaType, compXmlType);
/* 110 */       if (compSerializerFactory == null)
/*     */       {
/* 112 */         log.warn("Cannot obtain component serializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]");
/* 113 */         compSerializerFactory = (AbstractSerializerFactory)typeMapping.getSerializer(null, compXmlType);
/*     */       }
/* 115 */       if (compSerializerFactory == null) {
/* 116 */         throw new WSException("Cannot obtain component serializer for: " + compXmlType);
/*     */       }
/*     */ 
/* 119 */       this.compSerializer = compSerializerFactory.getSerializer();
/*     */ 
/* 122 */       if (JavaUtils.isPrimitive(value.getClass())) {
/* 123 */         value = JavaUtils.getWrapperValueArray(value);
/*     */       }
/* 125 */       String nodeName = new NameImpl(compXmlName).getQualifiedName();
/*     */ 
/* 127 */       this.buffer = new StringBuilder("<" + nodeName + " xmlns:" + "soap11-enc" + "='" + "http://schemas.xmlsoap.org/soap/encoding/" + "' ");
/*     */ 
/* 129 */       if (!(value instanceof Object[])) {
/* 130 */         throw new WSException("Unsupported array type: " + javaType);
/*     */       }
/* 132 */       Object[] objArr = (Object[])(Object[])value;
/* 133 */       String arrayDim = "" + objArr.length;
/*     */ 
/* 136 */       Object[] subArr = (Object[])(Object[])value;
/* 137 */       while ((!this.isArrayComponentType) && (subArr.length > 0) && ((subArr[0] instanceof Object[])))
/*     */       {
/* 139 */         subArr = (Object[])(Object[])subArr[0];
/* 140 */         arrayDim = arrayDim + "," + subArr.length;
/*     */       }
/*     */ 
/* 143 */       compXmlType = serContext.getNamespaceRegistry().registerQName(compXmlType);
/* 144 */       compXmlName = serContext.getNamespaceRegistry().registerQName(compXmlName);
/* 145 */       String arrayType = "soap11-enc:arrayType='" + compXmlType.getPrefix() + ":" + compXmlType.getLocalPart() + "[" + arrayDim + "]'";
/*     */ 
/* 147 */       this.buffer.append(arrayType);
/* 148 */       this.buffer.append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
/* 149 */       if (!compXmlType.getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/encoding/"))
/* 150 */         this.buffer.append(" xmlns:" + compXmlType.getPrefix() + "='" + compXmlType.getNamespaceURI() + "'");
/* 151 */       if ((compXmlName.getNamespaceURI().length() > 0) && (!compXmlName.getNamespaceURI().equals(compXmlType.getNamespaceURI()))) {
/* 152 */         this.buffer.append(" xmlns:" + compXmlName.getPrefix() + "='" + compXmlName.getNamespaceURI() + "'");
/*     */       }
/* 154 */       this.buffer.append(">");
/* 155 */       serializeArrayComponents(compXmlName, compXmlType, serContext, objArr);
/* 156 */       this.buffer.append("</" + nodeName + ">");
/* 157 */       String xmlFragment = this.buffer.toString();
/*     */ 
/* 159 */       log.debug("serialized: " + xmlFragment);
/* 160 */       return new BufferedStreamResult(xmlFragment);
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 164 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 168 */     throw new BindingException(e);
/*     */   }
/*     */ 
/*     */   private void serializeArrayComponents(QName xmlName, QName xmlType, SerializationContext serContext, Object[] objArr)
/*     */     throws BindingException
/*     */   {
/* 174 */     for (Object compValue : objArr)
/*     */     {
/* 176 */       if ((!this.isArrayComponentType) && ((compValue instanceof Object[])))
/*     */       {
/* 178 */         serializeArrayComponents(xmlName, xmlType, serContext, (Object[])(Object[])compValue);
/*     */       }
/*     */       else
/*     */       {
/* 182 */         SerializerSupport ser = this.compSerializer;
/*     */ 
/* 185 */         if (compValue == null)
/*     */         {
/* 187 */           ser = this.nullSerializer;
/*     */         }
/*     */ 
/* 190 */         Result result = ser.serialize(new QName("item"), xmlType, compValue, serContext, null);
/* 191 */         this.buffer.append(new XMLFragment(result).toXMLString());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean isArrayXmlType(QName xmlType)
/*     */   {
/* 203 */     boolean isArrayType = Constants.TYPE_SOAP11_BASE64.equals(xmlType);
/* 204 */     isArrayType = (isArrayType) || (Constants.TYPE_SOAP11_BASE64.equals(xmlType));
/* 205 */     isArrayType = (isArrayType) || (Constants.TYPE_SOAP11_BASE64BINARY.equals(xmlType));
/* 206 */     isArrayType = (isArrayType) || (Constants.TYPE_SOAP11_HEXBINARY.equals(xmlType));
/* 207 */     isArrayType = (isArrayType) || (Constants.TYPE_SOAP11_NMTOKENS.equals(xmlType));
/* 208 */     isArrayType = (isArrayType) || (Constants.TYPE_LITERAL_BASE64BINARY.equals(xmlType));
/* 209 */     isArrayType = (isArrayType) || (Constants.TYPE_LITERAL_HEXBINARY.equals(xmlType));
/* 210 */     isArrayType = (isArrayType) || (Constants.TYPE_LITERAL_NMTOKENS.equals(xmlType));
/* 211 */     return isArrayType;
/*     */   }
/*     */ 
/*     */   private boolean isArrayJavaType(Class javaType)
/*     */   {
/* 221 */     boolean isBinaryType = ([Ljava.lang.String.class.equals(javaType)) || ([Ljava.lang.Byte.class.equals(javaType)) || ([B.class.equals(javaType));
/* 222 */     return isBinaryType;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.SOAPArraySerializer
 * JD-Core Version:    0.6.0
 */