/*     */ package org.jboss.ws.core.jaxrpc.binding;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.Arrays;
/*     */ import java.util.Iterator;
/*     */ import java.util.StringTokenizer;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.AbstractDeserializerFactory;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.DeserializerSupport;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SOAPArrayDeserializer extends DeserializerSupport
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(SOAPArrayDeserializer.class);
/*     */   private DeserializerSupport componentDeserializer;
/*     */ 
/*     */   public Object deserialize(QName xmlName, QName xmlType, Source source, SerializationContext serContext)
/*     */     throws BindingException
/*     */   {
/*  63 */     log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*     */     try
/*     */     {
/*  67 */       ParameterMetaData paramMetaData = (ParameterMetaData)serContext.getProperty(ParameterMetaData.class.getName());
/*     */ 
/*  69 */       Element soapElement = DOMUtils.sourceToElement(source);
/*  70 */       QName compXmlType = getComponentTypeFromAttribute(soapElement);
/*  71 */       paramMetaData.setSOAPArrayCompType(compXmlType);
/*     */ 
/*  73 */       if (compXmlType == null) {
/*  74 */         throw new WSException("Cannot obtain component xmlType: " + paramMetaData.getPartName());
/*     */       }
/*  76 */       Class compJavaType = getJavaTypeForComponentType(compXmlType, serContext);
/*     */ 
/*  79 */       log.debug("Get component deserializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]");
/*     */ 
/*  81 */       int[] arrDims = getDimensionsFromAttribute(soapElement);
/*  82 */       Object[] retArray = (Object[])(Object[])Array.newInstance(compJavaType, arrDims);
/*     */ 
/*  84 */       TypeMappingImpl typeMapping = serContext.getTypeMapping();
/*  85 */       AbstractDeserializerFactory compDeserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(compJavaType, compXmlType);
/*  86 */       if (compDeserializerFactory == null)
/*     */       {
/*  88 */         log.warn("Cannot obtain component deserializer for: [javaType=" + compJavaType.getName() + ",xmlType=" + compXmlType + "]");
/*  89 */         compDeserializerFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(null, compXmlType);
/*     */       }
/*     */ 
/*  92 */       if (compDeserializerFactory == null) {
/*  93 */         throw new WSException("Cannot obtain component deserializer for: " + compXmlType);
/*     */       }
/*     */ 
/*  96 */       this.componentDeserializer = compDeserializerFactory.getDeserializer();
/*     */ 
/*  98 */       if ((arrDims.length < 1) || (2 < arrDims.length)) {
/*  99 */         throw new WSException("Unsupported array dimensions: " + Arrays.asList(new int[][] { arrDims }));
/*     */       }
/* 101 */       Iterator it = DOMUtils.getChildElements(soapElement);
/* 102 */       if (arrDims.length == 1)
/*     */       {
/* 104 */         Object[] subArr = retArray;
/* 105 */         deserializeMemberValues(compXmlType, serContext, it, subArr);
/*     */       }
/* 107 */       if (arrDims.length == 2)
/*     */       {
/* 109 */         for (int i = 0; i < arrDims[0]; i++)
/*     */         {
/* 111 */           Object[] subArr = (Object[])(Object[])retArray[i];
/* 112 */           deserializeMemberValues(compXmlType, serContext, it, subArr);
/*     */         }
/*     */       }
/*     */ 
/* 116 */       log.debug("deserialized: " + retArray.getClass().getName());
/* 117 */       return retArray;
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/* 121 */       throw e;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 125 */     throw new BindingException(e);
/*     */   }
/*     */ 
/*     */   private void deserializeMemberValues(QName compXmlType, SerializationContext serContext, Iterator it, Object[] subArr)
/*     */     throws BindingException
/*     */   {
/* 131 */     QName compXmlName = new QName("item");
/*     */ 
/* 133 */     int dim = subArr.length;
/* 134 */     for (int i = 0; i < dim; i++)
/*     */     {
/* 136 */       Object compValue = null;
/* 137 */       if (it.hasNext())
/*     */       {
/* 139 */         Element childElement = (Element)it.next();
/* 140 */         Source source = new DOMSource(childElement);
/* 141 */         compValue = this.componentDeserializer.deserialize(compXmlName, compXmlType, source, serContext);
/* 142 */         compValue = JavaUtils.getWrapperValueArray(compValue);
/*     */       }
/* 144 */       subArr[i] = compValue;
/*     */     }
/*     */   }
/*     */ 
/*     */   private int[] getDimensionsFromAttribute(Element arrayElement)
/*     */   {
/* 150 */     QName attrQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
/* 151 */     QName arrayType = DOMUtils.getAttributeValueAsQName(arrayElement, attrQName);
/* 152 */     if (arrayType == null) {
/* 153 */       throw new WSException("Cannot obtain attribute: " + attrQName);
/*     */     }
/* 155 */     String localPart = arrayType.getLocalPart();
/* 156 */     int dimIndex = localPart.indexOf("[");
/*     */ 
/* 158 */     String dimStr = localPart.substring(dimIndex);
/* 159 */     StringTokenizer st = new StringTokenizer(dimStr, "[,]");
/* 160 */     int[] arrDims = new int[st.countTokens()];
/* 161 */     for (int i = 0; st.hasMoreTokens(); i++) {
/* 162 */       arrDims[i] = new Integer(st.nextToken()).intValue();
/*     */     }
/* 164 */     return arrDims;
/*     */   }
/*     */ 
/*     */   private QName getComponentTypeFromAttribute(Element arrayElement)
/*     */   {
/* 169 */     QName attrQName = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
/* 170 */     QName arrayType = DOMUtils.getAttributeValueAsQName(arrayElement, attrQName);
/* 171 */     if (arrayType == null) {
/* 172 */       throw new WSException("Cannot obtain attribute: " + attrQName);
/*     */     }
/* 174 */     String nsURI = arrayType.getNamespaceURI();
/* 175 */     String localPart = arrayType.getLocalPart();
/* 176 */     int dimIndex = localPart.indexOf("[");
/* 177 */     QName compXmlType = new QName(nsURI, localPart.substring(0, dimIndex));
/*     */ 
/* 179 */     return compXmlType;
/*     */   }
/*     */ 
/*     */   private Class getJavaTypeForComponentType(QName compXmlType, SerializationContext serContext)
/*     */   {
/* 184 */     TypeMappingImpl typeMapping = serContext.getTypeMapping();
/* 185 */     Class javaType = typeMapping.getJavaType(compXmlType);
/* 186 */     if (javaType == null) {
/* 187 */       throw new WSException("Cannot obtain javaType for: " + compXmlType);
/*     */     }
/* 189 */     return JavaUtils.getWrapperType(javaType);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.SOAPArrayDeserializer
 * JD-Core Version:    0.6.0
 */