/*     */ package org.jboss.ws.core.jaxrpc.binding;
/*     */ 
/*     */ import java.io.StringWriter;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Result;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*     */ import org.jboss.ws.core.binding.ComplexTypeSerializer;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
/*     */ import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBMarshaller;
/*     */ import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBMarshallerImpl;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ import org.w3c.dom.NamedNodeMap;
/*     */ 
/*     */ public class JBossXBSerializer extends ComplexTypeSerializer
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(JBossXBSerializer.class);
/*     */   private JBossXBMarshaller marshaller;
/*     */ 
/*     */   public JBossXBSerializer()
/*     */     throws BindingException
/*     */   {
/*  62 */     this.marshaller = new JBossXBMarshallerImpl();
/*     */   }
/*     */ 
/*     */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes)
/*     */     throws BindingException
/*     */   {
/*  83 */     log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*     */ 
/*  86 */     SerializationContextJAXRPC jaxrpcContext = (SerializationContextJAXRPC)serContext;
/*     */     try
/*     */     {
/*  91 */       XSModel model = jaxrpcContext.getXsModel();
/*     */ 
/*  94 */       JavaWsdlMapping jaxrpcMapping = jaxrpcContext.getJavaWsdlMapping();
/*     */ 
/*  97 */       JBossXBMarshaller delegate = this.marshaller;
/*     */ 
/* 100 */       delegate.setProperty("org.jboss.xb.xsd.xsmodel", model);
/* 101 */       delegate.setProperty("org.jboss.xb.type.qname", xmlType);
/* 102 */       delegate.setProperty("org.jboss.xb.root.qname", xmlName);
/* 103 */       delegate.setProperty("org.jboss.xb.java.mapping", jaxrpcMapping);
/*     */ 
/* 106 */       StringWriter strwr = new StringWriter();
/* 107 */       delegate.marshal(value, strwr);
/* 108 */       String xmlFragment = strwr.toString();
/*     */ 
/* 110 */       log.debug("serialized: " + xmlFragment);
/* 111 */       return new BufferedStreamResult(xmlFragment);
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 115 */       throw rte;
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 119 */     throw new BindingException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.JBossXBSerializer
 * JD-Core Version:    0.6.0
 */