/*     */ package org.jboss.ws.core.jaxrpc.binding;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.transform.Source;
/*     */ import org.apache.xerces.xs.XSModel;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.ComplexTypeDeserializer;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.jaxrpc.SerializationContextJAXRPC;
/*     */ import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshaller;
/*     */ import org.jboss.ws.core.jaxrpc.binding.jbossxb.JBossXBUnmarshallerImpl;
/*     */ import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
/*     */ 
/*     */ public class JBossXBDeserializer extends ComplexTypeDeserializer
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(JBossXBDeserializer.class);
/*     */   private JBossXBUnmarshaller unmarshaller;
/*     */ 
/*     */   public JBossXBDeserializer()
/*     */     throws BindingException
/*     */   {
/*  58 */     this.unmarshaller = new JBossXBUnmarshallerImpl();
/*     */   }
/*     */ 
/*     */   public Object deserialize(QName xmlName, QName xmlType, Source source, SerializationContext serContext) throws BindingException {
/*  62 */     return deserialize(xmlName, xmlType, sourceToString(source), serContext);
/*     */   }
/*     */ 
/*     */   private Object deserialize(QName xmlName, QName xmlType, String val, SerializationContext serContext)
/*     */     throws BindingException
/*     */   {
/*  81 */     if (log.isDebugEnabled()) log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*     */ 
/*  84 */     SerializationContextJAXRPC jaxrpcContext = (SerializationContextJAXRPC)serContext;
/*     */ 
/*  86 */     Object value = null;
/*  87 */     String typeName = xmlType.getLocalPart();
/*     */     try
/*     */     {
/*  92 */       XSModel model = jaxrpcContext.getXsModel();
/*     */ 
/*  95 */       JavaWsdlMapping jaxrpcMapping = jaxrpcContext.getJavaWsdlMapping();
/*     */ 
/*  97 */       this.unmarshaller.setProperty("org.jboss.xb.xsd.xsmodel", model);
/*  98 */       this.unmarshaller.setProperty("org.jboss.xb.root.qname", xmlName);
/*  99 */       this.unmarshaller.setProperty("org.jboss.xb.type.qname", xmlType);
/* 100 */       this.unmarshaller.setProperty("org.jboss.xb.java.mapping", jaxrpcMapping);
/*     */ 
/* 102 */       ByteArrayInputStream ins = new ByteArrayInputStream(val.getBytes("UTF-8"));
/* 103 */       value = this.unmarshaller.unmarshal(ins);
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 107 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 111 */       throw new BindingException(ex);
/*     */     }
/*     */ 
/* 114 */     if (log.isDebugEnabled()) log.debug("deserialized: " + (value != null ? value.getClass().getName() : null));
/* 115 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializer
 * JD-Core Version:    0.6.0
 */