/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.wsf.common.DOMWriter;
/*    */ import org.w3c.dom.Element;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class ElementSerializer extends SerializerSupport
/*    */ {
/* 47 */   private static final Logger log = Logger.getLogger(ElementSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes)
/*    */     throws BindingException
/*    */   {
/* 58 */     log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/* 59 */     if (value == null)
/* 60 */       throw new IllegalArgumentException("Element value cannot be null");
/* 61 */     if (!(value instanceof Element)) {
/* 62 */       throw new IllegalArgumentException("Value is not a Element: " + value.getClass().getName());
/*    */     }
/* 64 */     String xmlFragment = DOMWriter.printNode((Element)value, false);
/* 65 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.ElementSerializer
 * JD-Core Version:    0.6.0
 */