/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Source;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.DeserializerSupport;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.wsf.common.DOMUtils;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class ElementDeserializer extends DeserializerSupport
/*    */ {
/* 45 */   private static final Logger log = Logger.getLogger(ElementDeserializer.class);
/*    */ 
/*    */   public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
/* 48 */     return deserialize(xmlName, xmlType, sourceToString(xmlFragment), serContext);
/*    */   }
/*    */ 
/*    */   private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext)
/*    */     throws BindingException
/*    */   {
/* 55 */     if (log.isDebugEnabled()) log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */ 
/*    */     try
/*    */     {
/* 59 */       Element domElement = DOMUtils.parse(xmlFragment);
/* 60 */       return domElement;
/*    */     }
/*    */     catch (RuntimeException rte)
/*    */     {
/* 64 */       throw rte;
/*    */     }
/*    */     catch (Exception ex) {
/*    */     }
/* 68 */     throw new BindingException();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.ElementDeserializer
 * JD-Core Version:    0.6.0
 */