/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import java.util.Calendar;
/*    */ import java.util.Date;
/*    */ import java.util.GregorianCalendar;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Result;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.BufferedStreamResult;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.core.binding.SerializerSupport;
/*    */ import org.jboss.xb.binding.NamespaceRegistry;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.w3c.dom.NamedNodeMap;
/*    */ 
/*    */ public class DateSerializer extends SerializerSupport
/*    */ {
/* 52 */   private static final Logger log = Logger.getLogger(DateSerializer.class);
/*    */ 
/*    */   public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException
/*    */   {
/* 56 */     if (log.isDebugEnabled()) log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/* 57 */     if (value != null)
/*    */     {
/* 59 */       Calendar cal = new GregorianCalendar();
/* 60 */       cal.setTime((Date)value);
/* 61 */       value = cal;
/*    */     }
/*    */ 
/* 64 */     String valueStr = SimpleTypeBindings.marshalDateTime((Calendar)value);
/*    */ 
/* 66 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/* 67 */     String xmlFragment = wrapValueStr(xmlName, valueStr, nsRegistry, null, attributes, true);
/* 68 */     return new BufferedStreamResult(xmlFragment);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.DateSerializer
 * JD-Core Version:    0.6.0
 */