/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import java.util.Calendar;
/*    */ import java.util.Date;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Source;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.DeserializerSupport;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ 
/*    */ public class DateDeserializer extends DeserializerSupport
/*    */ {
/* 45 */   private static final Logger log = Logger.getLogger(DateDeserializer.class);
/*    */ 
/*    */   public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
/* 48 */     return deserialize(xmlName, xmlType, sourceToString(xmlFragment), serContext);
/*    */   }
/*    */ 
/*    */   private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException
/*    */   {
/* 53 */     if (log.isDebugEnabled()) log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */ 
/* 55 */     Date value = null;
/*    */ 
/* 57 */     String valueStr = unwrapValueStr(xmlFragment);
/* 58 */     if (valueStr != null)
/*    */     {
/* 60 */       Calendar cal = SimpleTypeBindings.unmarshalDateTime(valueStr);
/* 61 */       value = cal.getTime();
/*    */     }
/*    */ 
/* 64 */     return value;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.DateDeserializer
 * JD-Core Version:    0.6.0
 */