/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import java.util.Calendar;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Source;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.Constants;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.DeserializerSupport;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ 
/*    */ public class CalendarDeserializer extends DeserializerSupport
/*    */ {
/* 46 */   private static final Logger log = Logger.getLogger(CalendarDeserializer.class);
/*    */ 
/*    */   public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException
/*    */   {
/* 50 */     return deserialize(xmlName, xmlType, sourceToString(xmlFragment), serContext);
/*    */   }
/*    */ 
/*    */   private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException
/*    */   {
/* 55 */     if (log.isDebugEnabled()) {
/* 56 */       log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */     }
/* 58 */     Calendar value = null;
/*    */ 
/* 60 */     String valueStr = unwrapValueStr(xmlFragment);
/* 61 */     if (valueStr != null)
/*    */     {
/* 63 */       if (Constants.TYPE_LITERAL_DATE.equals(xmlType))
/* 64 */         value = SimpleTypeBindings.unmarshalDate(valueStr);
/* 65 */       else if (Constants.TYPE_LITERAL_TIME.equals(xmlType))
/* 66 */         value = SimpleTypeBindings.unmarshalTime(valueStr);
/* 67 */       else if (Constants.TYPE_LITERAL_DATETIME.equals(xmlType))
/* 68 */         value = SimpleTypeBindings.unmarshalDateTime(valueStr);
/* 69 */       else throw new IllegalArgumentException("Invalid xmlType: " + xmlType);
/*    */     }
/*    */ 
/* 72 */     return value;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.CalendarDeserializer
 * JD-Core Version:    0.6.0
 */