/*    */ package org.jboss.ws.core.jaxrpc.binding;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import javax.xml.namespace.QName;
/*    */ import javax.xml.transform.Source;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.WSException;
/*    */ import org.jboss.ws.core.binding.BindingException;
/*    */ import org.jboss.ws.core.binding.DeserializerSupport;
/*    */ import org.jboss.ws.core.binding.SerializationContext;
/*    */ import org.jboss.ws.extensions.xop.XOPContext;
/*    */ import org.jboss.ws.extensions.xop.jaxrpc.XOPUnmarshallerImpl;
/*    */ import org.jboss.wsf.common.DOMUtils;
/*    */ import org.jboss.xb.binding.SimpleTypeBindings;
/*    */ import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public class Base64Deserializer extends DeserializerSupport
/*    */ {
/* 51 */   private static final Logger log = Logger.getLogger(Base64Deserializer.class);
/*    */ 
/*    */   public Object deserialize(QName xmlName, QName xmlType, Source xmlFragment, SerializationContext serContext) throws BindingException {
/* 54 */     return deserialize(xmlName, xmlType, sourceToString(xmlFragment), serContext);
/*    */   }
/*    */ 
/*    */   private Object deserialize(QName xmlName, QName xmlType, String xmlFragment, SerializationContext serContext) throws BindingException
/*    */   {
/* 59 */     if (log.isDebugEnabled()) log.debug("deserialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
/*    */ 
/* 61 */     byte[] value = null;
/*    */ 
/* 63 */     String valueStr = unwrapValueStr(xmlFragment);
/* 64 */     if (XOPContext.isXOPMessage())
/*    */     {
/*    */       try
/*    */       {
/* 68 */         Element xopInclude = DOMUtils.parse(valueStr);
/* 69 */         String cid = xopInclude.getAttribute("href");
/* 70 */         XOPUnmarshaller xopUnmarshaller = new XOPUnmarshallerImpl();
/* 71 */         value = xopUnmarshaller.getAttachmentAsByteArray(cid);
/*    */       }
/*    */       catch (IOException e)
/*    */       {
/* 75 */         throw new WSException("Failed to parse xopInclude element");
/*    */       }
/*    */     }
/* 78 */     else if (valueStr != null)
/*    */     {
/* 80 */       value = SimpleTypeBindings.unmarshalBase64(valueStr);
/*    */     }
/* 82 */     return value;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.binding.Base64Deserializer
 * JD-Core Version:    0.6.0
 */