/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import javax.xml.rpc.soap.SOAPFaultException;
/*     */ import javax.xml.soap.Detail;
/*     */ import javax.xml.soap.DetailEntry;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFault;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.CommonSOAPFaultException;
/*     */ import org.jboss.ws.core.binding.AbstractDeserializerFactory;
/*     */ import org.jboss.ws.core.binding.AbstractSerializerFactory;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.binding.DeserializerSupport;
/*     */ import org.jboss.ws.core.binding.SerializationContext;
/*     */ import org.jboss.ws.core.binding.SerializerSupport;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.MessageFactoryImpl;
/*     */ import org.jboss.ws.core.soap.NameImpl;
/*     */ import org.jboss.ws.core.soap.SOAPEnvelopeImpl;
/*     */ import org.jboss.ws.core.soap.SOAPFactoryImpl;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.ws.metadata.umdm.FaultMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class SOAPFaultHelperJAXRPC
/*     */ {
/*  78 */   private static Logger log = Logger.getLogger(SOAPFaultHelperJAXRPC.class);
/*     */ 
/*  80 */   private static List<QName> allowedFaultCodes = new ArrayList();
/*     */ 
/*     */   public static SOAPFaultException getSOAPFaultException(SOAPFault soapFault)
/*     */   {
/*  97 */     QName faultCode = ((NameImpl)soapFault.getFaultCodeAsName()).toQName();
/*  98 */     String faultString = soapFault.getFaultString();
/*  99 */     String faultActor = soapFault.getFaultActor();
/* 100 */     Detail detail = soapFault.getDetail();
/*     */ 
/* 102 */     SOAPFaultException faultEx = new SOAPFaultException(faultCode, faultString, faultActor, detail);
/*     */ 
/* 104 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 105 */     if ((detail != null) && (msgContext != null))
/*     */     {
/* 107 */       SerializationContext serContext = msgContext.getSerializationContext();
/* 108 */       TypeMapping typeMapping = serContext.getTypeMapping();
/*     */ 
/* 110 */       Iterator it = detail.getDetailEntries();
/* 111 */       while (it.hasNext())
/*     */       {
/* 113 */         DetailEntry deElement = (DetailEntry)it.next();
/* 114 */         Name deName = deElement.getElementName();
/* 115 */         QName xmlName = new QName(deName.getURI(), deName.getLocalName());
/*     */ 
/* 117 */         OperationMetaData opMetaData = msgContext.getOperationMetaData();
/* 118 */         FaultMetaData faultMetaData = opMetaData.getFault(xmlName);
/* 119 */         if (faultMetaData != null)
/*     */         {
/* 121 */           if (log.isDebugEnabled())
/* 122 */             log.debug("Deserialize fault: " + faultMetaData);
/* 123 */           QName xmlType = faultMetaData.getXmlType();
/* 124 */           Class javaType = faultMetaData.getJavaType();
/*     */ 
/* 127 */           AbstractDeserializerFactory desFactory = (AbstractDeserializerFactory)typeMapping.getDeserializer(javaType, xmlType);
/* 128 */           if (desFactory == null) {
/* 129 */             throw new JAXRPCException("Cannot obtain deserializer factory for: " + xmlType);
/*     */           }
/*     */ 
/*     */           try
/*     */           {
/* 136 */             String prefix = deName.getPrefix();
/* 137 */             if (prefix.length() > 0)
/*     */             {
/* 139 */               String nsURI = deName.getURI();
/* 140 */               String attrValue = deElement.getAttribute("xmlns:" + prefix);
/* 141 */               if ((nsURI.length() > 0) && (attrValue.length() == 0)) {
/* 142 */                 deElement.addNamespaceDeclaration(prefix, nsURI);
/*     */               }
/*     */             }
/* 145 */             Source xmlFragment = new DOMSource(deElement);
/* 146 */             DeserializerSupport des = desFactory.getDeserializer();
/* 147 */             Object userEx = des.deserialize(xmlName, xmlType, xmlFragment, serContext);
/* 148 */             if ((userEx == null) || (!(userEx instanceof Exception))) {
/* 149 */               throw new WSException("Invalid deserialization result: " + userEx);
/*     */             }
/* 151 */             faultEx.initCause((Exception)userEx);
/*     */           }
/*     */           catch (RuntimeException rte)
/*     */           {
/* 155 */             throw rte;
/*     */           }
/*     */           catch (Exception ex)
/*     */           {
/* 159 */             log.error("Cannot deserialize fault detail", ex);
/*     */           }
/*     */ 
/*     */         }
/* 164 */         else if (log.isDebugEnabled()) {
/* 165 */           log.debug("Cannot find fault meta data for: " + xmlName);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 170 */     return faultEx;
/*     */   }
/*     */ 
/*     */   public static SOAPMessageImpl exceptionToFaultMessage(Exception reqEx)
/*     */   {
/*     */     SOAPFaultException faultEx;
/*     */     SOAPFaultException faultEx;
/* 179 */     if ((reqEx instanceof SOAPFaultException))
/*     */     {
/* 181 */       faultEx = (SOAPFaultException)reqEx;
/*     */     }
/* 183 */     else if ((reqEx instanceof CommonSOAPFaultException))
/*     */     {
/* 185 */       CommonSOAPFaultException soapEx = (CommonSOAPFaultException)reqEx;
/* 186 */       QName faultCode = soapEx.getFaultCode();
/* 187 */       String faultString = soapEx.getFaultString();
/* 188 */       Throwable cause = soapEx.getCause();
/* 189 */       SOAPFaultException faultEx = new SOAPFaultException(faultCode, faultString, null, null);
/* 190 */       faultEx.initCause(cause);
/*     */     }
/*     */     else
/*     */     {
/* 194 */       QName faultCode = Constants.SOAP11_FAULT_CODE_SERVER;
/* 195 */       String faultString = reqEx.getMessage() != null ? reqEx.getMessage() : reqEx.toString();
/* 196 */       faultEx = new SOAPFaultException(faultCode, faultString, null, null);
/* 197 */       faultEx.initCause(reqEx);
/*     */     }
/*     */ 
/* 200 */     Throwable faultCause = faultEx.getCause();
/* 201 */     log.error("SOAP request exception", faultCause != null ? faultCause : faultEx);
/*     */     try
/*     */     {
/* 205 */       SOAPMessageImpl faultMessage = toSOAPMessage(faultEx);
/* 206 */       return faultMessage;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 210 */       throw rte;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 214 */       log.error("Error creating SOAPFault message", ex);
/* 215 */     }throw new JAXRPCException("Cannot create SOAPFault message for: " + faultEx);
/*     */   }
/*     */ 
/*     */   private static SOAPMessageImpl toSOAPMessage(SOAPFaultException faultEx)
/*     */     throws SOAPException
/*     */   {
/* 221 */     assertFaultCode(faultEx.getFaultCode());
/*     */ 
/* 223 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 224 */     SerializationContext serContext = msgContext != null ? msgContext.getSerializationContext() : new SerializationContextJAXRPC();
/* 225 */     NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
/*     */ 
/* 227 */     MessageFactory factory = new MessageFactoryImpl();
/* 228 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)factory.createMessage();
/*     */ 
/* 230 */     SOAPEnvelopeImpl soapEnvelope = (SOAPEnvelopeImpl)soapMessage.getSOAPPart().getEnvelope();
/* 231 */     SOAPBody soapBody = soapEnvelope.getBody();
/*     */ 
/* 233 */     QName faultCode = faultEx.getFaultCode();
/* 234 */     if (faultCode.getNamespaceURI().length() > 0) {
/* 235 */       faultCode = nsRegistry.registerQName(faultCode);
/*     */     }
/* 237 */     String faultString = getValidFaultString(faultEx);
/* 238 */     SOAPFault soapFault = soapBody.addFault(new NameImpl(faultCode), faultString);
/*     */ 
/* 240 */     String faultActor = faultEx.getFaultActor();
/* 241 */     if (faultActor != null)
/*     */     {
/* 243 */       SOAPElement soapElement = soapFault.addChildElement("faultactor");
/* 244 */       soapElement.addTextNode(faultActor);
/*     */     }
/*     */ 
/* 247 */     Exception faultCause = (Exception)faultEx.getCause();
/* 248 */     Detail detail = faultEx.getDetail();
/* 249 */     if (detail != null)
/*     */     {
/* 251 */       soapFault.addChildElement(detail);
/*     */     }
/* 253 */     else if ((faultCause != null) && (!(faultCause instanceof RuntimeException)))
/*     */     {
/* 255 */       Class javaType = faultCause.getClass();
/*     */ 
/* 257 */       TypeMapping typeMapping = serContext.getTypeMapping();
/*     */ 
/* 259 */       OperationMetaData opMetaData = msgContext.getOperationMetaData();
/* 260 */       if ((opMetaData != null) && (opMetaData.getFaultMetaData(javaType) != null))
/*     */       {
/* 262 */         FaultMetaData faultMetaData = opMetaData.getFaultMetaData(javaType);
/* 263 */         QName xmlName = faultMetaData.getXmlName();
/* 264 */         QName xmlType = faultMetaData.getXmlType();
/*     */ 
/* 266 */         xmlName = nsRegistry.registerQName(xmlName);
/*     */ 
/* 269 */         AbstractSerializerFactory serFactory = (AbstractSerializerFactory)typeMapping.getSerializer(javaType, xmlType);
/* 270 */         if (serFactory == null) {
/* 271 */           throw new JAXRPCException("Cannot obtain serializer factory for: " + xmlType);
/*     */         }
/*     */         try
/*     */         {
/* 275 */           SerializerSupport ser = serFactory.getSerializer();
/* 276 */           Result result = ser.serialize(xmlName, xmlType, faultCause, serContext, null);
/* 277 */           XMLFragment xmlFragment = new XMLFragment(result);
/*     */ 
/* 279 */           Element domElement = xmlFragment.toElement();
/* 280 */           SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
/* 281 */           SOAPElement soapElement = soapFactory.createElement(domElement);
/*     */ 
/* 283 */           detail = soapFault.addDetail();
/* 284 */           detail.addChildElement(soapElement);
/*     */         }
/*     */         catch (BindingException e)
/*     */         {
/* 288 */           throw new JAXRPCException(e);
/*     */         }
/*     */ 
/*     */       }
/* 293 */       else if (log.isDebugEnabled()) {
/* 294 */         log.debug("Cannot obtain fault meta data for: " + javaType);
/*     */       }
/*     */     }
/*     */ 
/* 298 */     return soapMessage;
/*     */   }
/*     */ 
/*     */   private static String getValidFaultString(SOAPFaultException faultEx)
/*     */   {
/* 303 */     String faultString = faultEx.getFaultString();
/* 304 */     if ((faultString == null) || (faultString.length() == 0)) {
/* 305 */       faultString = "Unqualified " + faultEx.getFaultCode() + " fault";
/*     */     }
/* 307 */     return faultString;
/*     */   }
/*     */ 
/*     */   private static void assertFaultCode(QName faultCode)
/*     */   {
/* 312 */     if (faultCode == null) {
/* 313 */       throw new IllegalArgumentException("faultcode cannot be null");
/*     */     }
/*     */ 
/* 317 */     String nsURI = faultCode.getNamespaceURI();
/* 318 */     if ("".equals(nsURI))
/*     */     {
/* 320 */       log.warn("Empty namespace URI with fault code '" + faultCode + "', assuming: " + "http://schemas.xmlsoap.org/soap/envelope/");
/* 321 */       faultCode = new QName("http://schemas.xmlsoap.org/soap/envelope/", faultCode.getLocalPart());
/*     */     }
/*     */ 
/* 325 */     if (("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) && (!allowedFaultCodes.contains(faultCode)))
/* 326 */       throw new IllegalArgumentException("Illegal faultcode '" + faultCode + "', allowed values are: " + allowedFaultCodes);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  83 */     allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_CLIENT);
/*  84 */     allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_SERVER);
/*  85 */     allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH);
/*  86 */     allowedFaultCodes.add(Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.SOAPFaultHelperJAXRPC
 * JD-Core Version:    0.6.0
 */