/*     */ package org.jboss.ws.core.jaxrpc;
/*     */ 
/*     */ import java.beans.PropertyDescriptor;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtNewMethod;
/*     */ import javassist.LoaderClassPath;
/*     */ import javax.jws.soap.SOAPBinding.ParameterStyle;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.TypeMappingImpl;
/*     */ import org.jboss.ws.core.jaxrpc.binding.JBossXBDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.JBossXBSerializerFactory;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.utils.HolderUtils;
/*     */ import org.jboss.ws.metadata.umdm.Accessor;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.umdm.WrappedParameter;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public class ParameterWrapping
/*     */ {
/*  67 */   private static Logger log = Logger.getLogger(ParameterWrapping.class);
/*     */ 
/*     */   private static void assertOperationMetaData(OperationMetaData opMetaData)
/*     */   {
/*  72 */     if (opMetaData.getStyle() != Style.DOCUMENT) {
/*  73 */       throw new WSException("Unexpected style: " + opMetaData.getStyle());
/*     */     }
/*  75 */     if (opMetaData.getParameterStyle() != SOAPBinding.ParameterStyle.WRAPPED)
/*  76 */       throw new WSException("Unexpected parameter style: " + opMetaData.getParameterStyle());
/*     */   }
/*     */ 
/*     */   private static Object holderValue(Object holder)
/*     */   {
/*  81 */     if (holder == null)
/*  82 */       return null;
/*  83 */     if (!HolderUtils.isHolderType(holder.getClass())) {
/*  84 */       return holder;
/*     */     }
/*  86 */     return HolderUtils.getHolderValue(holder);
/*     */   }
/*     */ 
/*     */   public static Class getWrappedType(String variable, Class wrapperType)
/*     */   {
/*     */     try
/*     */     {
/*  93 */       PropertyDescriptor pd = new PropertyDescriptor(variable, wrapperType);
/*  94 */       Method method = pd.getWriteMethod();
/*  95 */       return method.getParameterTypes()[0];
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/*  99 */       if (log.isDebugEnabled()) log.debug("Invalid request wrapper: " + ex); 
/*     */     }
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   public static Object wrapRequestParameters(ParameterMetaData request, Object[] methodParams)
/*     */   {
/* 106 */     assertOperationMetaData(request.getOperationMetaData());
/*     */ 
/* 108 */     Class reqStructType = request.getJavaType();
/* 109 */     if (log.isDebugEnabled()) log.debug("wrapRequestParameters: " + reqStructType.getName());
/* 110 */     List wrappedParameters = request.getWrappedParameters();
/*     */     try
/*     */     {
/* 113 */       Object reqStruct = reqStructType.newInstance();
/* 114 */       for (WrappedParameter param : wrappedParameters)
/*     */       {
/* 116 */         Object value = holderValue(methodParams[param.getIndex()]);
/* 117 */         param.accessor().set(reqStruct, value);
/*     */       }
/*     */ 
/* 120 */       return reqStruct;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 124 */       throw rte;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 128 */     throw new WSException("Cannot wrap request structure: " + e);
/*     */   }
/*     */ 
/*     */   public static Map<Integer, Object> unwrapRequestParameters(ParameterMetaData request, Object reqStruct, Object[] methodParams)
/*     */   {
/* 134 */     OperationMetaData opMetaData = request.getOperationMetaData();
/* 135 */     assertOperationMetaData(opMetaData);
/*     */ 
/* 137 */     if (reqStruct == null) {
/* 138 */       throw new IllegalArgumentException("Request struct cannot be null");
/*     */     }
/* 140 */     Class[] targetParameterTypes = opMetaData.getJavaMethod().getParameterTypes();
/* 141 */     Map outParameters = new HashMap(targetParameterTypes.length);
/* 142 */     List wrappedParameters = request.getWrappedParameters();
/* 143 */     Class reqStructType = reqStruct.getClass();
/*     */ 
/* 145 */     if (log.isDebugEnabled()) log.debug("unwrapRequestParameters: " + reqStructType.getName());
/*     */     try
/*     */     {
/* 148 */       for (WrappedParameter param : wrappedParameters)
/*     */       {
/* 150 */         Class targetType = targetParameterTypes[param.getIndex()];
/* 151 */         Object value = param.accessor().get(reqStruct);
/*     */ 
/* 154 */         if (HolderUtils.isHolderType(targetType))
/*     */         {
/* 156 */           value = HolderUtils.createHolderInstance(value, targetType);
/* 157 */           outParameters.put(Integer.valueOf(param.getIndex()), value);
/*     */         }
/*     */ 
/* 160 */         methodParams[param.getIndex()] = value;
/*     */       }
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 165 */       throw rte;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 169 */       throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
/*     */     }
/*     */ 
/* 172 */     return outParameters;
/*     */   }
/*     */ 
/*     */   public static Object wrapResponseParameters(ParameterMetaData returnMetaData, Object returnValue, Map<Integer, Object> outParameters)
/*     */   {
/* 177 */     assertOperationMetaData(returnMetaData.getOperationMetaData());
/*     */ 
/* 179 */     Class resStructType = returnMetaData.getJavaType();
/* 180 */     if ((returnValue != null) && (returnValue.getClass() == resStructType))
/*     */     {
/* 182 */       if (log.isDebugEnabled()) log.debug("Response parameter already wrapped" + resStructType.getName());
/* 183 */       return returnValue;
/*     */     }
/*     */ 
/* 186 */     if (log.isDebugEnabled()) log.debug("wrapResponseParameter: " + resStructType.getName());
/* 187 */     List wrappedParameters = returnMetaData.getWrappedParameters();
/*     */     try
/*     */     {
/* 190 */       Object resStruct = resStructType.newInstance();
/*     */ 
/* 192 */       for (WrappedParameter param : wrappedParameters)
/*     */       {
/* 194 */         Object value = param.getIndex() < 0 ? returnValue : holderValue(outParameters.get(Integer.valueOf(param.getIndex())));
/* 195 */         param.accessor().set(resStruct, value);
/*     */       }
/* 197 */       return resStruct;
/*     */     }
/*     */     catch (RuntimeException rte)
/*     */     {
/* 201 */       throw rte;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 205 */     throw new WSException("Cannot wrap response structure: " + e);
/*     */   }
/*     */ 
/*     */   public static Object unwrapResponseParameters(ParameterMetaData retMetaData, Object resStruct, Object[] methodParams)
/*     */   {
/* 211 */     OperationMetaData operationMetaData = retMetaData.getOperationMetaData();
/* 212 */     assertOperationMetaData(operationMetaData);
/*     */ 
/* 214 */     Object retValue = null;
/* 215 */     if (resStruct != null)
/*     */     {
/* 217 */       Class resStructType = resStruct.getClass();
/*     */ 
/* 219 */       if (log.isDebugEnabled()) log.debug("unwrapResponseParameter: " + resStructType.getName());
/* 220 */       List wrappedParameters = retMetaData.getWrappedParameters();
/* 221 */       Class[] targetTypes = operationMetaData.getJavaMethod().getParameterTypes();
/*     */       try
/*     */       {
/* 224 */         for (WrappedParameter param : wrappedParameters)
/*     */         {
/* 226 */           Object value = param.accessor().get(resStruct);
/* 227 */           if (param.getIndex() < 0)
/*     */           {
/* 229 */             retValue = value;
/*     */           }
/*     */           else
/*     */           {
/* 233 */             Class targetType = targetTypes[param.getIndex()];
/* 234 */             if (HolderUtils.isHolderType(targetType))
/* 235 */               HolderUtils.setHolderValue(methodParams[param.getIndex()], value);
/* 236 */             methodParams[param.getIndex()] = value;
/*     */           }
/*     */         }
/*     */       }
/*     */       catch (RuntimeException rte)
/*     */       {
/* 242 */         throw rte;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 246 */         throw new IllegalArgumentException("Cannot unwrap request structure: " + e);
/*     */       }
/*     */     }
/* 249 */     return retValue;
/*     */   }
/*     */ 
/*     */   public static void generateWrapper(ParameterMetaData pmd, boolean addTypeMapping)
/*     */   {
/* 272 */     List wrappedParameters = pmd.getWrappedParameters();
/* 273 */     OperationMetaData operationMetaData = pmd.getOperationMetaData();
/* 274 */     EndpointMetaData endpointMetaData = operationMetaData.getEndpointMetaData();
/* 275 */     ServiceMetaData serviceMetaData = endpointMetaData.getServiceMetaData();
/* 276 */     ClassLoader loader = serviceMetaData.getUnifiedMetaData().getClassLoader();
/*     */ 
/* 278 */     if (!operationMetaData.isDocumentWrapped()) {
/* 279 */       throw new WSException("Operation is not document/literal (wrapped)");
/*     */     }
/* 281 */     if (wrappedParameters == null) {
/* 282 */       throw new WSException("Cannot generate a type when their is no wrapped parameters");
/*     */     }
/* 284 */     String serviceName = serviceMetaData.getServiceName().getLocalPart();
/* 285 */     String parameterName = pmd.getXmlName().getLocalPart();
/* 286 */     String endpointName = endpointMetaData.getPortName().getLocalPart();
/* 287 */     String packageName = endpointMetaData.getServiceEndpointInterface().getPackage().getName();
/*     */ 
/* 289 */     String wrapperName = packageName + "._JBossWS_" + serviceName + "_" + endpointName + "_" + parameterName;
/* 290 */     if (log.isDebugEnabled()) log.debug("Generating wrapper: " + wrapperName);
/*     */     Class wrapperType;
/*     */     try
/*     */     {
/* 295 */       ClassPool pool = new ClassPool(true);
/* 296 */       pool.appendClassPath(new LoaderClassPath(loader));
/* 297 */       CtClass clazz = pool.makeClass(wrapperName);
/* 298 */       clazz.setSuperclass(pool.get(WrapperType.class.getName()));
/*     */ 
/* 300 */       for (WrappedParameter param : wrappedParameters)
/*     */       {
/* 302 */         CtField field = new CtField(pool.get(param.getType()), param.getVariable(), clazz);
/* 303 */         field.setModifiers(2);
/* 304 */         clazz.addField(field);
/* 305 */         clazz.addMethod(CtNewMethod.getter("get" + JavaUtils.capitalize(param.getVariable()), field));
/* 306 */         clazz.addMethod(CtNewMethod.setter("set" + JavaUtils.capitalize(param.getVariable()), field));
/*     */       }
/*     */ 
/* 309 */       wrapperType = pool.toClass(clazz, loader);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 313 */       throw new WSException("Could not generate wrapper type: " + wrapperName, e);
/*     */     }
/*     */ 
/* 317 */     if (addTypeMapping)
/*     */     {
/* 319 */       QName xmlType = pmd.getXmlType();
/*     */ 
/* 321 */       TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
/* 322 */       TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, wrapperName);
/* 323 */       typesMetaData.addTypeMapping(tmMetaData);
/*     */ 
/* 325 */       TypeMappingImpl typeMapping = serviceMetaData.getTypeMapping();
/* 326 */       typeMapping.register(wrapperType, xmlType, new JBossXBSerializerFactory(), new JBossXBDeserializerFactory());
/*     */     }
/*     */ 
/* 329 */     pmd.setJavaTypeName(wrapperName);
/*     */   }
/*     */ 
/*     */   public static class WrapperType
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.jaxrpc.ParameterWrapping
 * JD-Core Version:    0.6.0
 */