/*     */ package org.jboss.ws.core.client;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Field;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.net.URL;
/*     */ import java.security.CodeSource;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.xml.soap.MimeHeader;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.ws.addressing.EndpointReference;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.Version;
/*     */ import org.jboss.remoting.marshal.MarshalFactory;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.UnMarshaller;
/*     */ import org.jboss.ws.core.CommonMessageContext;
/*     */ import org.jboss.ws.core.MessageAbstraction;
/*     */ import org.jboss.ws.core.MessageTrace;
/*     */ import org.jboss.ws.core.WSTimeoutException;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ 
/*     */ public abstract class RemotingConnectionImpl
/*     */   implements RemotingConnection
/*     */ {
/*  73 */   private static Logger log = Logger.getLogger(RemotingConnectionImpl.class);
/*     */ 
/*  75 */   private Map<String, Object> clientConfig = new HashMap();
/*     */ 
/*  77 */   private static Map<String, String> metadataMap = new HashMap();
/*     */   private static Map<String, String> configMap;
/*     */   private boolean closed;
/*     */ 
/*     */   public RemotingConnectionImpl()
/*     */   {
/* 110 */     this.clientConfig.put("enableLease", Boolean.valueOf(false));
/*     */   }
/*     */ 
/*     */   public boolean isClosed()
/*     */   {
/* 115 */     return this.closed;
/*     */   }
/*     */ 
/*     */   public void setClosed(boolean closed)
/*     */   {
/* 120 */     this.closed = closed;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway)
/*     */     throws IOException
/*     */   {
/* 130 */     if (endpoint == null) {
/* 131 */       throw new IllegalArgumentException("Given endpoint cannot be null");
/*     */     }
/* 133 */     if (this.closed) {
/* 134 */       throw new IOException("Connection is already closed");
/*     */     }
/* 136 */     Object timeout = null;
/*     */ 
/* 138 */     Map callProps = new HashMap();
/*     */     String targetAddress;
/* 140 */     if ((endpoint instanceof EndpointInfo))
/*     */     {
/* 142 */       EndpointInfo epInfo = (EndpointInfo)endpoint;
/* 143 */       String targetAddress = epInfo.getTargetAddress();
/* 144 */       callProps = epInfo.getProperties();
/*     */ 
/* 146 */       if (callProps.containsKey("org.jboss.ws.timeout"))
/*     */       {
/* 148 */         timeout = callProps.get("org.jboss.ws.timeout");
/* 149 */         targetAddress = addURLParameter(targetAddress, "timeout", timeout.toString());
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*     */       String targetAddress;
/* 153 */       if ((endpoint instanceof EndpointReference))
/*     */       {
/* 155 */         EndpointReference epr = (EndpointReference)endpoint;
/* 156 */         targetAddress = epr.getAddress().toString();
/*     */       }
/*     */       else
/*     */       {
/* 160 */         targetAddress = endpoint.toString();
/*     */       }
/* 164 */     }
/*     */ Map metadata = createRemotingMetaData(reqMessage, callProps);
/* 165 */     Client client = createRemotingClient(endpoint, targetAddress, oneway);
/*     */     IOException io;
/*     */     try {
/* 169 */       if (log.isDebugEnabled()) {
/* 170 */         log.debug("Remoting metadata: " + metadata);
/*     */       }
/*     */ 
/* 173 */       MessageTrace.traceMessage("Outgoing Request Message", reqMessage);
/*     */ 
/* 175 */       MessageAbstraction resMessage = null;
/*     */ 
/* 177 */       if (oneway == true)
/*     */       {
/* 179 */         client.invokeOneway(reqMessage, metadata, false);
/*     */       }
/*     */       else
/*     */       {
/* 183 */         resMessage = (MessageAbstraction)client.invoke(reqMessage, metadata);
/*     */       }
/*     */ 
/* 187 */       client.disconnect();
/*     */ 
/* 189 */       callProps.clear();
/* 190 */       callProps.putAll(metadata);
/*     */ 
/* 193 */       MessageTrace.traceMessage("Incoming Response Message", resMessage);
/*     */ 
/* 195 */       return resMessage;
/*     */     }
/*     */     catch (Throwable th)
/*     */     {
/* 199 */       if ((timeout != null) && ((th.getCause() instanceof SocketTimeoutException)))
/*     */       {
/* 201 */         throw new WSTimeoutException("Timeout after: " + timeout + "ms", new Long(timeout.toString()).longValue());
/*     */       }
/*     */ 
/* 204 */       io = new IOException("Could not transmit message");
/* 205 */       io.initCause(th);
/* 206 */     }throw io;
/*     */   }
/*     */ 
/*     */   private String addURLParameter(String urlStr, String key, String value)
/*     */     throws MalformedURLException
/*     */   {
/* 212 */     URL url = new URL(urlStr);
/* 213 */     urlStr = urlStr + (url.getQuery() == null ? "?" : "&") + key + "=" + value;
/* 214 */     return urlStr;
/*     */   }
/*     */ 
/*     */   private Client createRemotingClient(Object endpoint, String targetAddress, boolean oneway)
/*     */   {
/*     */     Client client;
/*     */     try
/*     */     {
/* 223 */       log.debug("Get locator for: " + endpoint);
/*     */ 
/* 225 */       Marshaller marshaller = getMarshaller();
/* 226 */       UnMarshaller unmarshaller = getUnmarshaller();
/*     */ 
/* 238 */       String version = getRemotingVersion();
/* 239 */       if (version.startsWith("1.4"))
/*     */       {
/* 241 */         targetAddress = addURLParameter(targetAddress, "datatype", "JBossWSMessage");
/* 242 */         MarshalFactory.addMarshaller("JBossWSMessage", marshaller, unmarshaller);
/*     */       }
/*     */ 
/* 245 */       InvokerLocator locator = new InvokerLocator(targetAddress);
/* 246 */       client = new Client(locator, "jbossws", this.clientConfig);
/* 247 */       client.connect();
/*     */ 
/* 249 */       client.setMarshaller(marshaller);
/*     */ 
/* 251 */       if (!oneway)
/* 252 */         client.setUnMarshaller(unmarshaller);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 256 */       throw new IllegalArgumentException("Malformed endpoint address", e);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 260 */       throw new IllegalStateException("Could not setup remoting client", e);
/*     */     }
/* 262 */     return client;
/*     */   }
/*     */ 
/*     */   private String getRemotingVersion()
/*     */   {
/* 267 */     String version = null;
/*     */     try
/*     */     {
/* 271 */       Field field = Version.class.getDeclaredField("VERSION");
/* 272 */       version = (String)field.get(null);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 276 */       throw new RuntimeException("Cannot obtain remoting version", ex);
/*     */     }
/*     */ 
/* 279 */     if (version == null)
/*     */     {
/* 281 */       URL codeURL = Version.class.getProtectionDomain().getCodeSource().getLocation();
/* 282 */       throw new RuntimeException("Cannot obtain remoting version from: " + codeURL);
/*     */     }
/* 284 */     return version;
/*     */   }
/*     */   protected abstract UnMarshaller getUnmarshaller();
/*     */ 
/*     */   protected abstract Marshaller getMarshaller();
/*     */ 
/*     */   private Map<String, Object> createRemotingMetaData(MessageAbstraction reqMessage, Map callProps) {
/* 293 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/*     */ 
/* 295 */     Map metadata = new HashMap();
/*     */ 
/* 299 */     metadata.put("NoThrowOnError", "true");
/*     */ 
/* 301 */     if (reqMessage != null)
/*     */     {
/* 303 */       populateHeaders(reqMessage, metadata);
/*     */ 
/* 306 */       this.clientConfig.put("chunkedLength", "1024");
/*     */ 
/* 309 */       if (msgContext != null)
/*     */       {
/* 311 */         Properties epmdProps = msgContext.getEndpointMetaData().getProperties();
/*     */ 
/* 314 */         String chunkSizeValue = epmdProps.getProperty("http://org.jboss.ws/http#chunksize");
/* 315 */         int chunkSize = chunkSizeValue != null ? Integer.valueOf(chunkSizeValue).intValue() : -1;
/* 316 */         if (chunkSize > 0)
/*     */         {
/* 318 */           this.clientConfig.put("http://org.jboss.ws/http#chunksize", chunkSizeValue);
/*     */         }
/*     */         else
/*     */         {
/* 322 */           this.clientConfig.remove("chunkedLength");
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 328 */       metadata.put("TYPE", "GET");
/*     */     }
/*     */ 
/* 331 */     if (callProps != null)
/*     */     {
/* 333 */       Iterator it = callProps.entrySet().iterator();
/*     */ 
/* 336 */       String authType = (String)callProps.get("org.jboss.ws.authType");
/* 337 */       if (authType == null) {
/* 338 */         authType = "org.jboss.ws.authType.basic";
/*     */       }
/* 340 */       while (it.hasNext())
/*     */       {
/* 342 */         Map.Entry entry = (Map.Entry)it.next();
/* 343 */         String key = (String)entry.getKey();
/* 344 */         Object val = entry.getValue();
/*     */ 
/* 347 */         if (metadataMap.containsKey(key))
/*     */         {
/* 349 */           String remotingKey = (String)metadataMap.get(key);
/* 350 */           if (("http.basic.username".equals(remotingKey)) || ("http.basic.password".equals(remotingKey)))
/*     */           {
/* 352 */             if (authType.equals("org.jboss.ws.authType.basic"))
/*     */             {
/* 354 */               metadata.put(remotingKey, val);
/*     */             }
/*     */             else
/*     */             {
/* 358 */               log.warn("Ignore '" + key + "' with auth typy: " + authType);
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 363 */             metadata.put(remotingKey, val);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 368 */         if (configMap.containsKey(key))
/*     */         {
/* 370 */           String remotingKey = (String)configMap.get(key);
/* 371 */           this.clientConfig.put(remotingKey, val);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 376 */     return metadata;
/*     */   }
/*     */ 
/*     */   protected void populateHeaders(MessageAbstraction reqMessage, Map<String, Object> metadata)
/*     */   {
/* 381 */     MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
/*     */ 
/* 383 */     Properties props = new Properties();
/* 384 */     metadata.put("HEADER", props);
/*     */ 
/* 386 */     Iterator i = mimeHeaders.getAllHeaders();
/* 387 */     while (i.hasNext())
/*     */     {
/* 389 */       MimeHeader header = (MimeHeader)i.next();
/* 390 */       String currentValue = props.getProperty(header.getName());
/*     */ 
/* 405 */       if (currentValue != null)
/*     */       {
/* 407 */         props.put(header.getName(), currentValue + "," + header.getValue());
/*     */       }
/*     */       else
/*     */       {
/* 411 */         props.put(header.getName(), header.getValue());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  80 */     metadataMap.put("javax.xml.rpc.security.auth.username", "http.basic.username");
/*  81 */     metadataMap.put("javax.xml.rpc.security.auth.password", "http.basic.password");
/*  82 */     metadataMap.put("javax.xml.ws.security.auth.username", "http.basic.username");
/*  83 */     metadataMap.put("javax.xml.ws.security.auth.password", "http.basic.password");
/*     */ 
/*  85 */     configMap = new HashMap();
/*     */ 
/*  96 */     configMap.put("org.jboss.ws.keyStore", "org.jboss.remoting.keyStore");
/*  97 */     configMap.put("org.jboss.ws.keyStorePassword", "org.jboss.remoting.keyStorePassword");
/*  98 */     configMap.put("org.jboss.ws.keyStoreType", "org.jboss.remoting.keyStoreType");
/*  99 */     configMap.put("org.jboss.ws.trustStore", "org.jboss.remoting.trustStore");
/* 100 */     configMap.put("org.jboss.ws.trustStorePassword", "org.jboss.remoting.trustStorePassword");
/* 101 */     configMap.put("org.jboss.ws.trustStoreType", "org.jboss.remoting.trustStoreType");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.client.RemotingConnectionImpl
 * JD-Core Version:    0.6.0
 */