/*    */ package org.jboss.ws.core.client;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import java.util.Map;
/*    */ import java.util.Map.Entry;
/*    */ import java.util.Properties;
/*    */ import java.util.Set;
/*    */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*    */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*    */ 
/*    */ public class EndpointInfo
/*    */ {
/*    */   private String targetAddress;
/*    */   private Map<String, Object> properties;
/*    */ 
/*    */   public EndpointInfo(EndpointMetaData epMetaData, String targetAddress, Map<String, Object> callProps)
/*    */   {
/* 44 */     this.targetAddress = targetAddress;
/* 45 */     this.properties = callProps;
/*    */ 
/* 48 */     Properties serviceProps = epMetaData.getServiceMetaData().getProperties();
/* 49 */     if (serviceProps != null)
/*    */     {
/* 51 */       Iterator it = serviceProps.entrySet().iterator();
/* 52 */       while (it.hasNext())
/*    */       {
/* 54 */         Map.Entry entry = (Map.Entry)it.next();
/* 55 */         String key = (String)entry.getKey();
/* 56 */         Object val = entry.getValue();
/* 57 */         this.properties.put(key, val);
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 62 */     Properties epProps = epMetaData.getProperties();
/* 63 */     Iterator it = epProps.entrySet().iterator();
/* 64 */     while (it.hasNext())
/*    */     {
/* 66 */       Map.Entry entry = (Map.Entry)it.next();
/* 67 */       String key = (String)entry.getKey();
/* 68 */       Object val = entry.getValue();
/* 69 */       this.properties.put(key, val);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Map<String, Object> getProperties()
/*    */   {
/* 76 */     return this.properties;
/*    */   }
/*    */ 
/*    */   public String getTargetAddress()
/*    */   {
/* 81 */     return this.targetAddress;
/*    */   }
/*    */ 
/*    */   public boolean equals(Object obj)
/*    */   {
/* 86 */     if (!(obj instanceof EndpointInfo))
/* 87 */       return false;
/* 88 */     return toString().equals(obj.toString());
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 93 */     return toString().hashCode();
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 98 */     return "[addr=" + this.targetAddress + ",props=" + this.properties + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.client.EndpointInfo
 * JD-Core Version:    0.6.0
 */