/*     */ package org.jboss.ws.core.binding;
/*     */ 
/*     */ import java.math.BigDecimal;
/*     */ import java.math.BigInteger;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.encoding.DeserializerFactory;
/*     */ import javax.xml.rpc.encoding.SerializerFactory;
/*     */ import javax.xml.rpc.encoding.TypeMapping;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.Constants;
/*     */ import org.jboss.ws.core.jaxrpc.binding.Base64DeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.Base64SerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.CalendarDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.CalendarSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.DateDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.DateSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.HexDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.HexSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.QNameDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.QNameSerializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SimpleDeserializerFactory;
/*     */ import org.jboss.ws.core.jaxrpc.binding.SimpleSerializerFactory;
/*     */ import org.jboss.ws.core.utils.HashCodeUtil;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ 
/*     */ public abstract class TypeMappingImpl
/*     */   implements TypeMapping
/*     */ {
/*  72 */   private static final Logger log = Logger.getLogger(TypeMappingImpl.class);
/*     */   private Map<KeyPair, FactoryPair> tupleMap;
/*     */   private Map<Integer, List<KeyPair>> keyPairCache;
/*     */ 
/*     */   public TypeMappingImpl()
/*     */   {
/*  75 */     this.tupleMap = new LinkedHashMap();
/*     */ 
/*  77 */     this.keyPairCache = new ConcurrentHashMap();
/*     */   }
/*     */ 
/*     */   public DeserializerFactory getDeserializer(Class javaType, QName xmlType)
/*     */   {
/*  87 */     FactoryPair fPair = getFactoryPair(new IQName(xmlType), javaType);
/*  88 */     return fPair != null ? fPair.getDeserializerFactory() : null;
/*     */   }
/*     */ 
/*     */   public SerializerFactory getSerializer(Class javaType, QName xmlType)
/*     */   {
/*  99 */     FactoryPair fPair = getFactoryPair(new IQName(xmlType), javaType);
/* 100 */     return fPair != null ? fPair.getSerializerFactory() : null;
/*     */   }
/*     */ 
/*     */   public abstract String[] getSupportedEncodings();
/*     */ 
/*     */   public abstract void setSupportedEncodings(String[] paramArrayOfString);
/*     */ 
/*     */   public boolean isRegistered(Class javaType, QName xmlType)
/*     */   {
/* 128 */     return getFactoryPair(new IQName(xmlType), javaType) != null;
/*     */   }
/*     */ 
/*     */   public void register(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory df)
/*     */   {
/* 142 */     if (log.isTraceEnabled()) {
/* 143 */       log.trace("register: TypeMappingImpl@" + hashCode() + " [xmlType=" + xmlType + ",javaType=" + javaType.getName() + ",sf=" + sf + ",df=" + df + "]");
/*     */     }
/* 145 */     registerInternal(javaType, new IQName(xmlType), sf, df);
/* 146 */     this.keyPairCache.clear();
/*     */   }
/*     */ 
/*     */   private void registerInternal(Class javaType, IQName xmlType, SerializerFactory sf, DeserializerFactory df)
/*     */   {
/* 151 */     if (javaType == null)
/* 152 */       throw new IllegalArgumentException("javaType cannot be null for: " + xmlType);
/* 153 */     if (xmlType == null) {
/* 154 */       throw new IllegalArgumentException("xmlType cannot be null for: " + javaType);
/*     */     }
/* 156 */     KeyPair kPair = new KeyPair(xmlType, javaType);
/* 157 */     FactoryPair fPair = new FactoryPair(sf, df);
/* 158 */     this.tupleMap.put(kPair, fPair);
/*     */   }
/*     */ 
/*     */   public void removeDeserializer(Class javaType, QName xmlType)
/*     */   {
/* 169 */     FactoryPair fPair = getFactoryPair(new IQName(xmlType), javaType);
/* 170 */     if (fPair != null)
/* 171 */       fPair.setDeserializerFactory(null);
/*     */   }
/*     */ 
/*     */   public void removeSerializer(Class javaType, QName xmlType)
/*     */   {
/* 182 */     FactoryPair fPair = getFactoryPair(new IQName(xmlType), javaType);
/* 183 */     if (fPair != null)
/* 184 */       fPair.setSerializerFactory(null);
/*     */   }
/*     */ 
/*     */   public List<QName> getRegisteredXmlTypes()
/*     */   {
/* 190 */     List types = new ArrayList();
/* 191 */     for (KeyPair keyPair : getKeyPairs(null, null))
/*     */     {
/* 193 */       types.add(keyPair.getXmlType().toQName());
/*     */     }
/* 195 */     return types;
/*     */   }
/*     */ 
/*     */   public List<Class> getRegisteredJavaTypes()
/*     */   {
/* 201 */     List types = new ArrayList();
/* 202 */     for (KeyPair keyPair : getKeyPairs(null, null))
/*     */     {
/* 204 */       types.add(keyPair.getJavaType());
/*     */     }
/* 206 */     return types;
/*     */   }
/*     */ 
/*     */   public Class getJavaType(QName xmlType)
/*     */   {
/* 212 */     Class javaType = null;
/*     */ 
/* 214 */     List keyPairList = getKeyPairs(new IQName(xmlType), null);
/* 215 */     int size = keyPairList.size();
/* 216 */     if (size > 0)
/*     */     {
/* 218 */       KeyPair kPair = (KeyPair)keyPairList.get(size - 1);
/* 219 */       javaType = kPair.getJavaType();
/*     */     }
/*     */ 
/* 222 */     return javaType;
/*     */   }
/*     */ 
/*     */   public List<Class> getJavaTypes(QName xmlType)
/*     */   {
/* 230 */     List keyPairList = getKeyPairs(new IQName(xmlType), null);
/* 231 */     List classes = new ArrayList(keyPairList.size());
/*     */ 
/* 233 */     for (KeyPair current : keyPairList)
/*     */     {
/* 235 */       classes.add(current.getJavaType());
/*     */     }
/*     */ 
/* 238 */     return classes;
/*     */   }
/*     */ 
/*     */   public Class getJavaType(QName xmlType, boolean getPrimitive)
/*     */   {
/* 250 */     Class javaType = null;
/*     */ 
/* 252 */     List keyPairList = getKeyPairs(new IQName(xmlType), null);
/* 253 */     int size = keyPairList.size();
/* 254 */     if ((size == 2) && (getPrimitive))
/*     */     {
/* 256 */       KeyPair kPair1 = (KeyPair)keyPairList.get(0);
/* 257 */       Class javaType1 = kPair1.getJavaType();
/* 258 */       KeyPair kPair2 = (KeyPair)keyPairList.get(1);
/* 259 */       Class javaType2 = kPair2.getJavaType();
/* 260 */       if ((javaType2.isPrimitive()) && (!javaType1.isPrimitive())) {
/* 261 */         javaType = javaType2;
/*     */       }
/* 263 */       else if ((javaType1.isPrimitive()) && (!javaType2.isPrimitive()))
/* 264 */         javaType = javaType1;
/*     */       else
/* 266 */         javaType = javaType2;
/*     */     }
/*     */     else {
/* 269 */       return getJavaType(xmlType);
/*     */     }
/* 271 */     return javaType;
/*     */   }
/*     */ 
/*     */   public String getJavaTypeName(QName xmlType)
/*     */   {
/* 277 */     Class javaType = getJavaType(xmlType);
/* 278 */     return javaType != null ? javaType.getName() : null;
/*     */   }
/*     */ 
/*     */   public QName getXMLType(Class javaType)
/*     */   {
/* 284 */     QName xmlType = null;
/*     */ 
/* 286 */     List keyPairList = getKeyPairs(null, javaType);
/* 287 */     int size = keyPairList.size();
/* 288 */     if (size > 0)
/*     */     {
/* 290 */       KeyPair kPair = (KeyPair)keyPairList.get(size - 1);
/* 291 */       xmlType = kPair.getXmlType().toQName();
/*     */     }
/*     */ 
/* 294 */     return xmlType;
/*     */   }
/*     */ 
/*     */   public List<QName> getXMLTypes(Class javaType)
/*     */   {
/* 300 */     List xmlTypes = new ArrayList();
/*     */ 
/* 302 */     for (KeyPair kPair : getKeyPairs(null, javaType))
/*     */     {
/* 304 */       xmlTypes.add(kPair.getXmlType().toQName());
/*     */     }
/* 306 */     return xmlTypes;
/*     */   }
/*     */ 
/*     */   public QName getXMLType(Class javaType, boolean tryAssignable)
/*     */   {
/* 318 */     if (tryAssignable) return getXMLType(javaType);
/*     */ 
/* 320 */     QName xmlType = null;
/*     */ 
/* 322 */     List keyPairList = getKeyPairs(null, javaType, tryAssignable);
/* 323 */     int size = keyPairList.size();
/* 324 */     if (size > 0)
/*     */     {
/* 326 */       KeyPair kPair = (KeyPair)keyPairList.get(size - 1);
/* 327 */       xmlType = kPair.getXmlType().toQName();
/*     */     }
/*     */ 
/* 330 */     return xmlType;
/*     */   }
/*     */ 
/*     */   private List<KeyPair> getKeyPairs(IQName xmlType, Class javaType)
/*     */   {
/* 343 */     Integer cacheId = cacheIdFor(javaType, xmlType);
/*     */ 
/* 345 */     List keyPairList = (List)this.keyPairCache.get(cacheId);
/* 346 */     if (null == keyPairList)
/*     */     {
/* 348 */       keyPairList = getKeyPairsInternal(xmlType, javaType);
/* 349 */       this.keyPairCache.put(cacheId, keyPairList);
/*     */     }
/*     */ 
/* 352 */     return keyPairList;
/*     */   }
/*     */ 
/*     */   private Integer cacheIdFor(Class javaType, IQName xmlType) {
/* 356 */     int result = 23;
/* 357 */     int nullHash = HashCodeUtil.hash(result, "null");
/* 358 */     result = javaType != null ? HashCodeUtil.hash(result, javaType.getName()) : HashCodeUtil.hash(result, nullHash);
/* 359 */     result = xmlType != null ? HashCodeUtil.hash(result, xmlType.hashCode()) : HashCodeUtil.hash(result, nullHash);
/* 360 */     return new Integer(result);
/*     */   }
/*     */ 
/*     */   private List<KeyPair> getKeyPairsInternal(IQName xmlType, Class javaType)
/*     */   {
/* 365 */     List keyPairList = new ArrayList();
/*     */ 
/* 368 */     if ((xmlType != null) && (javaType != null))
/*     */     {
/* 370 */       for (KeyPair entry : this.tupleMap.keySet())
/*     */       {
/* 372 */         if ((xmlType.equals(entry.getXmlType())) && (entry.getJavaType() == javaType))
/*     */         {
/* 374 */           keyPairList.add(entry);
/*     */         }
/*     */       }
/*     */ 
/* 378 */       if (keyPairList.size() == 0)
/*     */       {
/* 380 */         for (KeyPair entry : this.tupleMap.keySet())
/*     */         {
/* 382 */           if ((xmlType.equals(entry.getXmlType())) && (JavaUtils.isAssignableFrom(entry.getJavaType(), javaType)))
/*     */           {
/* 384 */             keyPairList.add(entry);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 391 */     else if ((xmlType != null) && (javaType == null))
/*     */     {
/* 393 */       for (KeyPair entry : this.tupleMap.keySet())
/*     */       {
/* 395 */         if (xmlType.equals(entry.getXmlType()))
/*     */         {
/* 397 */           keyPairList.add(entry);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 403 */     else if ((xmlType == null) && (javaType != null))
/*     */     {
/* 405 */       for (KeyPair entry : this.tupleMap.keySet())
/*     */       {
/* 407 */         if (entry.getJavaType() == javaType)
/*     */         {
/* 409 */           keyPairList.add(entry);
/*     */         }
/*     */       }
/*     */ 
/* 413 */       if (keyPairList.size() == 0)
/*     */       {
/* 415 */         for (KeyPair entry : this.tupleMap.keySet())
/*     */         {
/* 417 */           if (JavaUtils.isAssignableFrom(entry.getJavaType(), javaType))
/*     */           {
/* 419 */             keyPairList.add(entry);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 426 */     else if ((xmlType == null) && (javaType == null))
/*     */     {
/* 428 */       keyPairList.addAll(this.tupleMap.keySet());
/*     */     }
/*     */ 
/* 431 */     return keyPairList;
/*     */   }
/*     */ 
/*     */   private List<KeyPair> getKeyPairs(IQName xmlType, Class javaType, boolean tryAssignable)
/*     */   {
/* 436 */     Integer cacheId = cacheIdFor(javaType, xmlType);
/*     */ 
/* 438 */     List keyPairList = (List)this.keyPairCache.get(cacheId);
/* 439 */     if (null == keyPairList)
/*     */     {
/* 441 */       keyPairList = getKeyPairsInternal(xmlType, javaType, tryAssignable);
/* 442 */       this.keyPairCache.put(cacheId, keyPairList);
/*     */     }
/*     */ 
/* 445 */     return keyPairList;
/*     */   }
/*     */ 
/*     */   private List<KeyPair> getKeyPairsInternal(IQName xmlType, Class javaType, boolean tryAssignable)
/*     */   {
/* 457 */     if (tryAssignable) return getKeyPairs(xmlType, javaType);
/*     */ 
/* 459 */     List keyPairList = new ArrayList();
/*     */ 
/* 462 */     if ((xmlType != null) && (javaType != null))
/*     */     {
/* 464 */       for (KeyPair entry : this.tupleMap.keySet())
/*     */       {
/* 466 */         if ((xmlType.equals(entry.getXmlType())) && (entry.getJavaType() == javaType))
/*     */         {
/* 468 */           keyPairList.add(entry);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 474 */     else if ((xmlType != null) && (javaType == null))
/*     */     {
/* 476 */       for (KeyPair entry : this.tupleMap.keySet())
/*     */       {
/* 478 */         if (xmlType.equals(entry.getXmlType()))
/*     */         {
/* 480 */           keyPairList.add(entry);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 486 */     else if ((xmlType == null) && (javaType != null))
/*     */     {
/* 488 */       for (KeyPair entry : this.tupleMap.keySet())
/*     */       {
/* 490 */         if (entry.getJavaType() == javaType)
/*     */         {
/* 492 */           keyPairList.add(entry);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/* 498 */     else if ((xmlType == null) && (javaType == null))
/*     */     {
/* 500 */       keyPairList.addAll(this.tupleMap.keySet());
/*     */     }
/*     */ 
/* 503 */     return keyPairList;
/*     */   }
/*     */ 
/*     */   private FactoryPair getFactoryPair(IQName xmlType, Class javaType)
/*     */   {
/* 513 */     FactoryPair fPair = null;
/*     */ 
/* 515 */     List keyPairList = getKeyPairs(xmlType, javaType);
/* 516 */     int size = keyPairList.size();
/* 517 */     if (size > 0)
/*     */     {
/* 519 */       KeyPair kPair = (KeyPair)keyPairList.get(size - 1);
/* 520 */       fPair = (FactoryPair)this.tupleMap.get(kPair);
/*     */     }
/*     */ 
/* 523 */     return fPair;
/*     */   }
/*     */ 
/*     */   protected void registerStandardLiteralTypes()
/*     */   {
/* 528 */     register(BigDecimal.class, Constants.TYPE_LITERAL_DECIMAL, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 530 */     register(BigInteger.class, Constants.TYPE_LITERAL_POSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 531 */     register(BigInteger.class, Constants.TYPE_LITERAL_NEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 532 */     register(BigInteger.class, Constants.TYPE_LITERAL_NONPOSITIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 533 */     register(BigInteger.class, Constants.TYPE_LITERAL_NONNEGATIVEINTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 534 */     register(BigInteger.class, Constants.TYPE_LITERAL_UNSIGNEDLONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 535 */     register(BigInteger.class, Constants.TYPE_LITERAL_INTEGER, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 537 */     register(Date.class, Constants.TYPE_LITERAL_DATETIME, new DateSerializerFactory(), new DateDeserializerFactory());
/*     */ 
/* 539 */     register(Calendar.class, Constants.TYPE_LITERAL_DATE, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
/* 540 */     register(Calendar.class, Constants.TYPE_LITERAL_TIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
/* 541 */     register(Calendar.class, Constants.TYPE_LITERAL_DATETIME, new CalendarSerializerFactory(), new CalendarDeserializerFactory());
/*     */ 
/* 543 */     register(QName.class, Constants.TYPE_LITERAL_QNAME, new QNameSerializerFactory(), new QNameDeserializerFactory());
/*     */ 
/* 545 */     register(String.class, Constants.TYPE_LITERAL_ANYSIMPLETYPE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 546 */     register(String.class, Constants.TYPE_LITERAL_DURATION, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 547 */     register(String.class, Constants.TYPE_LITERAL_GDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 548 */     register(String.class, Constants.TYPE_LITERAL_GMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 549 */     register(String.class, Constants.TYPE_LITERAL_GMONTHDAY, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 550 */     register(String.class, Constants.TYPE_LITERAL_GYEAR, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 551 */     register(String.class, Constants.TYPE_LITERAL_GYEARMONTH, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 552 */     register(String.class, Constants.TYPE_LITERAL_ID, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 553 */     register(String.class, Constants.TYPE_LITERAL_LANGUAGE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 554 */     register(String.class, Constants.TYPE_LITERAL_NAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 555 */     register(String.class, Constants.TYPE_LITERAL_NCNAME, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 556 */     register(String.class, Constants.TYPE_LITERAL_NMTOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 557 */     register(String.class, Constants.TYPE_LITERAL_NORMALIZEDSTRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 558 */     register(String.class, Constants.TYPE_LITERAL_TOKEN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 559 */     register(String.class, Constants.TYPE_LITERAL_STRING, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 561 */     register([Ljava.lang.String.class, Constants.TYPE_LITERAL_NMTOKENS, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 563 */     register(URI.class, Constants.TYPE_LITERAL_ANYURI, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 565 */     register(Boolean.TYPE, Constants.TYPE_LITERAL_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 566 */     register(Boolean.class, Constants.TYPE_LITERAL_BOOLEAN, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 568 */     register(Byte.TYPE, Constants.TYPE_LITERAL_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 569 */     register(Byte.class, Constants.TYPE_LITERAL_BYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 571 */     register([Ljava.lang.Byte.class, Constants.TYPE_LITERAL_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
/* 572 */     register([B.class, Constants.TYPE_LITERAL_HEXBINARY, new HexSerializerFactory(), new HexDeserializerFactory());
/*     */ 
/* 574 */     register([Ljava.lang.Byte.class, Constants.TYPE_LITERAL_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
/* 575 */     register([B.class, Constants.TYPE_LITERAL_BASE64BINARY, new Base64SerializerFactory(), new Base64DeserializerFactory());
/*     */ 
/* 577 */     register(Double.TYPE, Constants.TYPE_LITERAL_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 578 */     register(Double.class, Constants.TYPE_LITERAL_DOUBLE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 580 */     register(Float.TYPE, Constants.TYPE_LITERAL_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 581 */     register(Float.class, Constants.TYPE_LITERAL_FLOAT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 583 */     register(Integer.TYPE, Constants.TYPE_LITERAL_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 584 */     register(Integer.class, Constants.TYPE_LITERAL_UNSIGNEDSHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 585 */     register(Integer.TYPE, Constants.TYPE_LITERAL_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 586 */     register(Integer.class, Constants.TYPE_LITERAL_INT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 588 */     register(Long.TYPE, Constants.TYPE_LITERAL_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 589 */     register(Long.class, Constants.TYPE_LITERAL_UNSIGNEDINT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 590 */     register(Long.TYPE, Constants.TYPE_LITERAL_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 591 */     register(Long.class, Constants.TYPE_LITERAL_LONG, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */ 
/* 593 */     register(Short.TYPE, Constants.TYPE_LITERAL_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 594 */     register(Short.class, Constants.TYPE_LITERAL_UNSIGNEDBYTE, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 595 */     register(Short.TYPE, Constants.TYPE_LITERAL_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/* 596 */     register(Short.class, Constants.TYPE_LITERAL_SHORT, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
/*     */   }
/*     */ 
/*     */   private final class IQName
/*     */   {
/*     */     public String namespace;
/*     */     public String localPart;
/*     */     public String prefix;
/*     */     public int hash;
/*     */ 
/*     */     public IQName(QName name)
/*     */     {
/* 702 */       this.namespace = (name.getNamespaceURI() != null ? name.getNamespaceURI().intern() : "".intern());
/* 703 */       this.localPart = (name.getLocalPart() != null ? name.getLocalPart().intern() : "".intern());
/* 704 */       this.prefix = (name.getPrefix() != null ? name.getPrefix().intern() : "".intern());
/* 705 */       this.hash = name.hashCode();
/*     */     }
/*     */ 
/*     */     public boolean equals(Object object) {
/* 709 */       if (!(object instanceof IQName)) {
/* 710 */         throw new IllegalArgumentException("Cannot compare IQName to " + object);
/*     */       }
/* 712 */       IQName iqn = (IQName)object;
/* 713 */       return (iqn.namespace == this.namespace) && (iqn.localPart == this.localPart);
/*     */     }
/*     */ 
/*     */     public QName toQName()
/*     */     {
/*     */       QName qname;
/*     */       QName qname;
/* 720 */       if (null == this.namespace) {
/* 721 */         qname = new QName(this.localPart);
/*     */       }
/*     */       else
/*     */       {
/*     */         QName qname;
/* 722 */         if (null == this.prefix)
/* 723 */           qname = new QName(this.namespace, this.localPart);
/*     */         else
/* 725 */           qname = new QName(this.namespace, this.localPart, this.prefix);
/*     */       }
/* 727 */       return qname;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 735 */       String ns = "{" + this.namespace + "}";
/* 736 */       return ns + this.localPart;
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 741 */       return this.hash;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class FactoryPair
/*     */   {
/*     */     private SerializerFactory serializerFactory;
/*     */     private DeserializerFactory deserializerFactory;
/*     */ 
/*     */     FactoryPair(SerializerFactory sf, DeserializerFactory df)
/*     */     {
/* 658 */       this.deserializerFactory = df;
/* 659 */       this.serializerFactory = sf;
/*     */     }
/*     */ 
/*     */     public DeserializerFactory getDeserializerFactory()
/*     */     {
/* 664 */       return this.deserializerFactory;
/*     */     }
/*     */ 
/*     */     public SerializerFactory getSerializerFactory()
/*     */     {
/* 669 */       return this.serializerFactory;
/*     */     }
/*     */ 
/*     */     public void setDeserializerFactory(DeserializerFactory df)
/*     */     {
/* 674 */       this.deserializerFactory = df;
/*     */     }
/*     */ 
/*     */     public void setSerializerFactory(SerializerFactory sf)
/*     */     {
/* 679 */       this.serializerFactory = sf;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class KeyPair
/*     */   {
/*     */     private TypeMappingImpl.IQName xmlType;
/*     */     private Class javaType;
/*     */ 
/*     */     public KeyPair(TypeMappingImpl.IQName xmlType, Class javaType)
/*     */     {
/* 608 */       this.javaType = javaType;
/* 609 */       this.xmlType = xmlType;
/*     */     }
/*     */ 
/*     */     public Class getJavaType()
/*     */     {
/* 614 */       return this.javaType;
/*     */     }
/*     */ 
/*     */     public TypeMappingImpl.IQName getXmlType()
/*     */     {
/* 619 */       return this.xmlType;
/*     */     }
/*     */ 
/*     */     public boolean equals(Object o)
/*     */     {
/* 624 */       if (this == o) return true;
/* 625 */       if (!(o instanceof KeyPair)) return false;
/*     */ 
/* 627 */       KeyPair keyPair = (KeyPair)o;
/*     */ 
/* 629 */       if (!this.javaType.equals(keyPair.javaType)) return false;
/* 630 */       return this.xmlType.equals(keyPair.xmlType);
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 638 */       int result = this.xmlType.hashCode();
/* 639 */       result = 29 * result + this.javaType.hashCode();
/* 640 */       return result;
/*     */     }
/*     */ 
/*     */     public String toString()
/*     */     {
/* 645 */       return "[xmlType=" + this.xmlType + ",javaType=" + this.javaType.getName() + "]";
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.binding.TypeMappingImpl
 * JD-Core Version:    0.6.0
 */