/*     */ package org.jboss.ws.core.binding;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.encoding.Deserializer;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.Transformer;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.TransformerFactory;
/*     */ import javax.xml.transform.dom.DOMSource;
/*     */ import javax.xml.transform.stream.StreamResult;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ import org.jboss.ws.core.utils.XMLPredefinedEntityReferenceResolver;
/*     */ import org.jboss.wsf.common.DOMWriter;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public abstract class DeserializerSupport
/*     */   implements Deserializer
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(DeserializerSupport.class);
/*     */ 
/*     */   public Object deserialize(SOAPContentElement soapElement, SerializationContext serContext) throws BindingException
/*     */   {
/*  55 */     QName xmlName = soapElement.getElementQName();
/*  56 */     QName xmlType = soapElement.getXmlType();
/*     */ 
/*  58 */     Source source = soapElement.getXMLFragment().getSource();
/*  59 */     return deserialize(xmlName, xmlType, source, serContext);
/*     */   }
/*     */ 
/*     */   public abstract Object deserialize(QName paramQName1, QName paramQName2, Source paramSource, SerializationContext paramSerializationContext)
/*     */     throws BindingException;
/*     */ 
/*     */   protected static String sourceToString(Source source)
/*     */   {
/*  75 */     String xmlFragment = null;
/*     */     try
/*     */     {
/*  78 */       if ((source instanceof DOMSource))
/*     */       {
/*  80 */         Node node = ((DOMSource)source).getNode();
/*  81 */         xmlFragment = DOMWriter.printNode(node, false);
/*     */       }
/*     */       else
/*     */       {
/*  96 */         TransformerFactory tf = TransformerFactory.newInstance();
/*  97 */         ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
/*  98 */         StreamResult streamResult = new StreamResult(baos);
/*  99 */         tf.newTransformer().transform(source, streamResult);
/* 100 */         xmlFragment = new String(baos.toByteArray());
/* 101 */         if (xmlFragment.startsWith("<?xml"))
/*     */         {
/* 103 */           int index = xmlFragment.indexOf(">");
/* 104 */           xmlFragment = xmlFragment.substring(index + 1);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (TransformerException e)
/*     */     {
/* 110 */       WSException.rethrow(e);
/*     */     }
/*     */ 
/* 113 */     return xmlFragment;
/*     */   }
/*     */ 
/*     */   protected String unwrapValueStr(String xmlFragment)
/*     */   {
/* 123 */     if (isEmptyElement(xmlFragment))
/*     */     {
/* 125 */       return isNil(xmlFragment) ? null : "";
/*     */     }
/*     */ 
/* 128 */     int endOfStartTag = xmlFragment.indexOf(">");
/* 129 */     int startOfEndTag = xmlFragment.lastIndexOf("</");
/* 130 */     if ((endOfStartTag < 0) || (startOfEndTag < 0)) {
/* 131 */       throw new IllegalArgumentException("Invalid XML fragment: " + xmlFragment);
/*     */     }
/* 133 */     String valueStr = xmlFragment.substring(endOfStartTag + 1, startOfEndTag);
/*     */ 
/* 135 */     return XMLPredefinedEntityReferenceResolver.resolve(valueStr);
/*     */   }
/*     */ 
/*     */   protected boolean isEmptyElement(String xmlFragment)
/*     */   {
/* 140 */     return (xmlFragment.startsWith("<")) && (xmlFragment.endsWith("/>"));
/*     */   }
/*     */ 
/*     */   protected boolean isNil(String xmlFragment)
/*     */   {
/* 145 */     boolean isNil = false;
/* 146 */     if (isEmptyElement(xmlFragment))
/*     */     {
/* 148 */       int endOfStartTag = xmlFragment.indexOf(">");
/* 149 */       String startTag = xmlFragment.substring(0, endOfStartTag);
/* 150 */       isNil = (startTag.indexOf(":nil='1'") > 0) || (startTag.indexOf(":nil=\"1\"") > 0);
/* 151 */       isNil = (isNil) || (startTag.indexOf(":nil='true'") > 0) || (startTag.indexOf(":nil=\"true\"") > 0);
/*     */     }
/* 153 */     return isNil;
/*     */   }
/*     */ 
/*     */   public String getMechanismType()
/*     */   {
/* 158 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.binding.DeserializerSupport
 * JD-Core Version:    0.6.0
 */