/*    */ package org.jboss.ws.core;
/*    */ 
/*    */ import javax.xml.soap.SOAPEnvelope;
/*    */ import javax.xml.soap.SOAPException;
/*    */ import javax.xml.soap.SOAPMessage;
/*    */ import javax.xml.soap.SOAPPart;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.ws.core.soap.SOAPElementImpl;
/*    */ import org.jboss.ws.core.soap.SOAPElementWriter;
/*    */ import org.jboss.ws.core.soap.XMLFragment;
/*    */ import org.jboss.wsf.common.DOMWriter;
/*    */ import org.w3c.dom.Element;
/*    */ 
/*    */ public final class MessageTrace
/*    */ {
/* 44 */   private static Logger msgLog = Logger.getLogger(MessageTrace.class);
/*    */ 
/*    */   public static void traceMessage(String messagePrefix, MessageAbstraction message)
/*    */   {
/* 53 */     if (msgLog.isTraceEnabled())
/*    */     {
/* 55 */       if ((message instanceof SOAPMessage))
/*    */       {
/*    */         try
/*    */         {
/* 59 */           SOAPEnvelope soapEnv = ((SOAPMessage)message).getSOAPPart().getEnvelope();
/* 60 */           if (soapEnv != null)
/*    */           {
/* 62 */             String envStr = SOAPElementWriter.writeElement((SOAPElementImpl)soapEnv, true);
/* 63 */             msgLog.trace(messagePrefix + "\n" + envStr);
/*    */           }
/*    */         }
/*    */         catch (SOAPException ex)
/*    */         {
/* 68 */           msgLog.error("Cannot trace SOAPMessage", ex);
/*    */         }
/*    */       }
/* 71 */       else if ((message instanceof HTTPMessageImpl))
/*    */       {
/* 73 */         HTTPMessageImpl httpMessage = (HTTPMessageImpl)message;
/* 74 */         Element root = httpMessage.getXmlFragment().toElement();
/* 75 */         String xmlString = DOMWriter.printNode(root, true);
/* 76 */         msgLog.trace(messagePrefix + "\n" + xmlString);
/*    */       }
/*    */       else
/*    */       {
/* 80 */         msgLog.warn("Unsupported message type: " + message);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.MessageTrace
 * JD-Core Version:    0.6.0
 */