/*     */ package org.jboss.ws.core;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.transform.Result;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ import org.jboss.util.NotImplementedException;
/*     */ import org.jboss.ws.core.soap.XMLFragment;
/*     */ 
/*     */ public class HTTPMessageImpl
/*     */   implements HTTPMessageAbstraction
/*     */ {
/*     */   private MimeHeaders mimeHeaders;
/*     */   private XMLFragment xmlFragment;
/*     */ 
/*     */   public HTTPMessageImpl(MimeHeaders mimeHeaders, InputStream inputStream)
/*     */   {
/*  51 */     this.mimeHeaders = mimeHeaders;
/*  52 */     this.xmlFragment = new XMLFragment(new StreamSource(inputStream));
/*     */   }
/*     */ 
/*     */   public HTTPMessageImpl(Source source)
/*     */   {
/*  57 */     this.mimeHeaders = new MimeHeaders();
/*  58 */     this.xmlFragment = new XMLFragment(source);
/*     */ 
/*  60 */     initDefaultMimeHeaders();
/*     */   }
/*     */ 
/*     */   public HTTPMessageImpl(Result result)
/*     */   {
/*  65 */     this.mimeHeaders = new MimeHeaders();
/*  66 */     this.xmlFragment = new XMLFragment(result);
/*     */ 
/*  68 */     initDefaultMimeHeaders();
/*     */   }
/*     */ 
/*     */   public boolean doValidate()
/*     */   {
/*  74 */     this.xmlFragment.toElement();
/*  75 */     return true;
/*     */   }
/*     */ 
/*     */   private void initDefaultMimeHeaders()
/*     */   {
/*  80 */     this.mimeHeaders.setHeader("Content-Type", "text/xml; charset=UTF-8");
/*     */   }
/*     */ 
/*     */   public XMLFragment getXmlFragment()
/*     */   {
/*  85 */     return this.xmlFragment;
/*     */   }
/*     */ 
/*     */   public void setXmlFragment(XMLFragment xmlFragment)
/*     */   {
/*  90 */     this.xmlFragment = xmlFragment;
/*     */   }
/*     */ 
/*     */   public MimeHeaders getMimeHeaders()
/*     */   {
/*  95 */     if (this.mimeHeaders == null) {
/*  96 */       this.mimeHeaders = new MimeHeaders();
/*     */     }
/*  98 */     return this.mimeHeaders;
/*     */   }
/*     */ 
/*     */   public void setMimeHeaders(MimeHeaders mimeHeaders)
/*     */   {
/* 103 */     this.mimeHeaders = mimeHeaders;
/*     */   }
/*     */ 
/*     */   public void writeTo(OutputStream outputStream) throws IOException
/*     */   {
/* 108 */     this.xmlFragment.writeTo(outputStream);
/*     */   }
/*     */ 
/*     */   public boolean isFaultMessage()
/*     */   {
/* 113 */     return false;
/*     */   }
/*     */ 
/*     */   public void addAttachmentPart(AttachmentPart part)
/*     */   {
/* 118 */     throw new NotImplementedException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.HTTPMessageImpl
 * JD-Core Version:    0.6.0
 */