/*     */ package org.jboss.ws.core;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.Name;
/*     */ import javax.xml.soap.Node;
/*     */ import javax.xml.soap.SOAPBody;
/*     */ import javax.xml.soap.SOAPBodyElement;
/*     */ import javax.xml.soap.SOAPElement;
/*     */ import javax.xml.soap.SOAPEnvelope;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPFactory;
/*     */ import javax.xml.soap.SOAPHeader;
/*     */ import javax.xml.soap.SOAPHeaderElement;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.soap.SOAPPart;
/*     */ import org.apache.xerces.xs.XSElementDeclaration;
/*     */ import org.apache.xerces.xs.XSTypeDefinition;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.binding.BindingException;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping;
/*     */ import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.MessageFactoryImpl;
/*     */ import org.jboss.ws.core.soap.NameImpl;
/*     */ import org.jboss.ws.core.soap.SOAPBodyElementDoc;
/*     */ import org.jboss.ws.core.soap.SOAPBodyElementRpc;
/*     */ import org.jboss.ws.core.soap.SOAPBodyImpl;
/*     */ import org.jboss.ws.core.soap.SOAPContentElement;
/*     */ import org.jboss.ws.core.soap.SOAPElementImpl;
/*     */ import org.jboss.ws.core.soap.SOAPFactoryImpl;
/*     */ import org.jboss.ws.core.soap.SOAPFaultImpl;
/*     */ import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
/*     */ import org.jboss.ws.core.soap.SOAPMessageImpl;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.soap.UnboundHeader;
/*     */ import org.jboss.ws.core.soap.Use;
/*     */ import org.jboss.ws.core.soap.attachment.AttachmentPartImpl;
/*     */ import org.jboss.ws.core.soap.attachment.CIDGenerator;
/*     */ import org.jboss.ws.core.utils.MimeUtils;
/*     */ import org.jboss.ws.extensions.xop.XOPContext;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.TypesMetaData;
/*     */ import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
/*     */ import org.jboss.wsf.common.DOMUtils;
/*     */ import org.jboss.wsf.common.JavaUtils;
/*     */ import org.jboss.xb.binding.NamespaceRegistry;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public abstract class CommonSOAPBinding
/*     */   implements CommonBinding
/*     */ {
/*  93 */   protected Logger log = Logger.getLogger(getClass());
/*     */   private boolean mtomEnabled;
/*     */   protected HeaderSource headerSource;
/*     */   public static final String SOAP11HTTP_BINDING = "http://schemas.xmlsoap.org/wsdl/soap/http";
/*     */   public static final String SOAP12HTTP_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
/*     */   public static final String SOAP11HTTP_MTOM_BINDING = "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true";
/*     */   public static final String SOAP12HTTP_MTOM_BINDING = "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true";
/* 108 */   private static final Name SOAP_ARRAY_NAME = new NameImpl("Array", "soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
/*     */ 
/*     */   public MessageFactory getMessageFactory()
/*     */   {
/* 116 */     return new MessageFactoryImpl();
/*     */   }
/*     */ 
/*     */   public SOAPFactory getSOAPFactory()
/*     */   {
/* 121 */     return new SOAPFactoryImpl();
/*     */   }
/*     */ 
/*     */   public boolean isMTOMEnabled()
/*     */   {
/* 126 */     return this.mtomEnabled;
/*     */   }
/*     */ 
/*     */   public void setMTOMEnabled(boolean flag)
/*     */   {
/* 131 */     this.mtomEnabled = flag;
/*     */   }
/*     */ 
/*     */   protected abstract MessageAbstraction createMessage(OperationMetaData paramOperationMetaData)
/*     */     throws SOAPException;
/*     */ 
/*     */   public MessageAbstraction bindRequestMessage(OperationMetaData opMetaData, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/* 141 */     if (this.log.isDebugEnabled()) {
/* 142 */       this.log.debug("bindRequestMessage: " + opMetaData.getQName());
/*     */     }
/*     */     try
/*     */     {
/* 146 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 147 */       if (msgContext == null) {
/* 148 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 151 */       if (opMetaData.isRPCEncoded())
/* 152 */         XOPContext.setMTOMEnabled(false);
/* 153 */       else XOPContext.setMTOMEnabled(isMTOMEnabled());
/*     */ 
/* 156 */       SOAPMessageImpl reqMessage = (SOAPMessageImpl)createMessage(opMetaData);
/* 157 */       msgContext.setSOAPMessage(reqMessage);
/*     */ 
/* 159 */       SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
/* 160 */       SOAPBody soapBody = soapEnvelope.getBody();
/* 161 */       SOAPHeader soapHeader = soapEnvelope.getHeader();
/*     */ 
/* 164 */       NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
/*     */ 
/* 166 */       Style style = opMetaData.getStyle();
/* 167 */       SOAPElement soapBodyElement = soapBody;
/* 168 */       if (style == Style.RPC)
/*     */       {
/* 170 */         QName opQName = opMetaData.getQName();
/* 171 */         Name opName = new NameImpl(namespaceRegistry.registerQName(opQName));
/*     */ 
/* 173 */         if (this.log.isDebugEnabled()) {
/* 174 */           this.log.debug("Create RPC body element: " + opName);
/*     */         }
/* 176 */         soapBodyElement = new SOAPBodyElementRpc(opName);
/* 177 */         soapBodyElement = (SOAPBodyElement)soapBody.addChildElement(soapBodyElement);
/*     */ 
/* 180 */         if (opMetaData.getUse() == Use.ENCODED)
/*     */         {
/* 182 */           String envURI = soapEnvelope.getNamespaceURI();
/* 183 */           String envPrefix = soapEnvelope.getPrefix();
/* 184 */           soapBodyElement.setAttributeNS(envURI, envPrefix + ":encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
/*     */         }
/*     */       }
/*     */ 
/* 188 */       for (ParameterMetaData paramMetaData : opMetaData.getInputParameters())
/*     */       {
/* 190 */         QName xmlName = paramMetaData.getXmlName();
/* 191 */         Object value = epInv.getRequestParamValue(xmlName);
/*     */ 
/* 193 */         if (paramMetaData.isSwA())
/*     */         {
/* 196 */           CIDGenerator cidGenerator = reqMessage.getCidGenerator();
/* 197 */           AttachmentPart part = createAttachmentPart(paramMetaData, value, cidGenerator);
/* 198 */           reqMessage.addAttachmentPart(part);
/*     */ 
/* 201 */           if (((value instanceof DataHandler)) && ((msgContext instanceof MessageContextJAXWS)))
/*     */           {
/* 203 */             DataHandler dataHandler = (DataHandler)value;
/* 204 */             Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.outbound");
/* 205 */             attachments.put(dataHandler.getContentType(), dataHandler);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 210 */           SOAPElement soapElement = paramMetaData.isInHeader() ? soapHeader : soapBodyElement;
/* 211 */           addParameterToMessage(paramMetaData, value, soapElement);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 216 */       if (unboundHeaders != null)
/*     */       {
/* 218 */         Iterator it = unboundHeaders.values().iterator();
/* 219 */         while (it.hasNext())
/*     */         {
/* 221 */           UnboundHeader unboundHeader = (UnboundHeader)it.next();
/* 222 */           if (unboundHeader.getMode() != ParameterMode.OUT)
/*     */           {
/* 224 */             QName xmlName = unboundHeader.getXmlName();
/* 225 */             Object value = unboundHeader.getHeaderValue();
/*     */ 
/* 227 */             xmlName = namespaceRegistry.registerQName(xmlName);
/* 228 */             Name soapName = new NameImpl(xmlName.getLocalPart(), xmlName.getPrefix(), xmlName.getNamespaceURI());
/*     */ 
/* 230 */             this.log.debug("Add unboundHeader element: " + soapName);
/* 231 */             SOAPContentElement contentElement = new SOAPHeaderElementImpl(soapName);
/* 232 */             contentElement.setParamMetaData(unboundHeader.toParameterMetaData(opMetaData));
/*     */ 
/* 234 */             if (soapHeader == null) {
/* 235 */               soapHeader = soapEnvelope.addHeader();
/*     */             }
/* 237 */             soapHeader.addChildElement(contentElement);
/* 238 */             contentElement.setObjectValue(value);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 244 */       setSOAPActionHeader(opMetaData, reqMessage);
/*     */ 
/* 246 */       return reqMessage;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 250 */       handleException(e);
/* 251 */     }return null;
/*     */   }
/*     */ 
/*     */   public abstract void setSOAPActionHeader(OperationMetaData paramOperationMetaData, SOAPMessage paramSOAPMessage);
/*     */ 
/*     */   public EndpointInvocation unbindRequestMessage(OperationMetaData opMetaData, MessageAbstraction payload)
/*     */     throws BindingException
/*     */   {
/* 261 */     if (this.log.isDebugEnabled()) {
/* 262 */       this.log.debug("unbindRequestMessage: " + opMetaData.getQName());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 267 */       SOAPMessageImpl reqMessage = (SOAPMessageImpl)payload;
/* 268 */       SOAPEnvelope soapEnvelope = reqMessage.getSOAPPart().getEnvelope();
/* 269 */       SOAPHeader soapHeader = soapEnvelope.getHeader();
/* 270 */       SOAPBody soapBody = soapEnvelope.getBody();
/*     */ 
/* 273 */       verifySOAPVersion(opMetaData, soapEnvelope);
/*     */ 
/* 276 */       EndpointInvocation epInv = new EndpointInvocation(opMetaData);
/*     */ 
/* 278 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 279 */       if (msgContext == null) {
/* 280 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 283 */       if (opMetaData.isRPCEncoded()) {
/* 284 */         msgContext.put("org.jboss.ws.mtom.enabled", Boolean.FALSE);
/*     */       }
/*     */ 
/* 287 */       NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
/*     */ 
/* 289 */       if (!opMetaData.isMessageEndpoint())
/*     */       {
/* 291 */         Style style = opMetaData.getStyle();
/* 292 */         SOAPElement payloadParent = soapBody;
/* 293 */         if (style == Style.RPC)
/*     */         {
/* 295 */           payloadParent = null;
/* 296 */           Iterator it = soapBody.getChildElements();
/* 297 */           while ((payloadParent == null) && (it.hasNext()))
/*     */           {
/* 299 */             Object childNode = it.next();
/* 300 */             if ((childNode instanceof SOAPElement))
/*     */             {
/* 302 */               payloadParent = (SOAPElement)childNode;
/*     */             }
/*     */           }
/*     */ 
/* 306 */           if (payloadParent == null) {
/* 307 */             throw new SOAPException("Cannot find RPC element in");
/*     */           }
/* 309 */           QName elName = payloadParent.getElementQName();
/* 310 */           elName = namespaceRegistry.registerQName(elName);
/*     */         }
/*     */ 
/* 313 */         int numParameters = 0;
/* 314 */         for (ParameterMetaData paramMetaData : opMetaData.getParameters())
/*     */         {
/* 316 */           QName xmlName = paramMetaData.getXmlName();
/* 317 */           if (paramMetaData.getMode() == ParameterMode.OUT)
/*     */           {
/* 319 */             epInv.setRequestParamValue(xmlName, null);
/*     */           }
/* 323 */           else if (paramMetaData.isSwA())
/*     */           {
/* 325 */             AttachmentPart part = getAttachmentFromMessage(paramMetaData, reqMessage);
/* 326 */             epInv.setRequestParamValue(xmlName, part);
/*     */ 
/* 329 */             if ((part.getDataHandler() != null) && ((msgContext instanceof MessageContextJAXWS)))
/*     */             {
/* 331 */               DataHandler dataHandler = part.getDataHandler();
/* 332 */               Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.inbound");
/* 333 */               attachments.put(part.getContentId(), dataHandler);
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/* 338 */             boolean isHeader = paramMetaData.isInHeader();
/* 339 */             SOAPElement element = isHeader ? soapHeader : payloadParent;
/* 340 */             if (!isHeader) {
/* 341 */               numParameters++;
/*     */             }
/* 343 */             SOAPContentElement value = getParameterFromMessage(paramMetaData, element, false);
/* 344 */             epInv.setRequestParamValue(xmlName, value);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 350 */         int numChildElements = 0;
/* 351 */         Iterator itElements = payloadParent.getChildElements();
/* 352 */         while (itElements.hasNext())
/*     */         {
/* 354 */           Node node = (Node)itElements.next();
/* 355 */           if ((node instanceof SOAPElement))
/* 356 */             numChildElements++;
/*     */         }
/* 358 */         if (numChildElements != numParameters) {
/* 359 */           throw new WSException("Invalid number of payload elements: " + numChildElements);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 365 */         for (ParameterMetaData paramMetaData : opMetaData.getParameters())
/*     */         {
/* 367 */           QName xmlName = paramMetaData.getXmlName();
/* 368 */           Object value = soapBody.getChildElements().next();
/* 369 */           epInv.setRequestParamValue(xmlName, value);
/*     */         }
/*     */       }
/*     */ 
/* 373 */       return epInv;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 377 */       handleException(e);
/* 378 */     }return null;
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindResponseMessage(OperationMetaData opMetaData, EndpointInvocation epInv)
/*     */     throws BindingException
/*     */   {
/* 385 */     if (this.log.isDebugEnabled()) {
/* 386 */       this.log.debug("bindResponseMessage: " + opMetaData.getQName());
/*     */     }
/*     */     try
/*     */     {
/* 390 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 391 */       if (msgContext == null) {
/* 392 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 395 */       if (opMetaData.isRPCEncoded())
/* 396 */         XOPContext.setMTOMEnabled(false);
/* 397 */       else XOPContext.setMTOMEnabled(isMTOMEnabled());
/*     */ 
/* 400 */       SOAPMessageImpl resMessage = (SOAPMessageImpl)createMessage(opMetaData);
/* 401 */       msgContext.setSOAPMessage(resMessage);
/*     */ 
/* 405 */       if (opMetaData.isOneWay())
/*     */       {
/* 407 */         resMessage.getSOAPPart().setContent(null);
/* 408 */         return resMessage;
/*     */       }
/*     */ 
/* 411 */       SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
/* 412 */       SOAPHeader soapHeader = soapEnvelope.getHeader();
/* 413 */       SOAPBody soapBody = soapEnvelope.getBody();
/*     */ 
/* 416 */       NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
/*     */ 
/* 418 */       Style style = opMetaData.getStyle();
/* 419 */       SOAPElement soapBodyElement = soapBody;
/* 420 */       if (style == Style.RPC)
/*     */       {
/* 422 */         QName opQName = opMetaData.getResponseName();
/*     */ 
/* 424 */         Name opName = new NameImpl(namespaceRegistry.registerQName(opQName));
/* 425 */         soapBodyElement = new SOAPBodyElementRpc(opName);
/* 426 */         soapBodyElement = (SOAPBodyElement)soapBody.addChildElement(soapBodyElement);
/*     */ 
/* 429 */         if (opMetaData.getUse() == Use.ENCODED)
/*     */         {
/* 431 */           String envURI = soapEnvelope.getNamespaceURI();
/* 432 */           String envPrefix = soapEnvelope.getPrefix();
/* 433 */           soapBodyElement.setAttributeNS(envURI, envPrefix + ":encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 438 */       ParameterMetaData retMetaData = opMetaData.getReturnParameter();
/* 439 */       if (retMetaData != null)
/*     */       {
/* 441 */         Object value = epInv.getReturnValue();
/*     */ 
/* 444 */         if (opMetaData.isDocumentWrapped()) {
/* 445 */           value = ParameterWrapping.wrapResponseParameters(retMetaData, value, epInv.getOutParameters());
/*     */         }
/* 447 */         if (retMetaData.isSwA())
/*     */         {
/* 449 */           CIDGenerator cidGenerator = resMessage.getCidGenerator();
/* 450 */           AttachmentPart part = createAttachmentPart(retMetaData, value, cidGenerator);
/* 451 */           resMessage.addAttachmentPart(part);
/* 452 */           epInv.setReturnValue(part);
/*     */ 
/* 455 */           if ((part.getDataHandler() != null) && ((msgContext instanceof MessageContextJAXWS)))
/*     */           {
/* 457 */             DataHandler dataHandler = part.getDataHandler();
/* 458 */             Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.outbound");
/* 459 */             attachments.put(part.getContentId(), dataHandler);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 464 */           SOAPContentElement soapElement = addParameterToMessage(retMetaData, value, soapBodyElement);
/* 465 */           epInv.setReturnValue(soapElement);
/* 466 */           soapElement.setObjectValue(value);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 471 */       for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters())
/*     */       {
/* 473 */         QName xmlName = paramMetaData.getXmlName();
/* 474 */         Object value = epInv.getResponseParamValue(xmlName);
/* 475 */         if (paramMetaData.isSwA())
/*     */         {
/* 477 */           CIDGenerator cidGenerator = resMessage.getCidGenerator();
/* 478 */           AttachmentPart part = createAttachmentPart(paramMetaData, value, cidGenerator);
/* 479 */           resMessage.addAttachmentPart(part);
/*     */ 
/* 482 */           if (((value instanceof DataHandler)) && ((msgContext instanceof MessageContextJAXWS)))
/*     */           {
/* 484 */             DataHandler dataHandler = (DataHandler)value;
/* 485 */             Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.outbound");
/* 486 */             attachments.put(dataHandler.getContentType(), dataHandler);
/*     */           }
/*     */ 
/*     */         }
/* 491 */         else if (paramMetaData.isInHeader())
/*     */         {
/* 493 */           addParameterToMessage(paramMetaData, value, soapHeader);
/*     */         }
/*     */         else
/*     */         {
/* 497 */           addParameterToMessage(paramMetaData, value, soapBodyElement);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 502 */       return resMessage;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 506 */       handleException(e);
/* 507 */     }return null;
/*     */   }
/*     */ 
/*     */   public void unbindResponseMessage(OperationMetaData opMetaData, MessageAbstraction payload, EndpointInvocation epInv, Map<QName, UnboundHeader> unboundHeaders)
/*     */     throws BindingException
/*     */   {
/* 515 */     if (this.log.isDebugEnabled()) {
/* 516 */       this.log.debug("unbindResponseMessage: " + opMetaData.getQName());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 522 */       if (opMetaData.isOneWay() == true)
/*     */       {
/* 524 */         return;
/*     */       }
/*     */ 
/* 528 */       resMessage = (SOAPMessageImpl)payload;
/* 529 */       SOAPEnvelope soapEnvelope = resMessage.getSOAPPart().getEnvelope();
/* 530 */       if (soapEnvelope == null)
/*     */       {
/* 532 */         return;
/*     */       }
/*     */ 
/* 536 */       verifySOAPVersion(opMetaData, soapEnvelope);
/*     */ 
/* 539 */       msgContext = MessageContextAssociation.peekMessageContext();
/* 540 */       if (msgContext == null) {
/* 541 */         throw new WSException("MessageContext not available");
/*     */       }
/*     */ 
/* 544 */       if (opMetaData.isRPCEncoded()) {
/* 545 */         msgContext.put("org.jboss.ws.mtom.enabled", Boolean.FALSE);
/*     */       }
/* 547 */       soapHeader = soapEnvelope.getHeader();
/* 548 */       SOAPBodyImpl soapBody = (SOAPBodyImpl)soapEnvelope.getBody();
/* 549 */       SOAPBodyElement soapBodyElement = soapBody.getBodyElement();
/*     */ 
/* 552 */       if ((soapBodyElement instanceof SOAPFaultImpl)) {
/* 553 */         throwFaultException((SOAPFaultImpl)soapBodyElement);
/*     */       }
/*     */ 
/* 556 */       if ((unboundHeaders != null) && (soapHeader != null))
/*     */       {
/* 558 */         Map outHeaders = new HashMap();
/* 559 */         Iterator itHeaderElements = soapHeader.getChildElements();
/* 560 */         while (itHeaderElements.hasNext())
/*     */         {
/* 562 */           SOAPContentElement soapHeaderElement = (SOAPHeaderElementImpl)itHeaderElements.next();
/* 563 */           Name elName = soapHeaderElement.getElementName();
/* 564 */           QName xmlName = new QName(elName.getURI(), elName.getLocalName());
/*     */ 
/* 566 */           UnboundHeader unboundHeader = (UnboundHeader)unboundHeaders.get(xmlName);
/* 567 */           if (unboundHeader != null)
/*     */           {
/* 569 */             soapHeaderElement.setParamMetaData(unboundHeader.toParameterMetaData(opMetaData));
/*     */ 
/* 572 */             Object value = soapHeaderElement.getObjectValue();
/* 573 */             unboundHeader.setHeaderValue(value);
/* 574 */             outHeaders.put(xmlName, unboundHeader);
/*     */           }
/*     */         }
/* 577 */         unboundHeaders.clear();
/* 578 */         unboundHeaders.putAll(outHeaders);
/*     */       }
/*     */ 
/* 581 */       Style style = opMetaData.getStyle();
/* 582 */       soapElement = soapBody;
/* 583 */       if (style == Style.RPC)
/*     */       {
/* 585 */         if (soapBodyElement == null)
/* 586 */           throw new WSException("Cannot unbind response message with empty soap body");
/* 587 */         soapElement = soapBodyElement;
/*     */       }
/*     */ 
/* 590 */       ParameterMetaData retMetaData = opMetaData.getReturnParameter();
/* 591 */       if (retMetaData != null)
/*     */       {
/* 593 */         if (retMetaData.isSwA())
/*     */         {
/* 595 */           AttachmentPart part = getAttachmentFromMessage(retMetaData, resMessage);
/* 596 */           epInv.setReturnValue(part);
/*     */ 
/* 599 */           if ((part.getDataHandler() != null) && ((msgContext instanceof MessageContextJAXWS)))
/*     */           {
/* 601 */             DataHandler dataHandler = part.getDataHandler();
/* 602 */             Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.inbound");
/* 603 */             attachments.put(part.getContentId(), dataHandler);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 608 */           SOAPContentElement value = getParameterFromMessage(retMetaData, soapElement, false);
/* 609 */           epInv.setReturnValue(value);
/*     */         }
/*     */       }
/*     */ 
/* 613 */       for (ParameterMetaData paramMetaData : opMetaData.getOutputParameters())
/*     */       {
/* 615 */         QName xmlName = paramMetaData.getXmlName();
/* 616 */         if (paramMetaData.isSwA())
/*     */         {
/* 618 */           AttachmentPart part = getAttachmentFromMessage(paramMetaData, resMessage);
/* 619 */           epInv.setResponseParamValue(xmlName, part);
/*     */ 
/* 622 */           if ((part.getDataHandler() != null) && ((msgContext instanceof MessageContextJAXWS)))
/*     */           {
/* 624 */             DataHandler dataHandler = part.getDataHandler();
/* 625 */             Map attachments = (Map)msgContext.get("javax.xml.ws.binding.attachments.inbound");
/* 626 */             attachments.put(part.getContentId(), dataHandler);
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/* 631 */           SOAPElement element = paramMetaData.isInHeader() ? soapHeader : soapElement;
/* 632 */           SOAPContentElement value = getParameterFromMessage(paramMetaData, element, false);
/* 633 */           epInv.setResponseParamValue(xmlName, value);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       SOAPMessageImpl resMessage;
/*     */       CommonMessageContext msgContext;
/*     */       SOAPHeader soapHeader;
/*     */       SOAPElement soapElement;
/* 639 */       handleException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public MessageAbstraction bindFaultMessage(Exception ex)
/*     */   {
/* 645 */     SOAPMessageImpl faultMessage = (SOAPMessageImpl)createFaultMessageFromException(ex);
/* 646 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 647 */     if (msgContext != null)
/*     */     {
/* 649 */       msgContext.setSOAPMessage(faultMessage);
/*     */     }
/*     */     else
/*     */     {
/* 653 */       this.log.warn("Cannot set fault message in message context");
/*     */     }
/* 655 */     return faultMessage;
/*     */   }
/*     */ 
/*     */   protected abstract SOAPMessage createFaultMessageFromException(Exception paramException);
/*     */ 
/*     */   private void verifySOAPVersion(OperationMetaData opMetaData, SOAPEnvelope soapEnvelope) {
/* 662 */     String envNS = soapEnvelope.getNamespaceURI();
/* 663 */     String bindingId = opMetaData.getEndpointMetaData().getBindingId();
/* 664 */     if (("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingId)) && (!"http://schemas.xmlsoap.org/soap/envelope/".equals(envNS))) {
/* 665 */       this.log.warn("Expected SOAP-1.1 envelope, but got: " + envNS);
/*     */     }
/* 667 */     if (("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingId)) && (!"http://www.w3.org/2003/05/soap-envelope".equals(envNS)))
/* 668 */       this.log.warn("Expected SOAP-1.2 envelope, but got: " + envNS);
/*     */   }
/*     */ 
/*     */   private AttachmentPart createAttachmentPart(ParameterMetaData paramMetaData, Object value, CIDGenerator cidGenerator) throws SOAPException, BindingException
/*     */   {
/* 673 */     String partName = paramMetaData.getXmlName().getLocalPart();
/* 674 */     Set mimeTypes = paramMetaData.getMimeTypes();
/*     */ 
/* 676 */     AttachmentPart part = new AttachmentPartImpl();
/* 677 */     if ((value instanceof DataHandler))
/*     */     {
/* 679 */       DataHandler handler = (DataHandler)value;
/* 680 */       String mimeType = MimeUtils.getBaseMimeType(handler.getContentType());
/*     */ 
/* 685 */       if ((mimeTypes != null) && (!MimeUtils.isMemberOf(mimeType, mimeTypes))) {
/* 686 */         this.log.warn("Mime type " + mimeType + " not allowed for parameter " + partName + " allowed types are " + mimeTypes);
/*     */       }
/* 688 */       part.setDataHandler((DataHandler)value);
/*     */     }
/*     */     else
/*     */     {
/* 692 */       String mimeType = null;
/* 693 */       if ((mimeTypes != null) && (mimeTypes.size() > 0))
/*     */       {
/* 695 */         mimeType = (String)mimeTypes.iterator().next();
/*     */       }
/*     */       else
/*     */       {
/* 699 */         mimeType = MimeUtils.resolveMimeType(value);
/*     */       }
/*     */ 
/* 702 */       if (mimeType == null) {
/* 703 */         throw new BindingException("Could not determine mime type for attachment parameter: " + partName);
/*     */       }
/* 705 */       part.setContent(value, mimeType);
/*     */     }
/*     */ 
/* 708 */     if (paramMetaData.isSwA())
/*     */     {
/* 710 */       String swaCID = '<' + partName + "=" + cidGenerator.generateFromCount() + '>';
/* 711 */       part.setContentId(swaCID);
/*     */     }
/* 713 */     if (paramMetaData.isXOP())
/*     */     {
/* 715 */       String xopCID = '<' + cidGenerator.generateFromName(partName) + '>';
/* 716 */       part.setContentId(xopCID);
/*     */     }
/*     */ 
/* 719 */     return part;
/*     */   }
/*     */ 
/*     */   private AttachmentPart getAttachmentFromMessage(ParameterMetaData paramMetaData, SOAPMessage message) throws SOAPException, BindingException
/*     */   {
/* 724 */     QName xmlName = paramMetaData.getXmlName();
/*     */ 
/* 726 */     AttachmentPart part = ((SOAPMessageImpl)message).getAttachmentByPartName(xmlName.getLocalPart());
/* 727 */     if (part == null) {
/* 728 */       throw new BindingException("Could not locate attachment for parameter: " + paramMetaData.getXmlName());
/*     */     }
/* 730 */     return part;
/*     */   }
/*     */ 
/*     */   private SOAPContentElement addParameterToMessage(ParameterMetaData paramMetaData, Object value, SOAPElement soapElement)
/*     */     throws SOAPException, BindingException
/*     */   {
/* 736 */     QName xmlName = paramMetaData.getXmlName();
/* 737 */     Class javaType = paramMetaData.getJavaType();
/*     */ 
/* 739 */     if ((value != null) && (!paramMetaData.isXOP()))
/*     */     {
/* 741 */       Class valueType = value.getClass();
/* 742 */       if (!JavaUtils.isAssignableFrom(javaType, valueType)) {
/* 743 */         throw new BindingException("javaType " + javaType.getName() + " is not assignable from: " + valueType.getName());
/*     */       }
/*     */     }
/*     */ 
/* 747 */     if (xmlName.getNamespaceURI().length() > 0)
/*     */     {
/* 749 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 750 */       NamespaceRegistry namespaceRegistry = msgContext.getNamespaceRegistry();
/* 751 */       xmlName = namespaceRegistry.registerQName(xmlName);
/*     */     }
/*     */ 
/* 754 */     Name soapName = new NameImpl(xmlName.getLocalPart(), xmlName.getPrefix(), xmlName.getNamespaceURI());
/*     */     SOAPContentElement contentElement;
/* 757 */     if ((soapElement instanceof SOAPHeader))
/*     */     {
/* 759 */       SOAPContentElement contentElement = new SOAPHeaderElementImpl(soapName);
/* 760 */       soapElement.addChildElement(contentElement);
/*     */     }
/*     */     else
/*     */     {
/* 764 */       Style style = paramMetaData.getOperationMetaData().getStyle();
/* 765 */       if (style == Style.DOCUMENT)
/*     */       {
/* 767 */         SOAPContentElement contentElement = new SOAPBodyElementDoc(soapName);
/* 768 */         soapElement.addChildElement(contentElement);
/*     */       }
/*     */       else
/*     */       {
/* 772 */         contentElement = new SOAPContentElement(soapName);
/* 773 */         soapElement.addChildElement(contentElement);
/*     */       }
/*     */     }
/*     */ 
/* 777 */     contentElement.setParamMetaData(paramMetaData);
/*     */ 
/* 779 */     if (paramMetaData.isSOAPArrayParam())
/*     */     {
/* 781 */       this.log.trace("Add parameter as SOAP encoded Array");
/* 782 */       contentElement.addNamespaceDeclaration("soap11-enc", "http://schemas.xmlsoap.org/soap/encoding/");
/*     */     }
/*     */ 
/* 787 */     if ((paramMetaData.isXOP()) && (XOPContext.isMTOMEnabled()))
/*     */     {
/* 789 */       this.log.trace("Add parameter as XOP");
/* 790 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 791 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/* 792 */       soapMessage.setXOPMessage(true);
/*     */     }
/* 794 */     else if (paramMetaData.isSwaRef())
/*     */     {
/* 796 */       CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 797 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/* 798 */       soapMessage.setSWARefMessage(true);
/*     */     }
/*     */ 
/* 801 */     contentElement.setObjectValue(value);
/*     */ 
/* 803 */     return contentElement;
/*     */   }
/*     */ 
/*     */   private SOAPContentElement getParameterFromMessage(ParameterMetaData paramMetaData, SOAPElement soapElement, boolean optional)
/*     */     throws BindingException
/*     */   {
/* 809 */     Name xmlName = new NameImpl(paramMetaData.getXmlName());
/*     */ 
/* 811 */     SOAPContentElement soapContentElement = null;
/* 812 */     Iterator childElements = soapElement.getChildElements();
/* 813 */     while (childElements.hasNext())
/*     */     {
/* 815 */       Object childNode = childElements.next();
/* 816 */       if ((childNode instanceof SOAPElement))
/*     */       {
/* 818 */         SOAPElementImpl childElement = (SOAPElementImpl)childNode;
/*     */ 
/* 820 */         if (!(childElement instanceof SOAPContentElement)) {
/* 821 */           childElement = (SOAPContentElement)soapElement.replaceChild(new SOAPContentElement(childElement), childElement);
/*     */         }
/*     */ 
/* 824 */         SOAPContentElement aux = (SOAPContentElement)childElement;
/* 825 */         Name elName = aux.getElementName();
/*     */ 
/* 827 */         if (xmlName.equals(elName))
/*     */         {
/* 829 */           soapContentElement = aux;
/* 830 */           soapContentElement.setParamMetaData(paramMetaData);
/* 831 */           break;
/*     */         }
/*     */ 
/* 834 */         if (SOAP_ARRAY_NAME.equals(elName))
/*     */         {
/* 836 */           CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 837 */           msgContext.put(CommonMessageContext.ALLOW_EXPAND_TO_DOM, Boolean.TRUE);
/*     */           try
/*     */           {
/* 840 */             QName compXMLName = paramMetaData.getXmlName();
/* 841 */             Element compElement = DOMUtils.getFirstChildElement(aux);
/*     */ 
/* 844 */             if ((compElement == null) || (compElement.getNodeName().equals(compXMLName.getLocalPart())))
/*     */             {
/* 846 */               soapContentElement = aux;
/* 847 */               soapContentElement.setParamMetaData(paramMetaData);
/*     */ 
/* 853 */               msgContext.remove(CommonMessageContext.ALLOW_EXPAND_TO_DOM); break;
/*     */             } } finally { msgContext.remove(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 861 */     if (soapContentElement == null)
/*     */     {
/* 863 */       childElements = soapElement.getChildElements();
/* 864 */       OperationMetaData opMetaData = paramMetaData.getOperationMetaData();
/* 865 */       TypesMetaData typesMetaData = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
/* 866 */       if ((childElements.hasNext()) && (opMetaData.getStyle() == Style.DOCUMENT))
/*     */       {
/* 868 */         SOAPElementImpl childElement = (SOAPElementImpl)childElements.next();
/*     */ 
/* 871 */         SOAPContentElement aux = (SOAPContentElement)childElement;
/* 872 */         Name elName = aux.getElementName();
/* 873 */         QName elType = null;
/*     */ 
/* 875 */         XSElementDeclaration xsdElement = typesMetaData.getSchemaModel().getElementDeclaration(elName.getLocalName(), elName.getURI());
/* 876 */         if ((xsdElement != null) && (xsdElement.getTypeDefinition() != null))
/*     */         {
/* 878 */           XSTypeDefinition xsdType = xsdElement.getTypeDefinition();
/* 879 */           elType = new QName(xsdType.getNamespace(), xsdType.getName());
/*     */         }
/*     */ 
/* 882 */         if (paramMetaData.getXmlType().equals(elType))
/*     */         {
/* 884 */           soapContentElement = aux;
/* 885 */           soapContentElement.setParamMetaData(paramMetaData);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 890 */     if ((soapContentElement == null) && (!optional)) {
/* 891 */       throw new WSException("Cannot find child element: " + xmlName);
/*     */     }
/*     */ 
/* 896 */     if ((paramMetaData.isXOP()) && (XOPContext.isXOPEncodedRequest()))
/*     */     {
/* 898 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)MessageContextAssociation.peekMessageContext().getSOAPMessage();
/* 899 */       soapMessage.setXOPMessage(true);
/*     */     }
/* 901 */     else if (paramMetaData.isSwaRef())
/*     */     {
/* 903 */       SOAPMessageImpl soapMessage = (SOAPMessageImpl)MessageContextAssociation.peekMessageContext().getSOAPMessage();
/* 904 */       soapMessage.setSWARefMessage(true);
/*     */     }
/*     */ 
/* 907 */     return soapContentElement;
/*     */   }
/*     */   protected abstract void throwFaultException(SOAPFaultImpl paramSOAPFaultImpl) throws Exception;
/*     */ 
/*     */   protected abstract void verifyUnderstoodHeader(SOAPHeaderElement paramSOAPHeaderElement) throws Exception;
/*     */ 
/*     */   public void checkMustUnderstand(OperationMetaData opMetaData) throws Exception {
/* 916 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 917 */     if (msgContext == null) {
/* 918 */       throw new WSException("MessageContext not available");
/*     */     }
/* 920 */     SOAPMessageImpl soapMessage = (SOAPMessageImpl)msgContext.getSOAPMessage();
/* 921 */     SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
/* 922 */     if ((soapEnvelope == null) || (soapEnvelope.getHeader() == null)) {
/* 923 */       return;
/*     */     }
/* 925 */     Iterator it = soapEnvelope.getHeader().examineAllHeaderElements();
/* 926 */     while (it.hasNext())
/*     */     {
/* 928 */       SOAPHeaderElement soapHeaderElement = (SOAPHeaderElement)it.next();
/* 929 */       Name name = soapHeaderElement.getElementName();
/* 930 */       QName xmlName = new QName(name.getURI(), name.getLocalName());
/*     */ 
/* 932 */       ParameterMetaData paramMetaData = opMetaData != null ? opMetaData.getParameter(xmlName) : null;
/* 933 */       boolean isBoundHeader = (paramMetaData != null) && (paramMetaData.isInHeader());
/*     */ 
/* 935 */       if ((!isBoundHeader) && (soapHeaderElement.getMustUnderstand()))
/* 936 */         verifyUnderstoodHeader(soapHeaderElement);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setHeaderSource(HeaderSource source)
/*     */   {
/* 942 */     this.headerSource = source;
/*     */   }
/*     */ 
/*     */   private void handleException(Exception ex) throws BindingException
/*     */   {
/* 947 */     if ((ex instanceof RuntimeException)) {
/* 948 */       throw ((RuntimeException)ex);
/*     */     }
/* 950 */     if ((ex instanceof BindingException)) {
/* 951 */       throw ((BindingException)ex);
/*     */     }
/* 953 */     throw new BindingException(ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.CommonSOAPBinding
 * JD-Core Version:    0.6.0
 */