/*     */ package org.jboss.ws.core;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.rpc.JAXRPCException;
/*     */ import javax.xml.rpc.ParameterMode;
/*     */ import javax.xml.soap.AttachmentPart;
/*     */ import javax.xml.soap.MessageFactory;
/*     */ import javax.xml.soap.MimeHeaders;
/*     */ import javax.xml.soap.SOAPException;
/*     */ import javax.xml.soap.SOAPMessage;
/*     */ import javax.xml.ws.addressing.AddressingProperties;
/*     */ import javax.xml.ws.addressing.AttributedURI;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.WSException;
/*     */ import org.jboss.ws.core.client.EndpointInfo;
/*     */ import org.jboss.ws.core.client.SOAPRemotingConnection;
/*     */ import org.jboss.ws.core.jaxrpc.ParameterWrapping;
/*     */ import org.jboss.ws.core.soap.MessageContextAssociation;
/*     */ import org.jboss.ws.core.soap.Style;
/*     */ import org.jboss.ws.core.soap.UnboundHeader;
/*     */ import org.jboss.ws.core.utils.HolderUtils;
/*     */ import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
/*     */ import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ import org.jboss.ws.metadata.umdm.OperationMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ParameterMetaData;
/*     */ import org.jboss.ws.metadata.umdm.ServiceMetaData;
/*     */ import org.jboss.ws.metadata.umdm.UnifiedMetaData;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
/*     */ import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
/*     */ import org.jboss.wsf.common.ResourceLoaderAdapter;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData.HandlerType;
/*     */ 
/*     */ public abstract class CommonClient
/*     */   implements StubExt, HeaderSource
/*     */ {
/*  79 */   private static Logger log = Logger.getLogger(CommonClient.class);
/*     */ 
/*  81 */   public static String SESSION_COOKIES = "org.jboss.ws.maintain.session.cookies";
/*     */   protected EndpointMetaData epMetaData;
/*     */   protected QName operationName;
/*     */   protected EndpointInvocation epInv;
/*     */   protected CommonBindingProvider bindingProvider;
/*  92 */   private Map<QName, UnboundHeader> unboundHeaders = new LinkedHashMap();
/*     */ 
/*  94 */   private List<AttachmentPart> attachmentParts = new ArrayList();
/*     */   private String securityConfig;
/*     */ 
/*     */   protected CommonClient(ServiceMetaData serviceMetaData)
/*     */   {
/* 103 */     if ((serviceMetaData != null) && (serviceMetaData.getEndpoints().size() == 1))
/*     */     {
/* 105 */       this.epMetaData = ((EndpointMetaData)serviceMetaData.getEndpoints().get(0));
/*     */     }
/*     */ 
/* 109 */     this.bindingProvider = getCommonBindingProvider();
/*     */   }
/*     */ 
/*     */   protected CommonClient(EndpointMetaData epMetaData)
/*     */   {
/* 116 */     this.epMetaData = epMetaData;
/*     */ 
/* 119 */     this.bindingProvider = getCommonBindingProvider();
/*     */   }
/*     */ 
/*     */   protected CommonClient(ServiceMetaData serviceMetaData, QName portName, QName opName)
/*     */   {
/* 126 */     if (serviceMetaData != null)
/*     */     {
/* 128 */       EndpointMetaData epMetaData = null;
/* 129 */       if (serviceMetaData.getEndpoints().size() > 0)
/*     */       {
/* 131 */         epMetaData = serviceMetaData.getEndpoint(portName);
/* 132 */         if (epMetaData == null) {
/* 133 */           throw new WSException("Cannot find endpoint for name: " + portName);
/*     */         }
/*     */       }
/* 136 */       if (epMetaData != null)
/*     */       {
/* 138 */         this.epMetaData = epMetaData;
/*     */       }
/*     */     }
/*     */ 
/* 142 */     if (opName != null)
/*     */     {
/* 144 */       setOperationName(opName);
/*     */     }
/*     */ 
/* 148 */     this.bindingProvider = getCommonBindingProvider();
/*     */   }
/*     */ 
/*     */   public abstract String getTargetEndpointAddress();
/*     */ 
/*     */   public abstract void setTargetEndpointAddress(String paramString);
/*     */ 
/*     */   public QName getOperationName()
/*     */   {
/* 163 */     return this.operationName;
/*     */   }
/*     */ 
/*     */   public void setOperationName(QName operationName)
/*     */   {
/* 170 */     this.operationName = operationName;
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData()
/*     */   {
/* 178 */     if (this.operationName == null) {
/* 179 */       throw new WSException("Operation name not set");
/*     */     }
/* 181 */     return getOperationMetaData(this.operationName);
/*     */   }
/*     */ 
/*     */   public OperationMetaData getOperationMetaData(QName opName)
/*     */   {
/* 188 */     if (opName == null) {
/* 189 */       throw new IllegalArgumentException("Cannot get OperationMetaData for null");
/*     */     }
/* 191 */     EndpointMetaData epMetaData = getEndpointMetaData();
/* 192 */     OperationMetaData opMetaData = epMetaData.getOperation(opName);
/* 193 */     if ((opMetaData == null) && (epMetaData.getServiceMetaData().getWsdlDefinitions() == null))
/*     */     {
/* 195 */       opMetaData = new OperationMetaData(epMetaData, opName, opName.getLocalPart());
/* 196 */       epMetaData.addOperation(opMetaData);
/*     */     }
/*     */ 
/* 199 */     if (opMetaData == null) {
/* 200 */       throw new WSException("Cannot obtain operation meta data for: " + opName);
/*     */     }
/* 202 */     return opMetaData;
/*     */   }
/*     */ 
/*     */   public EndpointMetaData getEndpointMetaData()
/*     */   {
/* 208 */     if (this.epMetaData == null)
/*     */     {
/* 210 */       ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 211 */       UnifiedVirtualFile vfsRoot = new ResourceLoaderAdapter();
/* 212 */       UnifiedMetaData wsMetaData = new UnifiedMetaData(vfsRoot);
/* 213 */       wsMetaData.setClassLoader(ctxLoader);
/*     */ 
/* 215 */       ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName("http://www.jboss.org/jbossws", "AnonymousService"));
/* 216 */       wsMetaData.addService(serviceMetaData);
/*     */ 
/* 218 */       QName anonQName = new QName("http://www.jboss.org/jbossws", "Anonymous");
/* 219 */       QName anonPort = new QName("http://www.jboss.org/jbossws", "AnonymousPort");
/* 220 */       this.epMetaData = new ClientEndpointMetaData(serviceMetaData, anonPort, anonQName, EndpointMetaData.Type.JAXRPC);
/* 221 */       this.epMetaData.setStyle(Style.RPC);
/*     */ 
/* 223 */       serviceMetaData.addEndpoint(this.epMetaData);
/*     */     }
/* 225 */     return this.epMetaData;
/*     */   }
/*     */ 
/*     */   protected abstract boolean callRequestHandlerChain(QName paramQName, UnifiedHandlerMetaData.HandlerType paramHandlerType);
/*     */ 
/*     */   protected abstract boolean callResponseHandlerChain(QName paramQName, UnifiedHandlerMetaData.HandlerType paramHandlerType);
/*     */ 
/*     */   protected abstract boolean callFaultHandlerChain(QName paramQName, UnifiedHandlerMetaData.HandlerType paramHandlerType, Exception paramException);
/*     */ 
/*     */   protected abstract void closeHandlerChain(QName paramQName, UnifiedHandlerMetaData.HandlerType paramHandlerType);
/*     */ 
/*     */   protected abstract void setInboundContextProperties();
/*     */ 
/*     */   protected abstract void setOutboundContextProperties();
/*     */ 
/*     */   protected abstract boolean shouldMaintainSession();
/*     */ 
/*     */   protected Object invoke(QName opName, Object[] inputParams, boolean forceOneway)
/*     */     throws Exception
/*     */   {
/* 254 */     if (!opName.equals(this.operationName)) {
/* 255 */       setOperationName(opName);
/*     */     }
/* 257 */     OperationMetaData opMetaData = getOperationMetaData();
/* 258 */     boolean oneway = (forceOneway) || (opMetaData.isOneWay());
/*     */ 
/* 261 */     CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
/* 262 */     msgContext.setOperationMetaData(opMetaData);
/*     */ 
/* 265 */     msgContext.putAll(getRequestContext());
/*     */ 
/* 268 */     DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.OutBound);
/*     */ 
/* 271 */     UnifiedHandlerMetaData.HandlerType[] handlerType = { UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST };
/* 272 */     UnifiedHandlerMetaData.HandlerType[] faultType = { UnifiedHandlerMetaData.HandlerType.PRE, UnifiedHandlerMetaData.HandlerType.ENDPOINT, UnifiedHandlerMetaData.HandlerType.POST };
/*     */ 
/* 274 */     QName portName = this.epMetaData.getPortName();
/*     */     try
/*     */     {
/* 278 */       CommonBinding binding = getCommonBindingProvider().getCommonBinding();
/* 279 */       binding.setHeaderSource(this);
/*     */ 
/* 282 */       this.epInv = new EndpointInvocation(opMetaData);
/* 283 */       this.epInv.initInputParams(inputParams);
/*     */ 
/* 286 */       setOutboundContextProperties();
/*     */ 
/* 289 */       MessageAbstraction reqMessage = binding.bindRequestMessage(opMetaData, this.epInv, this.unboundHeaders);
/*     */ 
/* 292 */       addAttachmentParts(reqMessage);
/*     */ 
/* 295 */       boolean handlerPass = callRequestHandlerChain(portName, handlerType[0]);
/* 296 */       handlerPass = (handlerPass) && (callRequestHandlerChain(portName, handlerType[1]));
/* 297 */       handlerPass = (handlerPass) && (callRequestHandlerChain(portName, handlerType[2]));
/*     */ 
/* 300 */       reqMessage = msgContext.getMessageAbstraction();
/*     */ 
/* 302 */       if (handlerPass)
/*     */       {
/* 304 */         String targetAddress = getTargetEndpointAddress();
/*     */ 
/* 307 */         AddressingProperties addrProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
/* 308 */         if ((targetAddress == null) && (addrProps != null) && (addrProps.getTo() != null))
/*     */         {
/* 310 */           AddressingConstantsImpl ADDR = new AddressingConstantsImpl();
/* 311 */           String wsaTo = addrProps.getTo().getURI().toString();
/* 312 */           if (!wsaTo.equals(ADDR.getAnonymousURI()))
/*     */           {
/*     */             try
/*     */             {
/* 316 */               URL wsaToURL = new URL(wsaTo);
/* 317 */               log.debug("Sending request to addressing destination: " + wsaToURL);
/* 318 */               targetAddress = wsaToURL.toExternalForm();
/*     */             }
/*     */             catch (MalformedURLException ex)
/*     */             {
/* 322 */               log.debug("Not a valid URL: " + wsaTo);
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 328 */         if (targetAddress == null) {
/* 329 */           throw new WSException("Target endpoint address not set");
/*     */         }
/* 331 */         Map callProps = new HashMap(getRequestContext());
/* 332 */         EndpointInfo epInfo = new EndpointInfo(this.epMetaData, targetAddress, callProps);
/* 333 */         if (shouldMaintainSession()) {
/* 334 */           addSessionInfo(reqMessage, callProps);
/*     */         }
/* 336 */         SOAPRemotingConnection remotingConnection = new SOAPRemotingConnection();
/* 337 */         MessageAbstraction resMessage = remotingConnection.invoke(reqMessage, epInfo, oneway);
/*     */ 
/* 339 */         if (shouldMaintainSession()) {
/* 340 */           saveSessionInfo(callProps, getRequestContext());
/*     */         }
/*     */ 
/* 343 */         msgContext = processPivotInternal(msgContext, direction);
/*     */ 
/* 346 */         msgContext.put(CommonMessageContext.REMOTING_METADATA, callProps);
/*     */ 
/* 349 */         msgContext.setMessageAbstraction(resMessage);
/*     */       }
/*     */ 
/* 352 */       setInboundContextProperties();
/*     */ 
/* 355 */       Object retObj = null;
/* 356 */       if ((!oneway) && (handlerPass))
/*     */       {
/* 359 */         if ((binding instanceof CommonSOAPBinding)) {
/* 360 */           ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
/*     */         }
/*     */ 
/* 363 */         handlerPass = callResponseHandlerChain(portName, handlerType[2]);
/* 364 */         faultType[2] = null;
/*     */ 
/* 367 */         if (handlerPass)
/*     */         {
/* 370 */           MessageAbstraction resMessage = msgContext.getMessageAbstraction();
/* 371 */           binding.unbindResponseMessage(opMetaData, resMessage, this.epInv, this.unboundHeaders);
/*     */         }
/*     */ 
/* 374 */         handlerPass = (handlerPass) && (callResponseHandlerChain(portName, handlerType[1]));
/* 375 */         faultType[1] = null;
/* 376 */         handlerPass = (handlerPass) && (callResponseHandlerChain(portName, handlerType[0]));
/* 377 */         faultType[0] = null;
/*     */ 
/* 380 */         if (msgContext.isModified())
/*     */         {
/* 382 */           log.debug("Handler modified body payload, unbind message again");
/* 383 */           resMessage = msgContext.getMessageAbstraction();
/* 384 */           binding.unbindResponseMessage(opMetaData, resMessage, this.epInv, this.unboundHeaders);
/*     */         }
/*     */ 
/* 387 */         retObj = syncOutputParams(inputParams, this.epInv);
/*     */       }
/*     */ 
/* 390 */       MessageAbstraction resMessage = retObj;
/*     */       return resMessage;
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 395 */       processPivotInternal(msgContext, direction);
/*     */ 
/* 397 */       if (faultType[2] != null)
/* 398 */         callFaultHandlerChain(portName, faultType[2], ex);
/* 399 */       if (faultType[1] != null)
/* 400 */         callFaultHandlerChain(portName, faultType[1], ex);
/* 401 */       if (faultType[0] != null)
/* 402 */         callFaultHandlerChain(portName, faultType[0], ex);
/* 403 */       throw ex;
/*     */     }
/*     */     finally
/*     */     {
/* 407 */       closeHandlerChain(portName, handlerType[2]);
/* 408 */       closeHandlerChain(portName, handlerType[1]);
/* 409 */       closeHandlerChain(portName, handlerType[0]); } throw localObject1;
/*     */   }
/*     */ 
/*     */   private void saveSessionInfo(Map<String, Object> remotingMetadata, Map<String, Object> requestContext)
/*     */   {
/* 415 */     Map cookies = (Map)requestContext.get(SESSION_COOKIES);
/* 416 */     if (cookies == null)
/*     */     {
/* 418 */       cookies = new HashMap();
/* 419 */       requestContext.put(SESSION_COOKIES, cookies);
/*     */     }
/*     */ 
/* 422 */     List setCookies = new ArrayList();
/*     */ 
/* 424 */     List setCookies1 = (List)remotingMetadata.get("Set-Cookie");
/* 425 */     if (setCookies1 != null) {
/* 426 */       setCookies.addAll(setCookies1);
/*     */     }
/* 428 */     List setCookies2 = (List)remotingMetadata.get("Set-Cookie2");
/* 429 */     if (setCookies2 != null) {
/* 430 */       setCookies.addAll(setCookies2);
/*     */     }
/*     */ 
/* 433 */     for (String setCookie : setCookies)
/*     */     {
/* 435 */       int index = setCookie.indexOf(';');
/* 436 */       if (index == -1) {
/*     */         continue;
/*     */       }
/* 439 */       String pair = setCookie.substring(0, index);
/* 440 */       index = pair.indexOf('=');
/* 441 */       if (index == -1) {
/*     */         continue;
/*     */       }
/* 444 */       String name = pair.substring(0, index);
/* 445 */       String value = pair.substring(index + 1);
/*     */ 
/* 447 */       cookies.put(name, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void addSessionInfo(MessageAbstraction reqMessage, Map<String, Object> callProperties)
/*     */   {
/* 453 */     Map cookies = (Map)callProperties.get(SESSION_COOKIES);
/* 454 */     if (cookies != null)
/*     */     {
/* 456 */       for (Map.Entry cookie : cookies.entrySet())
/*     */       {
/* 458 */         reqMessage.getMimeHeaders().addHeader("Cookie", (String)cookie.getKey() + "=" + (String)cookie.getValue());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction)
/*     */   {
/* 465 */     if (direction.getDirection() == DirectionHolder.Direction.OutBound)
/*     */     {
/* 467 */       msgContext = processPivot(msgContext);
/* 468 */       direction.setDirection(DirectionHolder.Direction.InBound);
/*     */     }
/* 470 */     return msgContext;
/*     */   }
/*     */ 
/*     */   protected void addAttachmentParts(MessageAbstraction reqMessage)
/*     */   {
/* 475 */     for (AttachmentPart part : this.attachmentParts)
/*     */     {
/* 477 */       log.debug("Adding attachment part: " + part.getContentId());
/* 478 */       reqMessage.addAttachmentPart(part);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract CommonMessageContext processPivot(CommonMessageContext paramCommonMessageContext);
/*     */ 
/*     */   protected abstract CommonBindingProvider getCommonBindingProvider();
/*     */ 
/*     */   protected abstract Map<String, Object> getRequestContext();
/*     */ 
/*     */   private Object syncOutputParams(Object[] inParams, EndpointInvocation epInv) throws SOAPException {
/* 492 */     Object retValue = null;
/*     */ 
/* 495 */     OperationMetaData opMetaData = getOperationMetaData();
/* 496 */     ParameterMetaData retMetaData = opMetaData.getReturnParameter();
/* 497 */     if (retMetaData != null)
/*     */     {
/* 499 */       retValue = epInv.getReturnValue();
/* 500 */       if ((opMetaData.isDocumentWrapped()) && (!retMetaData.isMessageType())) {
/* 501 */         retValue = ParameterWrapping.unwrapResponseParameters(retMetaData, retValue, inParams);
/*     */       }
/*     */     }
/*     */ 
/* 505 */     for (ParameterMetaData paramMetaData : opMetaData.getParameters())
/*     */     {
/* 507 */       ParameterMode paramMode = paramMetaData.getMode();
/*     */ 
/* 509 */       int index = paramMetaData.getIndex();
/* 510 */       if ((index == -1) || (paramMode == ParameterMode.INOUT) || (paramMode == ParameterMode.OUT))
/*     */       {
/* 512 */         QName xmlName = paramMetaData.getXmlName();
/* 513 */         Object value = epInv.getResponseParamValue(xmlName);
/*     */ 
/* 515 */         if (index == -1)
/*     */         {
/* 517 */           retValue = value;
/*     */         }
/*     */         else
/*     */         {
/* 521 */           if (log.isTraceEnabled())
/* 522 */             log.trace("holder [" + index + "] " + xmlName);
/* 523 */           HolderUtils.setHolderValue(inParams[index], value);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 528 */     return retValue;
/*     */   }
/*     */ 
/*     */   public void addUnboundHeader(QName xmlName, QName xmlType, Class javaType, ParameterMode mode)
/*     */   {
/* 540 */     UnboundHeader unboundHeader = new UnboundHeader(xmlName, xmlType, javaType, mode);
/* 541 */     this.unboundHeaders.put(xmlName, unboundHeader);
/*     */   }
/*     */ 
/*     */   public Object getUnboundHeaderValue(QName xmlName)
/*     */   {
/* 553 */     UnboundHeader unboundHeader = (UnboundHeader)this.unboundHeaders.get(xmlName);
/* 554 */     return unboundHeader != null ? unboundHeader.getHeaderValue() : null;
/*     */   }
/*     */ 
/*     */   public void setUnboundHeaderValue(QName xmlName, Object value)
/*     */   {
/* 565 */     UnboundHeader unboundHeader = (UnboundHeader)this.unboundHeaders.get(xmlName);
/* 566 */     if (unboundHeader == null) {
/* 567 */       throw new IllegalArgumentException("Cannot find unbound header: " + xmlName);
/*     */     }
/* 569 */     unboundHeader.setHeaderValue(value);
/*     */   }
/*     */ 
/*     */   public void clearUnboundHeaders()
/*     */   {
/* 578 */     this.unboundHeaders.clear();
/*     */   }
/*     */ 
/*     */   public void removeUnboundHeader(QName xmlName)
/*     */   {
/* 587 */     this.unboundHeaders.remove(xmlName);
/*     */   }
/*     */ 
/*     */   public Iterator getUnboundHeaders()
/*     */   {
/* 596 */     return this.unboundHeaders.keySet().iterator();
/*     */   }
/*     */ 
/*     */   public void addAttachmentPart(AttachmentPart part)
/*     */   {
/* 605 */     this.attachmentParts.add(part);
/*     */   }
/*     */ 
/*     */   public void clearAttachmentParts()
/*     */   {
/* 613 */     this.attachmentParts.clear();
/*     */   }
/*     */ 
/*     */   public AttachmentPart createAttachmentPart()
/*     */   {
/*     */     try
/*     */     {
/* 623 */       MessageFactory factory = MessageFactory.newInstance();
/* 624 */       return factory.createMessage().createAttachmentPart();
/*     */     }
/*     */     catch (SOAPException ex) {
/*     */     }
/* 628 */     throw new JAXRPCException("Cannot create attachment part");
/*     */   }
/*     */ 
/*     */   public String getConfigName()
/*     */   {
/* 634 */     EndpointMetaData epMetaData = getEndpointMetaData();
/* 635 */     return epMetaData.getConfigName();
/*     */   }
/*     */ 
/*     */   public void setConfigName(String configName)
/*     */   {
/* 640 */     setConfigName(configName, null);
/*     */   }
/*     */ 
/*     */   public abstract void setConfigName(String paramString1, String paramString2);
/*     */ 
/*     */   public String getConfigFile() {
/* 647 */     EndpointMetaData epMetaData = getEndpointMetaData();
/* 648 */     return epMetaData.getConfigFile();
/*     */   }
/*     */ 
/*     */   public String getSecurityConfig()
/*     */   {
/* 653 */     return this.securityConfig;
/*     */   }
/*     */ 
/*     */   public void setSecurityConfig(String securityConfig)
/*     */   {
/* 658 */     this.securityConfig = securityConfig;
/*     */ 
/* 660 */     if (securityConfig != null)
/*     */     {
/* 662 */       EndpointMetaData epMetaData = getEndpointMetaData();
/* 663 */       ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
/* 664 */       if (serviceMetaData.getSecurityConfiguration() == null)
/*     */       {
/*     */         try
/*     */         {
/* 668 */           WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
/* 669 */           UnifiedVirtualFile vfsRoot = serviceMetaData.getUnifiedMetaData().getRootFile();
/* 670 */           WSSecurityConfiguration config = wsseConfFactory.createConfiguration(vfsRoot, securityConfig);
/* 671 */           serviceMetaData.setSecurityConfiguration(config);
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/* 675 */           WSException.rethrow("Cannot set security config", ex);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.CommonClient
 * JD-Core Version:    0.6.0
 */