/*     */ package org.jboss.ws.core;
/*     */ 
/*     */ import java.util.Observable;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.core.jaxrpc.SOAP11BindingJAXRPC;
/*     */ import org.jboss.ws.core.jaxrpc.SOAP12BindingJAXRPC;
/*     */ import org.jboss.ws.core.jaxws.binding.HTTPBindingJAXWS;
/*     */ import org.jboss.ws.core.jaxws.binding.SOAP11BindingJAXWS;
/*     */ import org.jboss.ws.core.jaxws.binding.SOAP12BindingJAXWS;
/*     */ import org.jboss.ws.metadata.config.Configurable;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData;
/*     */ import org.jboss.ws.metadata.umdm.EndpointMetaData.Type;
/*     */ 
/*     */ public class CommonBindingProvider
/*     */   implements Configurable
/*     */ {
/*  50 */   private static Logger log = Logger.getLogger(CommonBindingProvider.class);
/*     */   protected EndpointMetaData epMetaData;
/*     */   protected CommonBinding binding;
/*     */ 
/*     */   public CommonBindingProvider(EndpointMetaData epMetaData)
/*     */   {
/*  57 */     this.epMetaData = epMetaData;
/*  58 */     initBinding(epMetaData.getBindingId(), epMetaData.getType());
/*     */ 
/*  60 */     this.epMetaData.registerConfigObserver(this);
/*  61 */     configure();
/*     */   }
/*     */ 
/*     */   public CommonBindingProvider(String bindingId, EndpointMetaData.Type type)
/*     */   {
/*  66 */     initBinding(bindingId, type);
/*  67 */     configure();
/*     */   }
/*     */ 
/*     */   private void configure()
/*     */   {
/*  73 */     if (this.epMetaData != null)
/*     */     {
/*  75 */       this.epMetaData.configure(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initBinding(String bindingId, EndpointMetaData.Type type)
/*     */   {
/*  81 */     if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingId))
/*     */     {
/*  83 */       this.binding = (type == EndpointMetaData.Type.JAXWS ? new SOAP11BindingJAXWS() : new SOAP11BindingJAXRPC());
/*     */     }
/*  85 */     else if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bindingId))
/*     */     {
/*  87 */       this.binding = (type == EndpointMetaData.Type.JAXWS ? new SOAP11BindingJAXWS(true) : new SOAP11BindingJAXRPC(true));
/*     */     }
/*  89 */     else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingId))
/*     */     {
/*  91 */       this.binding = (type == EndpointMetaData.Type.JAXWS ? new SOAP12BindingJAXWS() : new SOAP12BindingJAXRPC());
/*     */     }
/*  93 */     else if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingId))
/*     */     {
/*  95 */       this.binding = (type == EndpointMetaData.Type.JAXWS ? new SOAP12BindingJAXWS(true) : new SOAP12BindingJAXRPC(true));
/*     */     }
/*  97 */     else if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingId))
/*     */     {
/*  99 */       this.binding = new HTTPBindingJAXWS();
/*     */     }
/*     */   }
/*     */ 
/*     */   public CommonBinding getCommonBinding()
/*     */   {
/* 105 */     return this.binding;
/*     */   }
/*     */ 
/*     */   public void update(Observable observable, Object object)
/*     */   {
/* 110 */     if (log.isDebugEnabled()) log.debug("Update config: " + object);
/* 111 */     configure();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.ws.core.CommonBindingProvider
 * JD-Core Version:    0.6.0
 */