/*     */ package org.jboss.web.deployers;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.LinkRef;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.ejb.EjbUtil50;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
/*     */ import org.jboss.metadata.serviceref.ServiceReferenceHandler;
/*     */ import org.jboss.metadata.serviceref.VirtualFileAdaptor;
/*     */ import org.jboss.metadata.web.jboss.JBossWebMetaData;
/*     */ import org.jboss.mx.loading.LoaderRepositoryFactory;
/*     */ import org.jboss.naming.NonSerializableFactory;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.security.AuthorizationManager;
/*     */ import org.jboss.security.SecurityUtil;
/*     */ import org.jboss.security.authorization.PolicyRegistration;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.web.WebApplication;
/*     */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*     */ import org.omg.CORBA.ORB;
/*     */ 
/*     */ public abstract class AbstractWarDeployment
/*     */ {
/*     */   public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
/*     */   protected Logger log;
/*     */   protected MBeanServer server;
/*     */   protected MainDeployerStructure mainDeployer;
/* 110 */   protected boolean java2ClassLoadingCompliance = false;
/*     */ 
/* 114 */   protected boolean unpackWars = true;
/*     */ 
/* 119 */   protected boolean lenientEjbLink = false;
/*     */   protected String defaultSecurityDomain;
/*     */ 
/*     */   public AbstractWarDeployment()
/*     */   {
/* 128 */     this.log = Logger.getLogger(getClass());
/*     */   }
/*     */ 
/*     */   public static String shortWarUrlFromServerHome(String warUrl)
/*     */   {
/* 140 */     String serverHomeUrl = System.getProperty("jboss.server.home.url");
/*     */ 
/* 142 */     if ((warUrl == null) || (serverHomeUrl == null)) {
/* 143 */       return warUrl;
/*     */     }
/* 145 */     if (warUrl.startsWith(serverHomeUrl)) {
/* 146 */       return ".../" + warUrl.substring(serverHomeUrl.length());
/*     */     }
/* 148 */     return warUrl;
/*     */   }
/*     */ 
/*     */   public abstract void init(Object paramObject)
/*     */     throws Exception;
/*     */ 
/*     */   public MBeanServer getServer()
/*     */   {
/* 160 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setServer(MBeanServer server)
/*     */   {
/* 165 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public MainDeployerStructure getMainDeployer()
/*     */   {
/* 170 */     return this.mainDeployer;
/*     */   }
/*     */ 
/*     */   public void setMainDeployer(MainDeployerStructure mainDeployer)
/*     */   {
/* 175 */     this.mainDeployer = mainDeployer;
/*     */   }
/*     */ 
/*     */   public boolean getJava2ClassLoadingCompliance()
/*     */   {
/* 186 */     return this.java2ClassLoadingCompliance;
/*     */   }
/*     */ 
/*     */   public void setJava2ClassLoadingCompliance(boolean flag)
/*     */   {
/* 197 */     this.java2ClassLoadingCompliance = flag;
/*     */   }
/*     */ 
/*     */   public boolean getUnpackWars()
/*     */   {
/* 209 */     return this.unpackWars;
/*     */   }
/*     */ 
/*     */   public void setUnpackWars(boolean flag)
/*     */   {
/* 221 */     this.unpackWars = flag;
/*     */   }
/*     */ 
/*     */   public boolean getLenientEjbLink()
/*     */   {
/* 232 */     return this.lenientEjbLink;
/*     */   }
/*     */ 
/*     */   public void setLenientEjbLink(boolean flag)
/*     */   {
/* 242 */     this.lenientEjbLink = flag;
/*     */   }
/*     */ 
/*     */   public String getDefaultSecurityDomain()
/*     */   {
/* 253 */     if (this.defaultSecurityDomain == null)
/* 254 */       throw new IllegalStateException("Default Security Domain is null");
/* 255 */     return this.defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public void setDefaultSecurityDomain(String defaultSecurityDomain)
/*     */   {
/* 267 */     this.defaultSecurityDomain = defaultSecurityDomain;
/*     */   }
/*     */ 
/*     */   public synchronized WebApplication start(VFSDeploymentUnit unit, JBossWebMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 305 */     Thread thread = Thread.currentThread();
/* 306 */     ClassLoader appClassLoader = thread.getContextClassLoader();
/* 307 */     WebApplication webApp = null;
/*     */     try
/*     */     {
/* 311 */       URL[] empty = new URL[0];
/* 312 */       URLClassLoader warLoader = URLClassLoader.newInstance(empty, unit.getClassLoader());
/* 313 */       thread.setContextClassLoader(warLoader);
/* 314 */       String webContext = metaData.getContextRoot();
/*     */ 
/* 318 */       URL warURL = (URL)unit.getAttachment("org.jboss.web.expandedWarURL", URL.class);
/* 319 */       if (warURL == null)
/* 320 */         warURL = (URL)unit.getAttachment("jbossws.expanded.war.url", URL.class);
/* 321 */       if (warURL == null) {
/* 322 */         warURL = unit.getRoot().toURL();
/*     */       }
/*     */ 
/* 325 */       String warURLString = warURL.toString();
/* 326 */       if (warURLString.startsWith("jar:")) {
/* 327 */         warURLString = warURLString.substring(4, warURLString.length() - 2);
/*     */       }
/* 329 */       this.log.debug("webContext: " + webContext);
/* 330 */       this.log.debug("warURL: " + warURLString);
/*     */ 
/* 333 */       String contextID = metaData.getJaccContextID();
/* 334 */       if (contextID == null)
/* 335 */         contextID = unit.getSimpleName();
/* 336 */       metaData.setJaccContextID(contextID);
/*     */ 
/* 338 */       webApp = new WebApplication(metaData);
/* 339 */       webApp.setClassLoader(warLoader);
/* 340 */       webApp.setDeploymentUnit(unit);
/* 341 */       performDeploy(webApp, warURLString);
/*     */     }
/*     */     finally
/*     */     {
/* 345 */       thread.setContextClassLoader(appClassLoader);
/*     */     }
/* 347 */     return webApp;
/*     */   }
/*     */ 
/*     */   public synchronized void stop(DeploymentUnit di, WebApplication webApp)
/*     */     throws Exception
/*     */   {
/* 359 */     URL warURL = webApp.getURL();
/* 360 */     String warUrl = warURL.toString();
/* 361 */     performUndeploy(webApp, warUrl);
/*     */ 
/* 363 */     JBossWebMetaData metaData = webApp.getMetaData();
/* 364 */     String contextID = metaData.getJaccContextID();
/*     */ 
/* 366 */     String prefixedSecurityDomain = webApp.getMetaData().getSecurityDomain();
/* 367 */     if (prefixedSecurityDomain != null)
/*     */     {
/* 369 */       String unPrefixedDomain = SecurityUtil.unprefixSecurityDomain(prefixedSecurityDomain);
/*     */ 
/* 371 */       InitialContext ic = new InitialContext();
/* 372 */       String amCtx = "java:/jaas/" + unPrefixedDomain + "/authorizationMgr";
/*     */ 
/* 375 */       AuthorizationManager authzmgr = (AuthorizationManager)ic.lookup(amCtx);
/*     */ 
/* 378 */       if ((authzmgr instanceof PolicyRegistration))
/*     */       {
/* 380 */         PolicyRegistration xam = (PolicyRegistration)authzmgr;
/* 381 */         xam.deRegisterPolicy(contextID);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected abstract void performDeploy(WebApplication paramWebApplication, String paramString)
/*     */     throws Exception;
/*     */ 
/*     */   protected abstract void performUndeploy(WebApplication paramWebApplication, String paramString)
/*     */     throws Exception;
/*     */ 
/*     */   protected void processEnc(ClassLoader loader, WebApplication webApp)
/*     */     throws Exception
/*     */   {
/* 417 */     if (loader == null)
/* 418 */       throw new IllegalArgumentException("Classloader passed to process ENC refs is null");
/* 419 */     this.log.debug("AbstractWebContainer.parseWebAppDescriptors, Begin");
/* 420 */     InitialContext iniCtx = new InitialContext();
/* 421 */     Context envCtx = null;
/* 422 */     Thread currentThread = Thread.currentThread();
/* 423 */     ClassLoader currentLoader = currentThread.getContextClassLoader();
/* 424 */     JBossWebMetaData metaData = webApp.getMetaData();
/*     */     try
/*     */     {
/* 428 */       this.log.debug("Creating ENC using ClassLoader: " + loader);
/* 429 */       ClassLoader parent = loader.getParent();
/* 430 */       while (parent != null)
/*     */       {
/* 432 */         this.log.debug(".." + parent);
/* 433 */         parent = parent.getParent();
/*     */       }
/*     */ 
/* 436 */       currentThread.setContextClassLoader(loader);
/*     */ 
/* 438 */       envCtx = (Context)iniCtx.lookup("java:comp");
/*     */ 
/* 441 */       ORB orb = null;
/*     */       try
/*     */       {
/* 444 */         ObjectName ORB_NAME = new ObjectName("jboss:service=CorbaORB");
/* 445 */         orb = (ORB)this.server.getAttribute(ORB_NAME, "ORB");
/*     */ 
/* 447 */         if (orb != null)
/*     */         {
/* 449 */           NonSerializableFactory.rebind(envCtx, "ORB", orb);
/* 450 */           this.log.debug("Bound java:comp/ORB");
/*     */         }
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 455 */         this.log.debug("Unable to retrieve orb" + t.toString());
/*     */       }
/*     */ 
/* 459 */       envCtx.bind("UserTransaction", new LinkRef("UserTransaction"));
/* 460 */       this.log.debug("Linked java:comp/UserTransaction to JNDI name: UserTransaction");
/* 461 */       envCtx = envCtx.createSubcontext("env");
/* 462 */       processEncReferences(webApp, envCtx);
/*     */     }
/*     */     finally
/*     */     {
/* 466 */       currentThread.setContextClassLoader(currentLoader);
/*     */     }
/*     */ 
/* 469 */     String securityDomain = metaData.getSecurityDomain();
/* 470 */     this.log.debug("linkSecurityDomain");
/* 471 */     linkSecurityDomain(securityDomain, envCtx);
/* 472 */     this.log.debug("AbstractWebContainer.parseWebAppDescriptors, End");
/*     */   }
/*     */ 
/*     */   protected void processEncReferences(WebApplication webApp, Context envCtx)
/*     */     throws ClassNotFoundException, NamingException
/*     */   {
/* 478 */     VFSDeploymentUnit unit = webApp.getDeploymentUnit();
/* 479 */     JBossWebMetaData metaData = webApp.getMetaData();
/* 480 */     EnvironmentEntriesMetaData envEntries = metaData.getEnvironmentEntries();
/* 481 */     this.log.debug("addEnvEntries");
/* 482 */     addEnvEntries(envEntries, envCtx);
/* 483 */     ResourceEnvironmentReferencesMetaData resourceEnvRefs = metaData.getResourceEnvironmentReferences();
/* 484 */     this.log.debug("linkResourceEnvRefs");
/* 485 */     linkResourceEnvRefs(resourceEnvRefs, envCtx);
/* 486 */     ResourceReferencesMetaData resourceRefs = metaData.getResourceReferences();
/* 487 */     this.log.debug("linkResourceRefs");
/* 488 */     linkResourceRefs(resourceRefs, envCtx);
/* 489 */     this.log.debug("linkMessageDestinationRefs");
/* 490 */     MessageDestinationReferencesMetaData msgRefs = metaData.getMessageDestinationReferences();
/* 491 */     linkMessageDestinationRefs(unit, msgRefs, envCtx);
/* 492 */     EJBReferencesMetaData ejbRefs = metaData.getEjbReferences();
/* 493 */     this.log.debug("linkEjbRefs");
/* 494 */     linkEjbRefs(unit, ejbRefs, envCtx);
/* 495 */     EJBLocalReferencesMetaData ejbLocalRefs = metaData.getEjbLocalReferences();
/* 496 */     this.log.debug("linkEjbLocalRefs");
/* 497 */     linkEjbLocalRefs(unit, ejbLocalRefs, envCtx);
/* 498 */     this.log.debug("linkServiceRefs");
/* 499 */     ServiceReferencesMetaData serviceRefs = metaData.getServiceReferences();
/* 500 */     linkServiceRefs(unit, serviceRefs, envCtx);
/*     */   }
/*     */ 
/*     */   private void linkServiceRefs(VFSDeploymentUnit unit, ServiceReferencesMetaData serviceRefs, Context envCtx) throws NamingException
/*     */   {
/* 505 */     ClassLoader loader = unit.getClassLoader();
/* 506 */     UnifiedVirtualFile vfsRoot = new VirtualFileAdaptor(unit.getRoot());
/* 507 */     for (ServiceReferenceMetaData sref : serviceRefs)
/*     */     {
/* 509 */       String refName = sref.getServiceRefName();
/* 510 */       new ServiceReferenceHandler().bindServiceRef(envCtx, refName, vfsRoot, loader, sref);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void addEnvEntries(EnvironmentEntriesMetaData envEntries, Context envCtx)
/*     */     throws ClassNotFoundException, NamingException
/*     */   {
/* 517 */     for (EnvironmentEntryMetaData entry : envEntries)
/*     */     {
/* 519 */       this.log.debug("Binding env-entry: " + entry.getName() + " of type: " + entry.getType() + " to value:" + entry.getValue());
/*     */ 
/* 521 */       bindEnvEntry(envCtx, entry);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void linkResourceEnvRefs(ResourceEnvironmentReferencesMetaData resourceEnvRefs, Context envCtx)
/*     */     throws NamingException
/*     */   {
/* 528 */     for (ResourceEnvironmentReferenceMetaData ref : resourceEnvRefs)
/*     */     {
/* 530 */       String resourceName = ref.getJndiName();
/* 531 */       String refName = ref.getResourceEnvRefName();
/* 532 */       if (ref.getType().equals("java.net.URL"))
/*     */       {
/*     */         try
/*     */         {
/* 536 */           this.log.debug("Binding '" + refName + "' to URL: " + resourceName);
/* 537 */           URL url = new URL(resourceName);
/* 538 */           Util.bind(envCtx, refName, url);
/*     */         }
/*     */         catch (MalformedURLException e)
/*     */         {
/* 542 */           throw new NamingException("Malformed URL:" + e.getMessage());
/*     */         }
/*     */       }
/* 545 */       else if (resourceName != null)
/*     */       {
/* 547 */         this.log.debug("Linking '" + refName + "' to JNDI name: " + resourceName);
/* 548 */         Util.bind(envCtx, refName, new LinkRef(resourceName));
/*     */       }
/*     */       else
/*     */       {
/* 552 */         throw new NamingException("resource-env-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-env-ref.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void linkResourceRefs(ResourceReferencesMetaData resourceRefs, Context envCtx)
/*     */     throws NamingException
/*     */   {
/* 561 */     for (ResourceReferenceMetaData ref : resourceRefs)
/*     */     {
/* 563 */       String jndiName = ref.getJndiName();
/* 564 */       String refName = ref.getResourceName();
/* 565 */       if (ref.getType().equals("java.net.URL"))
/*     */       {
/*     */         try
/*     */         {
/* 569 */           String resURL = ref.getResUrl();
/* 570 */           if (resURL != null)
/*     */           {
/* 572 */             this.log.debug("Binding '" + refName + "' to URL: " + resURL);
/* 573 */             URL url = new URL(resURL);
/* 574 */             Util.bind(envCtx, refName, url);
/*     */           }
/*     */           else
/*     */           {
/* 578 */             this.log.debug("Linking '" + refName + "' to URL: " + resURL);
/* 579 */             LinkRef urlLink = new LinkRef(jndiName);
/* 580 */             Util.bind(envCtx, refName, urlLink);
/*     */           }
/*     */         }
/*     */         catch (MalformedURLException e)
/*     */         {
/* 585 */           throw new NamingException("Malformed URL:" + e.getMessage());
/*     */         }
/*     */       }
/* 588 */       else if (jndiName != null)
/*     */       {
/* 590 */         this.log.debug("Linking '" + refName + "' to JNDI name: " + jndiName);
/* 591 */         Util.bind(envCtx, refName, new LinkRef(jndiName));
/*     */       }
/*     */       else
/*     */       {
/* 595 */         throw new NamingException("resource-ref: " + refName + " has no valid JNDI binding. Check the jboss-web/resource-ref.");
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void linkMessageDestinationRefs(DeploymentUnit unit, MessageDestinationReferencesMetaData msgRefs, Context envCtx)
/*     */     throws NamingException
/*     */   {
/* 604 */     for (MessageDestinationReferenceMetaData ref : msgRefs)
/*     */     {
/* 606 */       String refName = ref.getName();
/* 607 */       String jndiName = ref.getJndiName();
/* 608 */       String link = ref.getLink();
/* 609 */       if (link != null)
/*     */       {
/* 611 */         if (jndiName == null)
/*     */         {
/* 613 */           MessageDestinationMetaData messageDestination = EjbUtil50.findMessageDestination(this.mainDeployer, unit, link);
/* 614 */           if (messageDestination == null) {
/* 615 */             throw new NamingException("message-destination-ref '" + refName + "' message-destination-link '" + link + "' not found and no jndi-name in jboss-web.xml");
/*     */           }
/*     */ 
/* 619 */           String linkJNDIName = messageDestination.getJndiName();
/* 620 */           if (linkJNDIName == null)
/* 621 */             this.log.warn("message-destination '" + link + "' has no jndi-name in jboss-web.xml");
/*     */           else
/* 623 */             jndiName = linkJNDIName;
/*     */         }
/*     */         else
/*     */         {
/* 627 */           this.log.warn("message-destination-ref '" + refName + "' ignoring message-destination-link '" + link + "' because it has a jndi-name in jboss-web.xml");
/*     */         }
/*     */       }
/* 630 */       else if (jndiName == null) {
/* 631 */         throw new NamingException("message-destination-ref '" + refName + "' has no message-destination-link in web.xml and no jndi-name in jboss-web.xml");
/*     */       }
/* 633 */       Util.bind(envCtx, refName, new LinkRef(jndiName));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void linkEjbRefs(DeploymentUnit unit, EJBReferencesMetaData ejbRefs, Context envCtx)
/*     */     throws NamingException
/*     */   {
/* 640 */     for (EJBReferenceMetaData ejb : ejbRefs)
/*     */     {
/* 642 */       String name = ejb.getName();
/* 643 */       String linkName = ejb.getLink();
/* 644 */       String jndiName = null;
/*     */ 
/* 647 */       if (linkName != null)
/*     */       {
/* 649 */         jndiName = EjbUtil50.findEjbLink(this.mainDeployer, unit, linkName);
/*     */ 
/* 652 */         if ((jndiName == null) && (!getLenientEjbLink())) {
/* 653 */           throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 658 */       if (jndiName == null)
/*     */       {
/* 660 */         jndiName = ejb.getJndiName();
/* 661 */         if (jndiName == null) {
/* 662 */           throw new NamingException("ejb-ref: " + name + ", no ejb-link in web.xml and no jndi-name in jboss-web.xml");
/*     */         }
/*     */       }
/* 665 */       this.log.debug("Linking ejb-ref: " + name + " to JNDI name: " + jndiName);
/* 666 */       Util.bind(envCtx, name, new LinkRef(jndiName));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void linkEjbLocalRefs(DeploymentUnit unit, EJBLocalReferencesMetaData ejbLocalRefs, Context envCtx)
/*     */     throws NamingException
/*     */   {
/* 673 */     for (EJBLocalReferenceMetaData ejb : ejbLocalRefs)
/*     */     {
/* 675 */       String name = ejb.getName();
/* 676 */       String linkName = ejb.getLink();
/* 677 */       String jndiName = null;
/*     */ 
/* 680 */       if (linkName != null)
/*     */       {
/* 682 */         jndiName = EjbUtil50.findLocalEjbLink(this.mainDeployer, unit, linkName);
/*     */ 
/* 685 */         if ((jndiName == null) && (!getLenientEjbLink())) {
/* 686 */           throw new NamingException("ejb-ref: " + name + ", no ejb-link match");
/*     */         }
/*     */       }
/*     */ 
/* 690 */       if (jndiName == null)
/*     */       {
/* 692 */         jndiName = ejb.getJndiName();
/* 693 */         if (jndiName == null)
/*     */         {
/* 695 */           String msg = null;
/* 696 */           if (linkName == null)
/*     */           {
/* 698 */             msg = "ejb-local-ref: '" + name + "', no ejb-link in web.xml and " + "no local-jndi-name in jboss-web.xml";
/*     */           }
/*     */           else
/*     */           {
/* 703 */             msg = "ejb-local-ref: '" + name + "', with web.xml ejb-link: '" + linkName + "' failed to resolve to an ejb with a LocalHome";
/*     */           }
/*     */ 
/* 706 */           throw new NamingException(msg);
/*     */         }
/*     */       }
/*     */ 
/* 710 */       this.log.debug("Linking ejb-local-ref: " + name + " to JNDI name: " + jndiName);
/* 711 */       Util.bind(envCtx, name, new LinkRef(jndiName));
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void linkSecurityDomain(String securityDomain, Context envCtx)
/*     */     throws NamingException
/*     */   {
/* 727 */     if (securityDomain == null)
/*     */     {
/* 729 */       securityDomain = getDefaultSecurityDomain();
/* 730 */       this.log.debug("No security-domain given, using default: " + securityDomain);
/*     */     }
/* 732 */     this.log.debug("Linking security/securityMgr to JNDI name: " + securityDomain);
/* 733 */     Util.bind(envCtx, "security/securityMgr", new LinkRef(securityDomain));
/* 734 */     Util.bind(envCtx, "security/realmMapping", new LinkRef(securityDomain + "/realmMapping"));
/* 735 */     Util.bind(envCtx, "security/authorizationMgr", new LinkRef(securityDomain + "/authorizationMgr"));
/* 736 */     Util.bind(envCtx, "security/security-domain", new LinkRef(securityDomain));
/* 737 */     Util.bind(envCtx, "security/subject", new LinkRef(securityDomain + "/subject"));
/*     */   }
/*     */ 
/*     */   public String[] getStandardCompileClasspath(ClassLoader loader)
/*     */   {
/* 749 */     String[] jspResources = { "javax/servlet/resources/web-app_2_3.dtd", "org/apache/jasper/resources/jsp12.dtd", "javax/ejb/EJBHome.class" };
/*     */ 
/* 754 */     ArrayList tmp = new ArrayList();
/* 755 */     for (int j = 0; j < jspResources.length; j++)
/*     */     {
/* 757 */       URL rsrcURL = loader.getResource(jspResources[j]);
/* 758 */       if (rsrcURL != null)
/*     */       {
/* 760 */         String url = rsrcURL.toExternalForm();
/* 761 */         if (rsrcURL.getProtocol().equals("jar"))
/*     */         {
/* 764 */           url = url.substring(4);
/* 765 */           int seperator = url.indexOf('!');
/* 766 */           url = url.substring(0, seperator);
/*     */         }
/* 768 */         tmp.add(url);
/*     */       }
/*     */       else
/*     */       {
/* 772 */         this.log.warn("Failed to fin jsp rsrc: " + jspResources[j]);
/*     */       }
/*     */     }
/* 775 */     this.log.trace("JSP StandardCompileClasspath: " + tmp);
/* 776 */     String[] cp = new String[tmp.size()];
/* 777 */     tmp.toArray(cp);
/* 778 */     return cp;
/*     */   }
/*     */ 
/*     */   public String[] getCompileClasspath(ClassLoader loader)
/*     */   {
/* 788 */     HashSet tmp = new HashSet();
/* 789 */     ClassLoader cl = loader;
/* 790 */     while (cl != null)
/*     */     {
/* 792 */       URL[] urls = AbstractWarDeployer.getClassLoaderURLs(cl);
/* 793 */       addURLs(tmp, urls);
/* 794 */       cl = cl.getParent();
/*     */     }
/*     */     try
/*     */     {
/* 798 */       URL[] globalUrls = (URL[])(URL[])this.server.getAttribute(LoaderRepositoryFactory.DEFAULT_LOADER_REPOSITORY, "URLs");
/*     */ 
/* 800 */       addURLs(tmp, globalUrls);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 804 */       this.log.warn("Could not get global URL[] from default loader repository!", e);
/*     */     }
/* 806 */     this.log.trace("JSP CompileClasspath: " + tmp);
/* 807 */     String[] cp = new String[tmp.size()];
/* 808 */     tmp.toArray(cp);
/* 809 */     return cp;
/*     */   }
/*     */ 
/*     */   private void addURLs(Set urlSet, URL[] urls)
/*     */   {
/* 814 */     for (int u = 0; u < urls.length; u++)
/*     */     {
/* 816 */       URL url = urls[u];
/* 817 */       urlSet.add(url.toExternalForm());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void bindEnvEntry(Context ctx, EnvironmentEntryMetaData entry)
/*     */     throws ClassNotFoundException, NamingException
/*     */   {
/* 824 */     ClassLoader loader = EnvironmentEntryMetaData.class.getClassLoader();
/* 825 */     Class type = loader.loadClass(entry.getType());
/* 826 */     if (type == String.class)
/*     */     {
/* 828 */       Util.bind(ctx, entry.getName(), entry.getValue());
/*     */     }
/* 830 */     else if (type == Integer.class)
/*     */     {
/* 832 */       Util.bind(ctx, entry.getName(), new Integer(entry.getValue()));
/*     */     }
/* 834 */     else if (type == Long.class)
/*     */     {
/* 836 */       Util.bind(ctx, entry.getName(), new Long(entry.getValue()));
/*     */     }
/* 838 */     else if (type == Double.class)
/*     */     {
/* 840 */       Util.bind(ctx, entry.getName(), new Double(entry.getValue()));
/*     */     }
/* 842 */     else if (type == Float.class)
/*     */     {
/* 844 */       Util.bind(ctx, entry.getName(), new Float(entry.getValue()));
/*     */     }
/* 846 */     else if (type == Byte.class)
/*     */     {
/* 848 */       Util.bind(ctx, entry.getName(), new Byte(entry.getValue()));
/*     */     }
/* 850 */     else if (type == Character.class)
/*     */     {
/* 852 */       Object value = null;
/* 853 */       String input = entry.getValue();
/* 854 */       if ((input == null) || (input.length() == 0))
/*     */       {
/* 856 */         value = new Character('\000');
/*     */       }
/*     */       else
/*     */       {
/* 860 */         value = new Character(input.charAt(0));
/*     */       }
/* 862 */       Util.bind(ctx, entry.getName(), value);
/*     */     }
/* 864 */     else if (type == Short.class)
/*     */     {
/* 866 */       Util.bind(ctx, entry.getName(), new Short(entry.getValue()));
/*     */     }
/* 868 */     else if (type == Boolean.class)
/*     */     {
/* 870 */       Util.bind(ctx, entry.getName(), new Boolean(entry.getValue()));
/*     */     }
/*     */     else
/*     */     {
/* 875 */       Util.bind(ctx, entry.getName(), entry.getValue());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.deployers.AbstractWarDeployment
 * JD-Core Version:    0.6.0
 */