/*     */ package org.jboss.web;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.net.URL;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.jboss.util.threadpool.BasicThreadPoolMBean;
/*     */ 
/*     */ public class WebService extends ServiceMBeanSupport
/*     */   implements WebServiceMBean
/*     */ {
/*  72 */   private WebServer server = new WebServer();
/*     */   private String host;
/*     */ 
/*     */   public URL addClassLoader(ClassLoader cl)
/*     */   {
/*  90 */     return this.server.addClassLoader(cl);
/*     */   }
/*     */ 
/*     */   public void removeClassLoader(ClassLoader cl)
/*     */   {
/*  98 */     this.server.removeClassLoader(cl);
/*     */   }
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 110 */     this.server.setPort(port);
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 120 */     return this.server.getPort();
/*     */   }
/*     */ 
/*     */   public void setHost(String hostname)
/*     */   {
/* 131 */     this.host = ServerConfigUtil.fixRemoteAddress(hostname);
/*     */   }
/*     */ 
/*     */   public String getHost()
/*     */   {
/* 142 */     return this.host;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String address)
/*     */     throws UnknownHostException
/*     */   {
/* 157 */     InetAddress bindAddress = toInetAddress(address);
/* 158 */     this.server.setBindAddress(bindAddress);
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/* 170 */     InetAddress bindAddress = this.server.getBindAddress();
/*     */ 
/* 172 */     if (bindAddress != null) {
/* 173 */       return bindAddress.getHostAddress();
/*     */     }
/* 175 */     return null;
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 190 */     return this.server.getBacklog();
/*     */   }
/*     */ 
/*     */   public void setBacklog(int backlog)
/*     */   {
/* 205 */     this.server.setBacklog(backlog);
/*     */   }
/*     */ 
/*     */   public void setThreadPool(BasicThreadPoolMBean threadPool)
/*     */   {
/* 214 */     this.server.setThreadPool(threadPool);
/*     */   }
/*     */ 
/*     */   public boolean getDownloadServerClasses()
/*     */   {
/* 226 */     return this.server.getDownloadServerClasses();
/*     */   }
/*     */ 
/*     */   public void setDownloadServerClasses(boolean flag)
/*     */   {
/* 234 */     this.server.setDownloadServerClasses(flag);
/*     */   }
/*     */ 
/*     */   public boolean getDownloadResources()
/*     */   {
/* 245 */     return this.server.getDownloadResources();
/*     */   }
/*     */ 
/*     */   public void setDownloadResources(boolean flag)
/*     */   {
/* 253 */     this.server.setDownloadResources(flag);
/*     */   }
/*     */ 
/*     */   public String getCodebase()
/*     */   {
/* 263 */     return System.getProperty("java.rmi.server.codebase");
/*     */   }
/*     */ 
/*     */   protected ObjectName getObjectName(MBeanServer server, ObjectName name)
/*     */     throws MalformedObjectNameException
/*     */   {
/* 269 */     return name == null ? OBJECT_NAME : name;
/*     */   }
/*     */ 
/*     */   protected void createService()
/*     */     throws Exception
/*     */   {
/* 275 */     Properties mimeTypes = new Properties();
/*     */     try
/*     */     {
/* 279 */       mimeTypes.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/jboss/web/mime.types"));
/*     */ 
/* 281 */       Enumeration keys = mimeTypes.keys();
/* 282 */       while (keys.hasMoreElements())
/*     */       {
/* 284 */         String extension = (String)keys.nextElement();
/* 285 */         String type = mimeTypes.getProperty(extension);
/* 286 */         this.server.addMimeType(extension, type);
/*     */       }
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 291 */       this.log.error("Failed to load org/jboss/web/mime.types; ignoring", e);
/*     */     }
/*     */ 
/* 295 */     if (getBindAddress() == null) {
/* 296 */       setBindAddress(System.getProperty("jboss.bind.address"));
/*     */     }
/*     */ 
/* 299 */     if (getHost() == null) {
/* 300 */       setHost(System.getProperty("java.rmi.server.hostname"));
/*     */     }
/*     */ 
/* 303 */     String codebase = getCodebase();
/* 304 */     if (codebase == null)
/*     */     {
/* 306 */       codebase = "http://" + getHost() + ":" + getPort() + "/";
/* 307 */       System.setProperty("java.rmi.server.codebase", codebase);
/*     */     }
/* 309 */     this.log.info("Using RMI server codebase: " + codebase);
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 322 */     this.server.start();
/* 323 */     this.log.debug("Started WebServer with address: " + this.server.getBindAddress() + ":" + getPort());
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 328 */     this.server.stop();
/* 329 */     this.log.debug("Stopped WebServer with address: " + this.server.getBindAddress() + ":" + getPort());
/*     */   }
/*     */ 
/*     */   private InetAddress toInetAddress(String host)
/*     */     throws UnknownHostException
/*     */   {
/* 337 */     if ((host == null) || (host.length() == 0)) {
/* 338 */       return null;
/*     */     }
/* 340 */     return InetAddress.getByName(host);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.WebService
 * JD-Core Version:    0.6.0
 */