/*     */ package org.jboss.web;
/*     */ 
/*     */ import java.net.URL;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.classloading.spi.DelegatingClassLoader;
/*     */ import org.jboss.classloading.spi.RealClassLoader;
/*     */ 
/*     */ public class WebClassLoader extends DelegatingClassLoader
/*     */ {
/*     */   private ObjectName containerName;
/*     */   private URL[] webURLs;
/*     */   private String codebaseString;
/*     */ 
/*     */   public WebClassLoader(ObjectName containerName, RealClassLoader parent)
/*     */   {
/*  74 */     super(parent);
/*  75 */     this.containerName = containerName;
/*     */   }
/*     */ 
/*     */   public String getKey()
/*     */   {
/*  81 */     String className = getClass().getName();
/*  82 */     int dot = className.lastIndexOf('.');
/*  83 */     if (dot >= 0)
/*  84 */       className = className.substring(dot + 1);
/*  85 */     String key = className + '[' + hashCode() + ']';
/*  86 */     return key;
/*     */   }
/*     */ 
/*     */   public ObjectName getContainer()
/*     */   {
/*  92 */     return this.containerName;
/*     */   }
/*     */ 
/*     */   public URL[] getURLs()
/*     */   {
/* 101 */     return this.webURLs;
/*     */   }
/*     */ 
/*     */   public void setWebURLs(URL[] webURLs)
/*     */   {
/* 109 */     this.webURLs = webURLs;
/* 110 */     StringBuffer sb = new StringBuffer();
/* 111 */     for (int i = 0; i < webURLs.length; i++)
/*     */     {
/* 113 */       sb.append(webURLs[i].toString());
/* 114 */       if (i >= webURLs.length - 1)
/*     */         continue;
/* 116 */       sb.append(" ");
/*     */     }
/*     */ 
/* 119 */     this.codebaseString = sb.toString();
/*     */   }
/*     */ 
/*     */   public String getCodebaseString()
/*     */   {
/* 124 */     return this.codebaseString;
/*     */   }
/*     */ 
/*     */   public byte[] getBytes(Class clz)
/*     */   {
/* 139 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.web.WebClassLoader
 * JD-Core Version:    0.6.0
 */