/*    */ package org.jboss.virtual.protocol.vfsfile;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.IOException;
/*    */ import java.net.URL;
/*    */ import java.net.URLConnection;
/*    */ import java.net.URLStreamHandler;
/*    */ import org.jboss.virtual.plugins.vfs.VirtualFileURLConnection;
/*    */ 
/*    */ public class Handler extends URLStreamHandler
/*    */ {
/*    */   protected URLConnection openConnection(URL u)
/*    */     throws IOException
/*    */   {
/* 42 */     String file = u.toString().substring(8);
/* 43 */     URL vfsurl = null;
/*    */ 
/* 45 */     File fp = new File(file);
/*    */     String relative;
/*    */     String relative;
/* 46 */     if (fp.exists())
/*    */     {
/* 48 */       vfsurl = fp.getParentFile().toURL();
/* 49 */       relative = fp.getName();
/*    */     }
/*    */     else
/*    */     {
/* 53 */       File curr = fp;
/* 54 */       relative = fp.getName();
/* 55 */       while ((curr = curr.getParentFile()) != null)
/*    */       {
/* 57 */         if (curr.exists())
/*    */         {
/* 59 */           vfsurl = curr.toURL();
/* 60 */           break;
/*    */         }
/*    */ 
/* 64 */         relative = curr.getName() + "/" + relative;
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 69 */     if (vfsurl == null) {
/* 70 */       throw new IOException("vfsfile does not exist: " + u.toString());
/*    */     }
/* 72 */     return new VirtualFileURLConnection(u, vfsurl, relative);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.protocol.vfsfile.Handler
 * JD-Core Version:    0.6.0
 */