/*    */ package org.jboss.virtual.plugins.vfs.helpers;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import org.jboss.virtual.VirtualFile;
/*    */ import org.jboss.virtual.VirtualFileFilter;
/*    */ 
/*    */ public class SuffixesExcludeFilter
/*    */   implements VirtualFileFilter
/*    */ {
/*    */   private Collection<String> suffixes;
/*    */ 
/*    */   public SuffixesExcludeFilter(Collection<String> suffixes)
/*    */   {
/* 48 */     if (suffixes == null)
/* 49 */       throw new IllegalArgumentException("Null suffixes");
/* 50 */     for (String suffix : suffixes)
/*    */     {
/* 52 */       if (suffix == null)
/* 53 */         throw new IllegalArgumentException("Null suffix in " + suffixes);
/*    */     }
/* 55 */     this.suffixes = suffixes;
/*    */   }
/*    */ 
/*    */   public boolean accepts(VirtualFile file)
/*    */   {
/* 60 */     String name = file.getName();
/* 61 */     for (String suffix : this.suffixes)
/*    */     {
/* 63 */       if (name.endsWith(suffix))
/* 64 */         return false;
/*    */     }
/* 66 */     return true;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter
 * JD-Core Version:    0.6.0
 */