/*     */ package org.jboss.virtual.plugins.vfs.helpers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ 
/*     */ public class SuffixMatchFilter extends AbstractVirtualFileFilterWithAttributes
/*     */ {
/*  41 */   private static Logger log = Logger.getLogger(SuffixMatchFilter.class);
/*     */   private Collection<String> suffixes;
/*     */   private boolean trace;
/*     */ 
/*     */   public SuffixMatchFilter(String suffix)
/*     */   {
/*  55 */     this(suffix, null);
/*     */   }
/*     */ 
/*     */   public SuffixMatchFilter(String suffix, VisitorAttributes attributes)
/*     */   {
/*  68 */     this(Collections.EMPTY_LIST, attributes);
/*  69 */     this.suffixes.add(suffix);
/*  70 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public SuffixMatchFilter(Collection<String> suffixes)
/*     */   {
/*  79 */     this(suffixes, null);
/*     */   }
/*     */ 
/*     */   public SuffixMatchFilter(Collection<String> suffixes, VisitorAttributes attributes)
/*     */   {
/*  89 */     super(attributes == null ? VisitorAttributes.DEFAULT : attributes);
/*  90 */     if (suffixes == null)
/*  91 */       throw new IllegalArgumentException("Null suffixes");
/*  92 */     this.suffixes = new ArrayList();
/*  93 */     this.suffixes.addAll(suffixes);
/*     */   }
/*     */ 
/*     */   public boolean accepts(VirtualFile file)
/*     */   {
/* 103 */     String name = file.getName();
/* 104 */     boolean accepts = false;
/* 105 */     for (String suffix : this.suffixes)
/*     */     {
/* 107 */       if (name.endsWith(suffix))
/*     */       {
/* 109 */         accepts = true;
/* 110 */         break;
/*     */       }
/*     */     }
/* 113 */     if (this.trace)
/* 114 */       log.trace(file + " accepted: " + accepts);
/* 115 */     return accepts;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter
 * JD-Core Version:    0.6.0
 */