/*     */ package org.jboss.virtual.plugins.vfs.helpers;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class PathTokenizer
/*     */ {
/*     */   private static final String REVERSE_PATH = "..";
/*     */ 
/*     */   protected static String getRemainingPath(String[] tokens, int i, int end)
/*     */   {
/*  56 */     if (tokens == null)
/*  57 */       throw new IllegalArgumentException("Null tokens");
/*  58 */     if ((i < 0) || (i >= end)) {
/*  59 */       throw new IllegalArgumentException("i is not in the range of tokens: 0-" + (end - 1));
/*     */     }
/*  61 */     if (i == end - 1) {
/*  62 */       return tokens[(end - 1)];
/*     */     }
/*  64 */     StringBuilder buffer = new StringBuilder();
/*  65 */     for (; i < end - 1; i++)
/*     */     {
/*  67 */       buffer.append(tokens[i]);
/*  68 */       buffer.append("/");
/*     */     }
/*  70 */     buffer.append(tokens[(end - 1)]);
/*  71 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public static String[] getTokens(String path)
/*     */   {
/*  83 */     if (path == null) {
/*  84 */       throw new IllegalArgumentException("Null path");
/*     */     }
/*  86 */     StringTokenizer tokenizer = new StringTokenizer(path, "/");
/*  87 */     int count = tokenizer.countTokens();
/*  88 */     if (count == 0) {
/*  89 */       return null;
/*     */     }
/*  91 */     String[] tokens = new String[count];
/*  92 */     int i = 0;
/*  93 */     while (tokenizer.hasMoreTokens())
/*     */     {
/*  95 */       String token = tokenizer.nextToken();
/*     */ 
/*  97 */       if ("".equals(token))
/*  98 */         throw new IllegalArgumentException("A path element is empty: " + path);
/*  99 */       if (".".equals(token)) {
/* 100 */         throw new IllegalArgumentException("Single . in path is not allowed: " + path);
/*     */       }
/* 102 */       tokens[(i++)] = token;
/*     */     }
/* 104 */     return tokens;
/*     */   }
/*     */ 
/*     */   public static String getRemainingPath(String[] tokens, int i)
/*     */   {
/* 117 */     if (tokens == null) {
/* 118 */       throw new IllegalArgumentException("Null tokens");
/*     */     }
/* 120 */     return getRemainingPath(tokens, i, tokens.length);
/*     */   }
/*     */ 
/*     */   public static String applyReversePaths(String path)
/*     */     throws IOException
/*     */   {
/* 132 */     String[] tokens = getTokens(path);
/* 133 */     if (tokens == null) {
/* 134 */       return null;
/*     */     }
/* 136 */     int i = 0;
/* 137 */     for (int j = 0; j < tokens.length; j++)
/*     */     {
/* 139 */       if (isReverseToken(tokens[j]))
/* 140 */         i--;
/*     */       else {
/* 142 */         tokens[(i++)] = tokens[j];
/*     */       }
/* 144 */       if (i < 0)
/* 145 */         throw new IOException("Using reverse path on top path: " + path);
/*     */     }
/* 147 */     return getRemainingPath(tokens, 0, i);
/*     */   }
/*     */ 
/*     */   public static boolean isReverseToken(String token)
/*     */   {
/* 158 */     return "..".equals(token);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.helpers.PathTokenizer
 * JD-Core Version:    0.6.0
 */