/*     */ package org.jboss.virtual.plugins.vfs.helpers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VirtualFileFilterWithAttributes;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ 
/*     */ public class FilterVirtualFileVisitor extends AbstractVirtualFileVisitor
/*     */ {
/*     */   private final VirtualFileFilter filter;
/*     */   private List<VirtualFile> matched;
/*     */ 
/*     */   private static VisitorAttributes checkAttributes(VirtualFileFilter filter, VisitorAttributes attributes)
/*     */   {
/*  57 */     if (filter == null) {
/*  58 */       throw new IllegalArgumentException("Null filter");
/*     */     }
/*     */ 
/*  61 */     if (attributes != null) {
/*  62 */       return attributes;
/*     */     }
/*     */ 
/*  65 */     if ((filter instanceof VirtualFileFilterWithAttributes)) {
/*  66 */       return ((VirtualFileFilterWithAttributes)filter).getAttributes();
/*     */     }
/*     */ 
/*  69 */     return null;
/*     */   }
/*     */ 
/*     */   public FilterVirtualFileVisitor(VirtualFileFilter filter)
/*     */   {
/*  80 */     this(filter, null);
/*     */   }
/*     */ 
/*     */   public FilterVirtualFileVisitor(VirtualFileFilter filter, VisitorAttributes attributes)
/*     */   {
/*  92 */     super(checkAttributes(filter, attributes));
/*  93 */     this.filter = filter;
/*     */   }
/*     */ 
/*     */   public List<VirtualFile> getMatched()
/*     */   {
/* 103 */     if (this.matched == null) {
/* 104 */       return Collections.emptyList();
/*     */     }
/* 106 */     return this.matched;
/*     */   }
/*     */ 
/*     */   public void visit(VirtualFile virtualFile)
/*     */   {
/* 111 */     if (this.filter.accepts(virtualFile))
/*     */     {
/* 113 */       if (this.matched == null)
/* 114 */         this.matched = new ArrayList();
/* 115 */       this.matched.add(virtualFile);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor
 * JD-Core Version:    0.6.0
 */