/*     */ package org.jboss.virtual.plugins.vfs.helpers;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ 
/*     */ public class ExtensibleFilter
/*     */   implements VirtualFileFilter
/*     */ {
/*  51 */   private static final Comparator<String> reverseComparator = new Comparator()
/*     */   {
/*     */     public int compare(String o1, String o2)
/*     */     {
/*  55 */       int idx1 = o1.length();
/*  56 */       int idx2 = o2.length();
/*  57 */       int comp = 0;
/*     */ 
/*  59 */       while ((comp == 0) && (idx1 > 0) && (idx2 > 0)) {
/*  60 */         idx1--; idx2--; comp = o1.charAt(idx1) - o2.charAt(idx2);
/*     */       }
/*  62 */       return comp == 0 ? idx1 - idx2 : comp;
/*     */     }
/*  51 */   };
/*     */ 
/*  67 */   private static final String[] DEFAULT_PREFIXES = { "#", "%", ",", ".", "_$" };
/*     */ 
/*  71 */   private static final String[] DEFAULT_SUFFIXES = { "#", "$", "%", "~", ",v", ".BAK", ".bak", ".old", ".orig", ".tmp", ".rej", ".sh" };
/*     */ 
/*  75 */   private static final String[] DEFAULT_MATCHES = { ".make.state", ".nse_depinfo", "CVS", "CVS.admin", "RCS", "RCSLOG", "SCCS", "TAGS", "core", "tags" };
/*     */   private ArrayList<String> suffixes;
/*     */   private ArrayList<String> prefixes;
/*     */   private ArrayList<String> matches;
/*     */ 
/*     */   public ExtensibleFilter()
/*     */   {
/*  91 */     this(DEFAULT_MATCHES, DEFAULT_PREFIXES, DEFAULT_SUFFIXES);
/*     */   }
/*     */ 
/*     */   public ExtensibleFilter(String[] matches, String[] prefixes, String[] suffixes)
/*     */   {
/* 105 */     if (matches == null)
/* 106 */       matches = DEFAULT_MATCHES;
/* 107 */     Arrays.sort(matches);
/* 108 */     this.matches = new ArrayList(Arrays.asList(matches));
/*     */ 
/* 110 */     if (prefixes == null)
/* 111 */       prefixes = DEFAULT_PREFIXES;
/* 112 */     Arrays.sort(prefixes);
/* 113 */     this.prefixes = new ArrayList(Arrays.asList(prefixes));
/*     */ 
/* 115 */     if (suffixes == null)
/* 116 */       suffixes = DEFAULT_SUFFIXES;
/* 117 */     Arrays.sort(suffixes, reverseComparator);
/* 118 */     this.suffixes = new ArrayList(Arrays.asList(suffixes));
/*     */   }
/*     */ 
/*     */   public void addPrefix(String prefix)
/*     */   {
/* 123 */     this.prefixes.add(prefix);
/* 124 */     Collections.sort(this.prefixes);
/*     */   }
/*     */ 
/*     */   public void addPrefixes(String[] prefixes) {
/* 128 */     this.prefixes.addAll(Arrays.asList(prefixes));
/* 129 */     Collections.sort(this.prefixes);
/*     */   }
/*     */ 
/*     */   public void delPrefix(String prefix)
/*     */   {
/* 134 */     this.prefixes.remove(prefix);
/*     */   }
/*     */ 
/*     */   public void delPrefixes(String[] prefixes) {
/* 138 */     this.prefixes.removeAll(Arrays.asList(prefixes));
/* 139 */     Collections.sort(this.prefixes);
/*     */   }
/*     */ 
/*     */   public void addSuffix(String suffix)
/*     */   {
/* 144 */     this.suffixes.add(suffix);
/* 145 */     Collections.sort(this.suffixes, reverseComparator);
/*     */   }
/*     */ 
/*     */   public void addSuffixes(String[] suffixes) {
/* 149 */     this.suffixes.addAll(Arrays.asList(suffixes));
/* 150 */     Collections.sort(this.suffixes, reverseComparator);
/*     */   }
/*     */ 
/*     */   public void delSuffix(String suffix)
/*     */   {
/* 155 */     this.suffixes.remove(suffix);
/*     */   }
/*     */ 
/*     */   public void delSuffixes(String[] suffixes) {
/* 159 */     this.suffixes.removeAll(Arrays.asList(suffixes));
/* 160 */     Collections.sort(this.suffixes, reverseComparator);
/*     */   }
/*     */ 
/*     */   public String[] getSuffixes()
/*     */   {
/* 165 */     String[] tmp = new String[this.suffixes.size()];
/* 166 */     this.suffixes.toArray(tmp);
/* 167 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setSuffixes(String[] suffixes) {
/* 171 */     Arrays.sort(suffixes, reverseComparator);
/* 172 */     this.suffixes.clear();
/* 173 */     this.suffixes.addAll(Arrays.asList(suffixes));
/*     */   }
/*     */ 
/*     */   public String[] getPrefixes()
/*     */   {
/* 178 */     String[] tmp = new String[this.prefixes.size()];
/* 179 */     this.prefixes.toArray(tmp);
/* 180 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setPrefixes(String[] prefixes) {
/* 184 */     Arrays.sort(prefixes);
/* 185 */     this.prefixes.clear();
/* 186 */     this.prefixes.addAll(Arrays.asList(prefixes));
/*     */   }
/*     */ 
/*     */   public String[] getMatches()
/*     */   {
/* 191 */     String[] tmp = new String[this.matches.size()];
/* 192 */     this.matches.toArray(tmp);
/* 193 */     return tmp;
/*     */   }
/*     */ 
/*     */   public void setMatches(String[] matches) {
/* 197 */     Arrays.sort(matches);
/* 198 */     this.matches.clear();
/* 199 */     this.matches.addAll(Arrays.asList(matches));
/*     */   }
/*     */ 
/*     */   public boolean accepts(VirtualFile file)
/*     */   {
/* 213 */     String name = file.getName();
/*     */ 
/* 215 */     int index = Collections.binarySearch(this.matches, name);
/* 216 */     if (index >= 0) {
/* 217 */       return false;
/*     */     }
/*     */ 
/* 220 */     index = Collections.binarySearch(this.prefixes, name);
/* 221 */     if (index >= 0)
/* 222 */       return false;
/* 223 */     if (index < -1)
/*     */     {
/* 226 */       int firstLessIndex = -2 - index;
/* 227 */       String prefix = (String)this.prefixes.get(firstLessIndex);
/*     */ 
/* 229 */       if (name.startsWith(prefix)) {
/* 230 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 234 */     index = Collections.binarySearch(this.suffixes, name, reverseComparator);
/* 235 */     if (index >= 0)
/* 236 */       return false;
/* 237 */     if (index < -1)
/*     */     {
/* 240 */       int firstLessIndex = -2 - index;
/* 241 */       String suffix = (String)this.suffixes.get(firstLessIndex);
/*     */ 
/* 243 */       if (name.endsWith(suffix)) {
/* 244 */         return false;
/*     */       }
/*     */     }
/*     */ 
/* 248 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.vfs.helpers.ExtensibleFilter
 * JD-Core Version:    0.6.0
 */