/*     */ package org.jboss.virtual.plugins.context.vfs;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ @Assembled
/*     */ public class ByteArrayHandler extends AbstractVirtualFileHandler
/*     */ {
/*     */   private byte[] bytes;
/*  47 */   private final long lastModified = System.currentTimeMillis();
/*     */ 
/*     */   public ByteArrayHandler(AssembledContext context, VirtualFileHandler parent, String name, byte[] bytes)
/*     */     throws IOException
/*     */   {
/*  52 */     super(context, parent, name);
/*  53 */     this.bytes = bytes;
/*  54 */     this.vfsUrl = new URL("vfs", context.getName(), -1, getPathName(), new AssembledUrlStreamHandler(context));
/*     */   }
/*     */ 
/*     */   public URL toURL()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/*  61 */     return this.vfsUrl;
/*     */   }
/*     */ 
/*     */   public URI toURI() throws URISyntaxException
/*     */   {
/*  66 */     return this.vfsUrl.toURI();
/*     */   }
/*     */ 
/*     */   public long getLastModified() throws IOException
/*     */   {
/*  71 */     return this.lastModified;
/*     */   }
/*     */ 
/*     */   public long getSize() throws IOException
/*     */   {
/*  76 */     return this.bytes.length;
/*     */   }
/*     */ 
/*     */   public boolean exists() throws IOException
/*     */   {
/*  81 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isLeaf() throws IOException
/*     */   {
/*  86 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isHidden() throws IOException
/*     */   {
/*  91 */     return false;
/*     */   }
/*     */ 
/*     */   public InputStream openStream() throws IOException
/*     */   {
/*  96 */     return new ByteArrayInputStream(this.bytes);
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 101 */     throw new IOException("File cannot have children");
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 106 */     throw new IOException("File cannot have children");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.vfs.ByteArrayHandler
 * JD-Core Version:    0.6.0
 */