/*     */ package org.jboss.virtual.plugins.context.vfs;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import org.jboss.virtual.VFS;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.VirtualFileFilter;
/*     */ import org.jboss.virtual.VisitorAttributes;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
/*     */ import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class AssembledDirectory extends VirtualFile
/*     */ {
/*     */   private AssembledDirectoryHandler directory;
/*     */ 
/*     */   public AssembledDirectory(VirtualFileHandler handler)
/*     */   {
/*  51 */     super(handler);
/*  52 */     this.directory = ((AssembledDirectoryHandler)handler);
/*     */   }
/*     */ 
/*     */   public void addClass(Class clazz)
/*     */   {
/*  66 */     addClass(clazz.getName(), clazz.getClassLoader());
/*     */   }
/*     */ 
/*     */   public void addClass(String className)
/*     */   {
/*  80 */     addClass(className, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public void addClass(String className, ClassLoader loader)
/*     */   {
/*  95 */     String resource = className.replace('.', '/') + ".class";
/*  96 */     URL url = loader.getResource(resource);
/*  97 */     if (url == null) throw new RuntimeException("Could not find resource: " + resource);
/*  98 */     AssembledDirectory p = mkdirs(resource);
/*  99 */     p.addResource(resource, loader);
/*     */   }
/*     */ 
/*     */   public AssembledDirectory mkdirs(String path)
/*     */   {
/* 110 */     String[] pkgs = path.split("/");
/* 111 */     AssembledDirectoryHandler dir = this.directory;
/* 112 */     for (int i = 0; i < pkgs.length - 1; i++)
/*     */     {
/* 114 */       AssembledDirectoryHandler next = (AssembledDirectoryHandler)dir.getChild(pkgs[i]);
/* 115 */       if (next == null)
/*     */       {
/*     */         try
/*     */         {
/* 119 */           next = new AssembledDirectoryHandler((AssembledContext)dir.getVFSContext(), dir, pkgs[i]);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 123 */           throw new RuntimeException(e);
/*     */         }
/* 125 */         dir.addChild(next);
/*     */       }
/* 127 */       dir = next;
/*     */     }
/* 129 */     AssembledDirectory p = (AssembledDirectory)dir.getVirtualFile();
/* 130 */     return p;
/*     */   }
/*     */ 
/*     */   public void addResources(Class baseResource, String[] includes, String[] excludes)
/*     */   {
/* 149 */     String resource = baseResource.getName().replace('.', '/') + ".class";
/* 150 */     addResources(resource, includes, excludes);
/*     */   }
/*     */ 
/*     */   public void addResources(String baseResource, String[] includes, String[] excludes)
/*     */   {
/* 169 */     addResources(baseResource, includes, excludes, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public void addResources(String baseResource, String[] includes, String[] excludes, ClassLoader loader)
/*     */   {
/* 189 */     URL url = loader.getResource(baseResource);
/* 190 */     if (url == null) throw new RuntimeException("Could not find baseResource: " + baseResource);
/* 191 */     String urlString = url.toString();
/* 192 */     int idx = urlString.lastIndexOf(baseResource);
/* 193 */     urlString = urlString.substring(0, idx);
/*     */     try
/*     */     {
/* 196 */       url = new URL(urlString);
/* 197 */       VirtualFile parent = VFS.getRoot(url);
/*     */ 
/* 199 */       VisitorAttributes va = new VisitorAttributes();
/* 200 */       va.setLeavesOnly(true);
/* 201 */       SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
/* 202 */       va.setRecurseFilter(noJars);
/*     */ 
/* 204 */       VirtualFileFilter filter = new VirtualFileFilter(includes, excludes)
/*     */       {
/*     */         public boolean accepts(VirtualFile file)
/*     */         {
/* 209 */           boolean matched = false;
/* 210 */           String path = file.getPathName();
/* 211 */           for (String include : this.val$includes)
/*     */           {
/* 213 */             if (!AssembledDirectory.antMatch(path, include))
/*     */               continue;
/* 215 */             matched = true;
/* 216 */             break;
/*     */           }
/*     */ 
/* 219 */           if (!matched) return false;
/* 220 */           if (this.val$excludes != null)
/*     */           {
/* 222 */             for (String exclude : this.val$excludes)
/*     */             {
/* 224 */               if (AssembledDirectory.antMatch(path, exclude)) return false;
/*     */             }
/*     */           }
/* 227 */           return true;
/*     */         }
/*     */       };
/* 232 */       FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
/* 233 */       parent.visit(visitor);
/* 234 */       List files = visitor.getMatched();
/* 235 */       for (VirtualFile vf : files)
/*     */       {
/* 237 */         mkdirs(vf.getPathName()).addChild(vf);
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 242 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Pattern getPattern(String matcher)
/*     */   {
/* 254 */     matcher = matcher.replace(".", "\\.");
/* 255 */     matcher = matcher.replace("*", ".*");
/* 256 */     matcher = matcher.replace("?", ".{1}");
/* 257 */     return Pattern.compile(matcher);
/*     */   }
/*     */ 
/*     */   public static boolean antMatch(String path, String expression)
/*     */   {
/* 270 */     if (path.startsWith("/")) path = path.substring(1);
/* 271 */     if (expression.endsWith("/")) expression = expression + "**";
/* 272 */     String[] paths = path.split("/");
/* 273 */     String[] expressions = expression.split("/");
/*     */ 
/* 275 */     int x = 0; int p = 0;
/* 276 */     Pattern pattern = getPattern(expressions[0]);
/*     */ 
/* 278 */     for (p = 0; (p < paths.length) && (x < expressions.length); p++)
/*     */     {
/* 280 */       if (expressions[x].equals("**"))
/*     */       {
/*     */         do
/*     */         {
/* 284 */           x++;
/* 285 */         }while ((x < expressions.length) && (expressions[x].equals("**")));
/* 286 */         if (x == expressions.length) return true;
/* 287 */         pattern = getPattern(expressions[x]);
/*     */       }
/* 289 */       String element = paths[p];
/* 290 */       if (pattern.matcher(element).matches())
/*     */       {
/* 292 */         x++;
/* 293 */         if (x >= expressions.length)
/*     */           continue;
/* 295 */         pattern = getPattern(expressions[x]);
/*     */       }
/* 298 */       else if ((x <= 0) || (!expressions[(x - 1)].equals("**")))
/*     */       {
/* 300 */         return false;
/*     */       }
/*     */     }
/* 303 */     if (p < paths.length) return false;
/* 304 */     return x >= expressions.length;
/*     */   }
/*     */ 
/*     */   public VirtualFile addChild(VirtualFile vf)
/*     */   {
/* 315 */     return this.directory.addChild(vf.getHandler()).getVirtualFile();
/*     */   }
/*     */ 
/*     */   public VirtualFile addChild(VirtualFile vf, String newName)
/*     */   {
/*     */     try
/*     */     {
/* 329 */       AssembledFileHandler handler = new AssembledFileHandler((AssembledContext)this.directory.getVFSContext(), this.directory, newName, vf.getHandler());
/* 330 */       this.directory.addChild(handler);
/* 331 */       return handler.getVirtualFile();
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 335 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public VirtualFile addResource(String resource)
/*     */   {
/* 349 */     return addResource(resource, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public VirtualFile addResource(String resource, String newName)
/*     */   {
/* 363 */     return addResource(resource, Thread.currentThread().getContextClassLoader(), newName);
/*     */   }
/*     */ 
/*     */   public VirtualFile addResource(String resource, ClassLoader loader)
/*     */   {
/* 377 */     URL url = loader.getResource(resource);
/* 378 */     if (url == null) throw new RuntimeException("Could not find resource: " + resource);
/*     */ 
/* 380 */     return addResource(url);
/*     */   }
/*     */ 
/*     */   public VirtualFile addResource(URL url)
/*     */   {
/*     */     try
/*     */     {
/* 392 */       VirtualFile vf = VFS.getRoot(url);
/* 393 */       return addChild(vf);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 397 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public VirtualFile addResource(String resource, ClassLoader loader, String newName)
/*     */   {
/* 413 */     URL url = loader.getResource(resource);
/* 414 */     if (url == null) throw new RuntimeException("Could not find resource: " + resource);
/*     */     try
/*     */     {
/* 417 */       VirtualFile vf = VFS.getRoot(url);
/* 418 */       return addChild(vf, newName);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 422 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public VirtualFile addBytes(byte[] bytes, String name)
/*     */   {
/* 436 */     ByteArrayHandler handler = null;
/*     */     try
/*     */     {
/* 439 */       handler = new ByteArrayHandler((AssembledContext)this.directory.getVFSContext(), this.directory, name, bytes);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 443 */       throw new RuntimeException(e);
/*     */     }
/* 445 */     this.directory.addChild(handler);
/* 446 */     return handler.getVirtualFile();
/*     */   }
/*     */ 
/*     */   public AssembledDirectory mkdir(String name)
/*     */   {
/* 457 */     AssembledDirectoryHandler handler = null;
/*     */     try
/*     */     {
/* 460 */       handler = new AssembledDirectoryHandler((AssembledContext)this.directory.getVFSContext(), this.directory, name);
/* 461 */       this.directory.addChild(handler);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 465 */       throw new RuntimeException(e);
/*     */     }
/* 467 */     return new AssembledDirectory(handler);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.vfs.AssembledDirectory
 * JD-Core Version:    0.6.0
 */