/*     */ package org.jboss.virtual.plugins.context.memory;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.virtual.plugins.context.AbstractURLHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class MemoryContextHandler extends AbstractURLHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  54 */   private Map<String, MemoryContextHandler> entryMap = Collections.emptyMap();
/*     */   private byte[] contents;
/*     */ 
/*     */   public MemoryContextHandler(VFSContext context, VirtualFileHandler parent, URL url, String name)
/*     */   {
/*  60 */     super(context, parent, url, name);
/*  61 */     if ((parent != null) && ((parent instanceof MemoryContextHandler)))
/*     */     {
/*  63 */       ((MemoryContextHandler)parent).addChild(name, this);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void addChild(String name, MemoryContextHandler child)
/*     */   {
/*  69 */     if (this.entryMap == Collections.EMPTY_MAP)
/*     */     {
/*  71 */       this.entryMap = new LinkedHashMap();
/*     */     }
/*  73 */     this.entryMap.put(name, child);
/*     */   }
/*     */ 
/*     */   boolean deleteChild(MemoryContextHandler child)
/*     */   {
/*  78 */     return this.entryMap.remove(child.getName()) != null;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/*  83 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   MemoryContextHandler getDirectChild(String name)
/*     */   {
/*  88 */     return (MemoryContextHandler)this.entryMap.get(name);
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/*  93 */     return new ArrayList(this.entryMap.values());
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */   {
/*  98 */     return this.contents != null;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createChildHandler(String name)
/*     */     throws IOException
/*     */   {
/* 106 */     VirtualFileHandler child = (VirtualFileHandler)this.entryMap.get(name);
/* 107 */     if (child == null)
/* 108 */       throw new FileNotFoundException(this + " has no child: " + name);
/* 109 */     return child;
/*     */   }
/*     */ 
/*     */   public boolean exists()
/*     */     throws IOException
/*     */   {
/* 115 */     return true;
/*     */   }
/*     */ 
/*     */   byte[] getContents()
/*     */   {
/* 120 */     return this.contents;
/*     */   }
/*     */ 
/*     */   public void setContents(byte[] contents)
/*     */   {
/* 125 */     if (this.entryMap.size() > 0)
/*     */     {
/* 127 */       throw new RuntimeException("Cannot set contents for non-leaf node");
/*     */     }
/* 129 */     initCacheLastModified();
/* 130 */     this.contents = contents;
/*     */   }
/*     */ 
/*     */   protected void initCacheLastModified()
/*     */   {
/* 136 */     this.cachedLastModified = System.currentTimeMillis();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */     throws IOException
/*     */   {
/* 142 */     if (this.contents != null)
/*     */     {
/* 144 */       return this.contents.length;
/*     */     }
/* 146 */     return 0L;
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */     throws IOException
/*     */   {
/* 152 */     return this.cachedLastModified;
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 158 */     if (this.contents != null)
/*     */     {
/* 160 */       return new ByteArrayInputStream(this.contents);
/*     */     }
/* 162 */     return new ByteArrayInputStream(new byte[0]);
/*     */   }
/*     */ 
/*     */   public URL toVfsUrl()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/* 168 */     if (this.vfsUrl == null)
/*     */     {
/* 170 */       if (isLeaf())
/*     */       {
/* 172 */         this.vfsUrl = getURL();
/*     */       }
/*     */       else
/*     */       {
/* 176 */         String vfsString = getURL().toString();
/* 177 */         if (!vfsString.endsWith("/"))
/* 178 */           this.vfsUrl = new URL(vfsString + "/");
/*     */       }
/*     */     }
/* 181 */     return this.vfsUrl;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.memory.MemoryContextHandler
 * JD-Core Version:    0.6.0
 */