/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.jar.JarEntry;
/*     */ import java.util.jar.JarFile;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class NoCopyNestedJarHandler extends AbstractJarHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient JarEntry entry;
/*     */   private NestedJarFromStream njar;
/*     */ 
/*     */   public NoCopyNestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL url)
/*     */     throws IOException
/*     */   {
/*  63 */     super(context, parent, url, getEntryName(entry));
/*     */     try
/*     */     {
/*  68 */       InputStream is = parentJar.getInputStream(entry);
/*     */       ZipInputStream jis;
/*     */       ZipInputStream jis;
/*  70 */       if ((is instanceof ZipInputStream))
/*     */       {
/*  72 */         jis = (ZipInputStream)is;
/*     */       }
/*     */       else
/*     */       {
/*  76 */         jis = new ZipInputStream(is);
/*     */       }
/*  78 */       this.njar = new NestedJarFromStream(context, parent, jis, url, entry);
/*     */     }
/*     */     catch (IOException original)
/*     */     {
/*  83 */       IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
/*  84 */       e.setStackTrace(original.getStackTrace());
/*  85 */       throw e;
/*     */     }
/*     */ 
/*  88 */     this.entry = entry;
/*     */   }
/*     */ 
/*     */   protected JarEntry getEntry()
/*     */   {
/*  98 */     checkClosed();
/*  99 */     return this.entry;
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */     throws IOException
/*     */   {
/* 105 */     return getEntry().getTime();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */     throws IOException
/*     */   {
/* 111 */     return getEntry().getSize();
/*     */   }
/*     */ 
/*     */   public InputStream openStream()
/*     */     throws IOException
/*     */   {
/* 117 */     return getJar().getInputStream(getEntry());
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path)
/*     */     throws IOException
/*     */   {
/* 123 */     return this.njar.findChild(path);
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors)
/*     */     throws IOException
/*     */   {
/* 129 */     return super.getChildren(ignoreErrors);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.NoCopyNestedJarHandler
 * JD-Core Version:    0.6.0
 */