/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.CopyOnWriteArraySet;
/*     */ 
/*     */ public class JarUtils
/*     */ {
/*  38 */   private static Set<String> jarSuffixes = new CopyOnWriteArraySet();
/*     */ 
/*     */   public static void setJarSuffixes(Set<String> suffixes)
/*     */   {
/*  61 */     if (suffixes == null)
/*  62 */       throw new IllegalArgumentException("Null suffix");
/*  63 */     jarSuffixes = suffixes;
/*     */   }
/*     */ 
/*     */   public static boolean addJarSuffix(String suffix)
/*     */   {
/*  75 */     if (suffix == null)
/*  76 */       throw new IllegalArgumentException("Null suffix");
/*  77 */     return jarSuffixes.add(suffix);
/*     */   }
/*     */ 
/*     */   public static boolean removeJarSuffix(String suffix)
/*     */   {
/*  89 */     if (suffix == null)
/*  90 */       throw new IllegalArgumentException("Null suffix");
/*  91 */     return jarSuffixes.remove(suffix);
/*     */   }
/*     */ 
/*     */   public static Set<String> getSuffixes()
/*     */   {
/* 101 */     return jarSuffixes;
/*     */   }
/*     */ 
/*     */   public static void clearSuffixes()
/*     */   {
/* 110 */     jarSuffixes.clear();
/*     */   }
/*     */ 
/*     */   public static boolean isArchive(String name)
/*     */   {
/* 129 */     if (name == null) {
/* 130 */       throw new IllegalArgumentException("Null name");
/*     */     }
/* 132 */     int index = name.lastIndexOf('.');
/* 133 */     if (index == -1)
/* 134 */       return false;
/* 135 */     String suffix = name.substring(index);
/* 136 */     return jarSuffixes.contains(suffix);
/*     */   }
/*     */ 
/*     */   public static URL createJarURL(URL url)
/*     */     throws MalformedURLException
/*     */   {
/* 149 */     if (url == null)
/* 150 */       throw new IllegalArgumentException("Null url");
/* 151 */     return new URL("jar:" + url + "!/");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  43 */     jarSuffixes.add(".zip");
/*  44 */     jarSuffixes.add(".ear");
/*  45 */     jarSuffixes.add(".jar");
/*  46 */     jarSuffixes.add(".rar");
/*  47 */     jarSuffixes.add(".war");
/*  48 */     jarSuffixes.add(".sar");
/*  49 */     jarSuffixes.add(".har");
/*  50 */     jarSuffixes.add(".aop");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.JarUtils
 * JD-Core Version:    0.6.0
 */