/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.net.JarURLConnection;
/*     */ import java.net.URL;
/*     */ import java.util.jar.JarFile;
/*     */ import org.jboss.virtual.spi.VFSContext;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class JarHandler extends AbstractJarHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */ 
/*     */   public JarHandler(VFSContext context, VirtualFileHandler parent, URL url, String name)
/*     */     throws IOException
/*     */   {
/*  57 */     super(context, parent, url, name);
/*  58 */     this.vfsUrl = new URL("vfs" + url.toString());
/*     */     try
/*     */     {
/*  62 */       JarURLConnection connection = (JarURLConnection)url.openConnection();
/*  63 */       initJarFile(connection.getJarFile());
/*     */     }
/*     */     catch (IOException original)
/*     */     {
/*  68 */       IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
/*  69 */       e.setStackTrace(original.getStackTrace());
/*  70 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public JarHandler(VFSContext context, VirtualFileHandler parent, File file, URL url, String name) throws IOException
/*     */   {
/*  76 */     super(context, parent, url, name);
/*  77 */     this.vfsUrl = new URL("vfs" + url.toString());
/*     */     try
/*     */     {
/*  81 */       initJarFile(new JarFile(file));
/*     */     }
/*     */     catch (IOException original)
/*     */     {
/*  86 */       IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
/*  87 */       e.setStackTrace(original.getStackTrace());
/*  88 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 102 */     JarFile parentJar = super.getJar();
/*     */ 
/* 104 */     initJarFile(parentJar);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.JarHandler
 * JD-Core Version:    0.6.0
 */