/*     */ package org.jboss.virtual.plugins.context.jar;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.plugins.context.AbstractVFSContext;
/*     */ import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class JarContext extends AbstractVFSContext
/*     */ {
/*     */   private final VirtualFileHandler root;
/*     */   private final VirtualFile rootFile;
/*     */ 
/*     */   public JarContext(URL rootURL)
/*     */     throws IOException, URISyntaxException
/*     */   {
/*  57 */     super(rootURL);
/*  58 */     this.root = createVirtualFileHandler(null, rootURL);
/*  59 */     this.rootFile = this.root.getVirtualFile();
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler getRoot() throws IOException
/*     */   {
/*  64 */     return this.root;
/*     */   }
/*     */ 
/*     */   protected VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, URL url)
/*     */     throws IOException
/*     */   {
/*  78 */     if (url == null) {
/*  79 */       throw new IllegalArgumentException("Null url");
/*     */     }
/*  81 */     String urlStr = url.toString();
/*  82 */     String jarName = extractJarName(urlStr);
/*  83 */     String entryPath = urlStr;
/*  84 */     entryPath = entryPath(entryPath);
/*  85 */     JarHandler jar = new JarHandler(this, parent, url, jarName);
/*  86 */     if (entryPath == null) return jar;
/*     */ 
/*  88 */     AbstractVirtualFileHandler result = (AbstractVirtualFileHandler)jar.findChild(entryPath);
/*  89 */     result.setPathName("");
/*  90 */     return result;
/*     */   }
/*     */ 
/*     */   public static String entryPath(String entryName)
/*     */   {
/*  96 */     int index = entryName.indexOf("!/");
/*  97 */     if (index != -1)
/*     */     {
/*  99 */       entryName = entryName.substring(index + 2);
/*     */     }
/*     */     else
/*     */     {
/* 103 */       entryName = null;
/*     */     }
/* 105 */     if (entryName.trim().equals("")) return null;
/*     */ 
/* 107 */     return entryName;
/*     */   }
/*     */ 
/*     */   public static String extractJarName(String urlStr)
/*     */   {
/* 112 */     String jarName = urlStr;
/* 113 */     int index = jarName.indexOf('!');
/* 114 */     if (index != -1)
/* 115 */       jarName = jarName.substring(0, index);
/* 116 */     index = jarName.lastIndexOf('/');
/* 117 */     if ((index != -1) && (index < jarName.length() - 1))
/* 118 */       jarName = jarName.substring(index + 1);
/* 119 */     return jarName;
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */     throws Throwable
/*     */   {
/* 125 */     if (this.rootFile != null)
/* 126 */       this.rootFile.close();
/* 127 */     super.finalize();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.jar.JarContext
 * JD-Core Version:    0.6.0
 */