/*    */ package org.jboss.virtual.plugins.context.file;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.net.MalformedURLException;
/*    */ import java.net.URI;
/*    */ import java.net.URISyntaxException;
/*    */ import java.net.URL;
/*    */ import org.jboss.virtual.plugins.context.AbstractContextFactory;
/*    */ import org.jboss.virtual.spi.VFSContext;
/*    */ 
/*    */ public class FileSystemContextFactory extends AbstractContextFactory
/*    */ {
/*    */   public FileSystemContextFactory()
/*    */   {
/* 44 */     super(new String[] { "file", "vfsfile" });
/*    */   }
/*    */ 
/*    */   public VFSContext getVFS(URL root) throws IOException {
/*    */     MalformedURLException ex;
/*    */     try {
/* 51 */       return new FileSystemContext(fromVFS(root));
/*    */     }
/*    */     catch (URISyntaxException e)
/*    */     {
/* 55 */       ex = new MalformedURLException("non-URI compliant URL");
/* 56 */       ex.initCause(e);
/* 57 */     }throw ex;
/*    */   }
/*    */ 
/*    */   public VFSContext getVFS(URI root) throws IOException
/*    */   {
/*    */     MalformedURLException ex;
/*    */     try {
/* 65 */       return new FileSystemContext(fromVFS(root));
/*    */     }
/*    */     catch (URISyntaxException e)
/*    */     {
/* 69 */       ex = new MalformedURLException("non-URI compliant URI");
/* 70 */       ex.initCause(e);
/* 71 */     }throw ex;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.file.FileSystemContextFactory
 * JD-Core Version:    0.6.0
 */