/*     */ package org.jboss.virtual.plugins.context.file;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.VFSUtils;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.jboss.virtual.plugins.context.AbstractVFSContext;
/*     */ import org.jboss.virtual.plugins.context.jar.JarHandler;
/*     */ import org.jboss.virtual.plugins.context.jar.JarUtils;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class FileSystemContext extends AbstractVFSContext
/*     */ {
/*     */   private final VirtualFileHandler root;
/*     */   private final VirtualFile rootFile;
/*     */ 
/*     */   private static File getFile(URI uri)
/*     */     throws IOException
/*     */   {
/*  66 */     if (uri == null) {
/*  67 */       throw new IllegalArgumentException("Null uri");
/*     */     }
/*  69 */     return new File(uri);
/*     */   }
/*     */ 
/*     */   private static URI getFileURI(File file)
/*     */     throws IOException
/*     */   {
/*  82 */     if (file == null)
/*  83 */       throw new IllegalArgumentException("Null file");
/*  84 */     URI url = file.toURI();
/*  85 */     String path = url.getPath();
/*  86 */     if (!file.isDirectory()) {
/*  87 */       path = VFSUtils.fixName(path);
/*     */     }
/*  90 */     else if (!path.endsWith("/")) {
/*  91 */       path = path + '/';
/*     */     }
/*     */     try
/*     */     {
/*  95 */       return new URI("file", null, path, null);
/*     */     }
/*     */     catch (URISyntaxException e)
/*     */     {
/*     */     }
/* 100 */     throw new IllegalStateException("Failed to convert file.toURI", e);
/*     */   }
/*     */ 
/*     */   public FileSystemContext(URL rootURL)
/*     */     throws IOException, URISyntaxException
/*     */   {
/* 113 */     this(VFSUtils.toURI(rootURL));
/*     */   }
/*     */ 
/*     */   public FileSystemContext(URI rootURI)
/*     */     throws IOException
/*     */   {
/* 124 */     this(rootURI, getFile(rootURI));
/*     */   }
/*     */ 
/*     */   public FileSystemContext(File file)
/*     */     throws IOException, URISyntaxException
/*     */   {
/* 137 */     this(getFileURI(file), file);
/*     */   }
/*     */ 
/*     */   private FileSystemContext(URI rootURL, File file)
/*     */     throws IOException
/*     */   {
/* 149 */     super(rootURL);
/* 150 */     this.root = createVirtualFileHandler(null, file);
/* 151 */     this.rootFile = this.root.getVirtualFile();
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler getRoot() throws IOException
/*     */   {
/* 156 */     return this.root;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, File file)
/*     */     throws IOException
/*     */   {
/* 170 */     if (file == null) {
/* 171 */       throw new IllegalArgumentException("Null file");
/*     */     }
/* 173 */     URI fileURL = getFileURI(file);
/* 174 */     if ((file.isFile()) && (JarUtils.isArchive(file.getName())))
/*     */     {
/* 176 */       String name = file.getName();
/*     */       try
/*     */       {
/* 179 */         return new JarHandler(this, parent, file, file.toURL(), name);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 183 */         this.log.debug(e.getMessage());
/*     */       }
/*     */     }
/* 186 */     return createVirtualFileHandler(parent, file, fileURL);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createVirtualFileHandler(VirtualFileHandler parent, File file, URI uri)
/*     */     throws IOException
/*     */   {
/* 202 */     if (file == null)
/* 203 */       throw new IllegalArgumentException("Null file");
/* 204 */     if (uri == null) {
/* 205 */       throw new IllegalArgumentException("Null uri");
/*     */     }
/* 207 */     VirtualFileHandler handler = null;
/* 208 */     if (VFSUtils.isLink(file.getName()))
/*     */     {
/* 210 */       Properties props = new Properties();
/* 211 */       FileInputStream fis = new FileInputStream(file);
/*     */       try
/*     */       {
/* 214 */         List links = VFSUtils.readLinkInfo(fis, file.getName(), props);
/* 215 */         String name = props.getProperty("vfs.link.name", "link");
/* 216 */         handler = new LinkHandler(this, parent, uri, name, links);
/*     */       }
/*     */       catch (URISyntaxException e)
/*     */       {
/* 220 */         IOException ex = new IOException("Failed to parse link URIs");
/* 221 */         ex.initCause(e);
/* 222 */         throw ex;
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 228 */           fis.close();
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 232 */           this.log.debug("Exception closing file input stream: " + fis, e);
/*     */         }
/*     */       }
/*     */     }
/* 236 */     else if ((!file.exists()) && (parent != null))
/*     */     {
/* 239 */       List children = parent.getChildren(true);
/* 240 */       for (VirtualFileHandler vfh : children)
/*     */       {
/* 242 */         if (vfh.getName().equals(file.getName()))
/*     */         {
/* 244 */           handler = vfh;
/* 245 */           break;
/*     */         }
/*     */       }
/* 248 */       if (handler == null)
/* 249 */         throw new FileNotFoundException("File does not exist: " + file.getCanonicalPath());
/*     */     }
/*     */     else
/*     */     {
/* 253 */       handler = new FileHandler(this, parent, file, uri);
/*     */     }
/* 255 */     return handler;
/*     */   }
/*     */ 
/*     */   protected void finalize()
/*     */     throws Throwable
/*     */   {
/* 261 */     if (this.rootFile != null)
/* 262 */       this.rootFile.close();
/* 263 */     super.finalize();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.file.FileSystemContext
 * JD-Core Version:    0.6.0
 */