/*     */ package org.jboss.virtual.plugins.context.file;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URI;
/*     */ import java.net.URISyntaxException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.virtual.plugins.context.AbstractURLHandler;
/*     */ import org.jboss.virtual.plugins.context.StructuredVirtualFileHandler;
/*     */ import org.jboss.virtual.spi.VirtualFileHandler;
/*     */ 
/*     */ public class FileHandler extends AbstractURLHandler
/*     */   implements StructuredVirtualFileHandler
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private transient File file;
/*  56 */   private transient Map<String, VirtualFileHandler> childCache = Collections.synchronizedMap(new HashMap());
/*     */ 
/*     */   public FileHandler(FileSystemContext context, VirtualFileHandler parent, File file, URL url)
/*     */     throws IOException
/*     */   {
/*  70 */     super(context, parent, url, file.getName());
/*     */ 
/*  72 */     this.file = file;
/*  73 */     if (!file.exists())
/*  74 */       throw new FileNotFoundException("File does not exist: " + file.getCanonicalPath());
/*  75 */     this.vfsUrl = new URL("vfs" + url.toString());
/*     */   }
/*     */ 
/*     */   public FileHandler(FileSystemContext context, VirtualFileHandler parent, File file, URI uri)
/*     */     throws IOException
/*     */   {
/*  89 */     this(context, parent, file, uri.toURL());
/*     */   }
/*     */ 
/*     */   public URL toVfsUrl()
/*     */     throws MalformedURLException, URISyntaxException
/*     */   {
/*  95 */     if (this.vfsUrl == null)
/*     */     {
/*  97 */       this.vfsUrl = new URL("vfs" + getURL().toString());
/*     */     }
/*  99 */     return this.vfsUrl;
/*     */   }
/*     */ 
/*     */   public FileSystemContext getVFSContext()
/*     */   {
/* 105 */     return (FileSystemContext)super.getVFSContext();
/*     */   }
/*     */ 
/*     */   protected File getFile()
/*     */   {
/* 115 */     checkClosed();
/* 116 */     return this.file;
/*     */   }
/*     */ 
/*     */   public long getLastModified()
/*     */   {
/* 122 */     return getFile().lastModified();
/*     */   }
/*     */ 
/*     */   public long getSize()
/*     */   {
/* 128 */     return getFile().length();
/*     */   }
/*     */ 
/*     */   public boolean isLeaf()
/*     */   {
/* 133 */     return getFile().isFile();
/*     */   }
/*     */ 
/*     */   public boolean isHidden()
/*     */   {
/* 138 */     return getFile().isHidden();
/*     */   }
/*     */ 
/*     */   public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException
/*     */   {
/* 143 */     File parent = getFile();
/* 144 */     File[] files = parent.listFiles();
/* 145 */     if (files == null) {
/* 146 */       throw new IOException("Error listing files: " + parent.getCanonicalPath());
/*     */     }
/* 148 */     List tmpFiles = new ArrayList();
/* 149 */     for (File file : files)
/*     */     {
/* 151 */       if (file.canRead() == true)
/* 152 */         tmpFiles.add(file);
/*     */     }
/* 154 */     if (tmpFiles.isEmpty()) {
/* 155 */       return Collections.emptyList();
/*     */     }
/* 157 */     files = (File[])tmpFiles.toArray(new File[tmpFiles.size()]);
/* 158 */     FileSystemContext context = getVFSContext();
/*     */ 
/* 160 */     List result = new ArrayList();
/* 161 */     Map newCache = Collections.synchronizedMap(new HashMap());
/* 162 */     Map oldCache = this.childCache;
/*     */ 
/* 166 */     for (File file : files)
/*     */     {
/*     */       try
/*     */       {
/* 171 */         VirtualFileHandler handler = (VirtualFileHandler)oldCache.get(file.getName());
/*     */ 
/* 173 */         if ((handler != null) && (handler.hasBeenModified()))
/*     */         {
/* 175 */           handler = null;
/*     */         }
/* 177 */         if (handler == null)
/*     */         {
/* 179 */           handler = context.createVirtualFileHandler(this, file);
/*     */         }
/* 181 */         result.add(handler);
/* 182 */         newCache.put(file.getName(), handler);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 186 */         if (ignoreErrors)
/* 187 */           log.trace("Ignored: " + e);
/*     */         else {
/* 189 */           throw e;
/*     */         }
/*     */       }
/*     */     }
/* 193 */     this.childCache = newCache;
/* 194 */     return result;
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler findChild(String path) throws IOException
/*     */   {
/* 199 */     return structuredFindChild(path);
/*     */   }
/*     */ 
/*     */   public VirtualFileHandler createChildHandler(String name) throws IOException
/*     */   {
/* 204 */     FileSystemContext context = getVFSContext();
/* 205 */     File parentFile = getFile();
/* 206 */     File child = new File(parentFile, name);
/* 207 */     VirtualFileHandler handler = (VirtualFileHandler)this.childCache.get(name);
/*     */ 
/* 210 */     if ((handler != null) && (handler.hasBeenModified()))
/*     */     {
/* 212 */       handler = null;
/*     */     }
/* 214 */     if (handler == null)
/*     */     {
/* 216 */       handler = context.createVirtualFileHandler(this, child);
/* 217 */       this.childCache.put(name, handler);
/*     */     }
/* 219 */     return handler;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 225 */     in.defaultReadObject();
/*     */ 
/* 227 */     this.file = new File(getURL().getPath());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.file.FileHandler
 * JD-Core Version:    0.6.0
 */