/*    */ package org.jboss.virtual.plugins.context;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.Serializable;
/*    */ import java.net.URI;
/*    */ import org.jboss.virtual.spi.VFSContext;
/*    */ import org.jboss.virtual.spi.VirtualFileHandler;
/*    */ 
/*    */ public abstract class AbstractURIHandler extends AbstractVirtualFileHandler
/*    */   implements Serializable
/*    */ {
/*    */   private static final long serialVersionUID = 1L;
/*    */   private final URI uri;
/*    */ 
/*    */   public AbstractURIHandler(VFSContext context, VirtualFileHandler parent, URI uri, String name)
/*    */   {
/* 57 */     super(context, parent, name);
/* 58 */     if (uri == null)
/* 59 */       throw new IllegalArgumentException("Null uri");
/* 60 */     this.uri = uri;
/*    */   }
/*    */ 
/*    */   public URI getURI()
/*    */   {
/* 70 */     return this.uri;
/*    */   }
/*    */ 
/*    */   public long getLastModified() throws IOException
/*    */   {
/* 75 */     checkClosed();
/* 76 */     return 0L;
/*    */   }
/*    */ 
/*    */   public long getSize() throws IOException
/*    */   {
/* 81 */     checkClosed();
/* 82 */     return 0L;
/*    */   }
/*    */ 
/*    */   public boolean isHidden() throws IOException
/*    */   {
/* 87 */     checkClosed();
/* 88 */     return false;
/*    */   }
/*    */ 
/*    */   public InputStream openStream() throws IOException
/*    */   {
/* 93 */     checkClosed();
/* 94 */     return null;
/*    */   }
/*    */ 
/*    */   public URI toURI()
/*    */   {
/* 99 */     return this.uri;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.AbstractURIHandler
 * JD-Core Version:    0.6.0
 */