/*    */ package org.jboss.virtual.plugins.context;
/*    */ 
/*    */ import java.net.MalformedURLException;
/*    */ import java.net.URI;
/*    */ import java.net.URISyntaxException;
/*    */ import java.net.URL;
/*    */ import org.jboss.virtual.spi.VFSContextFactory;
/*    */ 
/*    */ public abstract class AbstractContextFactory
/*    */   implements VFSContextFactory
/*    */ {
/*    */   private String[] protocols;
/*    */ 
/*    */   protected AbstractContextFactory(String[] protocols)
/*    */   {
/* 42 */     this.protocols = protocols;
/*    */   }
/*    */ 
/*    */   public String[] getProtocols()
/*    */   {
/* 47 */     return this.protocols;
/*    */   }
/*    */ 
/*    */   protected static URL fromVFS(URL url)
/*    */     throws MalformedURLException
/*    */   {
/* 59 */     String externalForm = url.toExternalForm();
/* 60 */     if (externalForm.startsWith("vfs")) {
/* 61 */       return new URL(externalForm.substring(3));
/*    */     }
/* 63 */     return url;
/*    */   }
/*    */ 
/*    */   protected static URI fromVFS(URI uri)
/*    */     throws URISyntaxException
/*    */   {
/* 75 */     String scheme = uri.getScheme();
/* 76 */     if (scheme.startsWith("vfs")) {
/* 77 */       return new URI(scheme.substring(3), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
/*    */     }
/*    */ 
/* 87 */     return uri;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.virtual.plugins.context.AbstractContextFactory
 * JD-Core Version:    0.6.0
 */